/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that control the generation of synthetic data for machine learning, including privacy settings and column
 * classification details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MLSyntheticDataParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<MLSyntheticDataParameters.Builder, MLSyntheticDataParameters> {
    private static final SdkField<Double> EPSILON_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("epsilon")
            .getter(getter(MLSyntheticDataParameters::epsilon)).setter(setter(Builder::epsilon))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epsilon").build()).build();

    private static final SdkField<Double> MAX_MEMBERSHIP_INFERENCE_ATTACK_SCORE_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("maxMembershipInferenceAttackScore")
            .getter(getter(MLSyntheticDataParameters::maxMembershipInferenceAttackScore))
            .setter(setter(Builder::maxMembershipInferenceAttackScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMembershipInferenceAttackScore")
                    .build()).build();

    private static final SdkField<ColumnClassificationDetails> COLUMN_CLASSIFICATION_FIELD = SdkField
            .<ColumnClassificationDetails> builder(MarshallingType.SDK_POJO).memberName("columnClassification")
            .getter(getter(MLSyntheticDataParameters::columnClassification)).setter(setter(Builder::columnClassification))
            .constructor(ColumnClassificationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnClassification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPSILON_FIELD,
            MAX_MEMBERSHIP_INFERENCE_ATTACK_SCORE_FIELD, COLUMN_CLASSIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double epsilon;

    private final Double maxMembershipInferenceAttackScore;

    private final ColumnClassificationDetails columnClassification;

    private MLSyntheticDataParameters(BuilderImpl builder) {
        this.epsilon = builder.epsilon;
        this.maxMembershipInferenceAttackScore = builder.maxMembershipInferenceAttackScore;
        this.columnClassification = builder.columnClassification;
    }

    /**
     * <p>
     * The epsilon value for differential privacy when generating synthetic data. Lower values provide stronger privacy
     * guarantees but may reduce data utility.
     * </p>
     * 
     * @return The epsilon value for differential privacy when generating synthetic data. Lower values provide stronger
     *         privacy guarantees but may reduce data utility.
     */
    public final Double epsilon() {
        return epsilon;
    }

    /**
     * <p>
     * The maximum acceptable score for membership inference attack vulnerability. Synthetic data generation fails if
     * the score for the resulting data exceeds this threshold.
     * </p>
     * 
     * @return The maximum acceptable score for membership inference attack vulnerability. Synthetic data generation
     *         fails if the score for the resulting data exceeds this threshold.
     */
    public final Double maxMembershipInferenceAttackScore() {
        return maxMembershipInferenceAttackScore;
    }

    /**
     * <p>
     * Classification details for data columns that specify how each column should be treated during synthetic data
     * generation.
     * </p>
     * 
     * @return Classification details for data columns that specify how each column should be treated during synthetic
     *         data generation.
     */
    public final ColumnClassificationDetails columnClassification() {
        return columnClassification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(epsilon());
        hashCode = 31 * hashCode + Objects.hashCode(maxMembershipInferenceAttackScore());
        hashCode = 31 * hashCode + Objects.hashCode(columnClassification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLSyntheticDataParameters)) {
            return false;
        }
        MLSyntheticDataParameters other = (MLSyntheticDataParameters) obj;
        return Objects.equals(epsilon(), other.epsilon())
                && Objects.equals(maxMembershipInferenceAttackScore(), other.maxMembershipInferenceAttackScore())
                && Objects.equals(columnClassification(), other.columnClassification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MLSyntheticDataParameters").add("Epsilon", epsilon())
                .add("MaxMembershipInferenceAttackScore", maxMembershipInferenceAttackScore())
                .add("ColumnClassification", columnClassification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "epsilon":
            return Optional.ofNullable(clazz.cast(epsilon()));
        case "maxMembershipInferenceAttackScore":
            return Optional.ofNullable(clazz.cast(maxMembershipInferenceAttackScore()));
        case "columnClassification":
            return Optional.ofNullable(clazz.cast(columnClassification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("epsilon", EPSILON_FIELD);
        map.put("maxMembershipInferenceAttackScore", MAX_MEMBERSHIP_INFERENCE_ATTACK_SCORE_FIELD);
        map.put("columnClassification", COLUMN_CLASSIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MLSyntheticDataParameters, T> g) {
        return obj -> g.apply((MLSyntheticDataParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MLSyntheticDataParameters> {
        /**
         * <p>
         * The epsilon value for differential privacy when generating synthetic data. Lower values provide stronger
         * privacy guarantees but may reduce data utility.
         * </p>
         * 
         * @param epsilon
         *        The epsilon value for differential privacy when generating synthetic data. Lower values provide
         *        stronger privacy guarantees but may reduce data utility.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epsilon(Double epsilon);

        /**
         * <p>
         * The maximum acceptable score for membership inference attack vulnerability. Synthetic data generation fails
         * if the score for the resulting data exceeds this threshold.
         * </p>
         * 
         * @param maxMembershipInferenceAttackScore
         *        The maximum acceptable score for membership inference attack vulnerability. Synthetic data generation
         *        fails if the score for the resulting data exceeds this threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMembershipInferenceAttackScore(Double maxMembershipInferenceAttackScore);

        /**
         * <p>
         * Classification details for data columns that specify how each column should be treated during synthetic data
         * generation.
         * </p>
         * 
         * @param columnClassification
         *        Classification details for data columns that specify how each column should be treated during
         *        synthetic data generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnClassification(ColumnClassificationDetails columnClassification);

        /**
         * <p>
         * Classification details for data columns that specify how each column should be treated during synthetic data
         * generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnClassificationDetails.Builder}
         * avoiding the need to create one manually via {@link ColumnClassificationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnClassificationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #columnClassification(ColumnClassificationDetails)}.
         * 
         * @param columnClassification
         *        a consumer that will call methods on {@link ColumnClassificationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnClassification(ColumnClassificationDetails)
         */
        default Builder columnClassification(Consumer<ColumnClassificationDetails.Builder> columnClassification) {
            return columnClassification(ColumnClassificationDetails.builder().applyMutation(columnClassification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Double epsilon;

        private Double maxMembershipInferenceAttackScore;

        private ColumnClassificationDetails columnClassification;

        private BuilderImpl() {
        }

        private BuilderImpl(MLSyntheticDataParameters model) {
            epsilon(model.epsilon);
            maxMembershipInferenceAttackScore(model.maxMembershipInferenceAttackScore);
            columnClassification(model.columnClassification);
        }

        public final Double getEpsilon() {
            return epsilon;
        }

        public final void setEpsilon(Double epsilon) {
            this.epsilon = epsilon;
        }

        @Override
        public final Builder epsilon(Double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public final Double getMaxMembershipInferenceAttackScore() {
            return maxMembershipInferenceAttackScore;
        }

        public final void setMaxMembershipInferenceAttackScore(Double maxMembershipInferenceAttackScore) {
            this.maxMembershipInferenceAttackScore = maxMembershipInferenceAttackScore;
        }

        @Override
        public final Builder maxMembershipInferenceAttackScore(Double maxMembershipInferenceAttackScore) {
            this.maxMembershipInferenceAttackScore = maxMembershipInferenceAttackScore;
            return this;
        }

        public final ColumnClassificationDetails.Builder getColumnClassification() {
            return columnClassification != null ? columnClassification.toBuilder() : null;
        }

        public final void setColumnClassification(ColumnClassificationDetails.BuilderImpl columnClassification) {
            this.columnClassification = columnClassification != null ? columnClassification.build() : null;
        }

        @Override
        public final Builder columnClassification(ColumnClassificationDetails columnClassification) {
            this.columnClassification = columnClassification;
            return this;
        }

        @Override
        public MLSyntheticDataParameters build() {
            return new MLSyntheticDataParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
