/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ML member abilities for a collaboration member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MLMemberAbilities implements SdkPojo, Serializable,
        ToCopyableBuilder<MLMemberAbilities.Builder, MLMemberAbilities> {
    private static final SdkField<List<String>> CUSTOM_ML_MEMBER_ABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("customMLMemberAbilities")
            .getter(getter(MLMemberAbilities::customMLMemberAbilitiesAsStrings))
            .setter(setter(Builder::customMLMemberAbilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMLMemberAbilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_ML_MEMBER_ABILITIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> customMLMemberAbilities;

    private MLMemberAbilities(BuilderImpl builder) {
        this.customMLMemberAbilities = builder.customMLMemberAbilities;
    }

    /**
     * <p>
     * The custom ML member abilities for a collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomMLMemberAbilities} method.
     * </p>
     * 
     * @return The custom ML member abilities for a collaboration member.
     */
    public final List<CustomMLMemberAbility> customMLMemberAbilities() {
        return CustomMLMemberAbilitiesCopier.copyStringToEnum(customMLMemberAbilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomMLMemberAbilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomMLMemberAbilities() {
        return customMLMemberAbilities != null && !(customMLMemberAbilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom ML member abilities for a collaboration member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomMLMemberAbilities} method.
     * </p>
     * 
     * @return The custom ML member abilities for a collaboration member.
     */
    public final List<String> customMLMemberAbilitiesAsStrings() {
        return customMLMemberAbilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomMLMemberAbilities() ? customMLMemberAbilitiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MLMemberAbilities)) {
            return false;
        }
        MLMemberAbilities other = (MLMemberAbilities) obj;
        return hasCustomMLMemberAbilities() == other.hasCustomMLMemberAbilities()
                && Objects.equals(customMLMemberAbilitiesAsStrings(), other.customMLMemberAbilitiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MLMemberAbilities")
                .add("CustomMLMemberAbilities", hasCustomMLMemberAbilities() ? customMLMemberAbilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customMLMemberAbilities":
            return Optional.ofNullable(clazz.cast(customMLMemberAbilitiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customMLMemberAbilities", CUSTOM_ML_MEMBER_ABILITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MLMemberAbilities, T> g) {
        return obj -> g.apply((MLMemberAbilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MLMemberAbilities> {
        /**
         * <p>
         * The custom ML member abilities for a collaboration member.
         * </p>
         * 
         * @param customMLMemberAbilities
         *        The custom ML member abilities for a collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMLMemberAbilitiesWithStrings(Collection<String> customMLMemberAbilities);

        /**
         * <p>
         * The custom ML member abilities for a collaboration member.
         * </p>
         * 
         * @param customMLMemberAbilities
         *        The custom ML member abilities for a collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMLMemberAbilitiesWithStrings(String... customMLMemberAbilities);

        /**
         * <p>
         * The custom ML member abilities for a collaboration member.
         * </p>
         * 
         * @param customMLMemberAbilities
         *        The custom ML member abilities for a collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMLMemberAbilities(Collection<CustomMLMemberAbility> customMLMemberAbilities);

        /**
         * <p>
         * The custom ML member abilities for a collaboration member.
         * </p>
         * 
         * @param customMLMemberAbilities
         *        The custom ML member abilities for a collaboration member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMLMemberAbilities(CustomMLMemberAbility... customMLMemberAbilities);
    }

    static final class BuilderImpl implements Builder {
        private List<String> customMLMemberAbilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MLMemberAbilities model) {
            customMLMemberAbilitiesWithStrings(model.customMLMemberAbilities);
        }

        public final Collection<String> getCustomMLMemberAbilities() {
            if (customMLMemberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return customMLMemberAbilities;
        }

        public final void setCustomMLMemberAbilities(Collection<String> customMLMemberAbilities) {
            this.customMLMemberAbilities = CustomMLMemberAbilitiesCopier.copy(customMLMemberAbilities);
        }

        @Override
        public final Builder customMLMemberAbilitiesWithStrings(Collection<String> customMLMemberAbilities) {
            this.customMLMemberAbilities = CustomMLMemberAbilitiesCopier.copy(customMLMemberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMLMemberAbilitiesWithStrings(String... customMLMemberAbilities) {
            customMLMemberAbilitiesWithStrings(Arrays.asList(customMLMemberAbilities));
            return this;
        }

        @Override
        public final Builder customMLMemberAbilities(Collection<CustomMLMemberAbility> customMLMemberAbilities) {
            this.customMLMemberAbilities = CustomMLMemberAbilitiesCopier.copyEnumToString(customMLMemberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customMLMemberAbilities(CustomMLMemberAbility... customMLMemberAbilities) {
            customMLMemberAbilities(Arrays.asList(customMLMemberAbilities));
            return this;
        }

        @Override
        public MLMemberAbilities build() {
            return new MLMemberAbilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
