/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCollaborationPrivacyBudgetsResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<ListCollaborationPrivacyBudgetsResponse.Builder, ListCollaborationPrivacyBudgetsResponse> {
    private static final SdkField<List<CollaborationPrivacyBudgetSummary>> COLLABORATION_PRIVACY_BUDGET_SUMMARIES_FIELD = SdkField
            .<List<CollaborationPrivacyBudgetSummary>> builder(MarshallingType.LIST)
            .memberName("collaborationPrivacyBudgetSummaries")
            .getter(getter(ListCollaborationPrivacyBudgetsResponse::collaborationPrivacyBudgetSummaries))
            .setter(setter(Builder::collaborationPrivacyBudgetSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("collaborationPrivacyBudgetSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollaborationPrivacyBudgetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollaborationPrivacyBudgetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCollaborationPrivacyBudgetsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_PRIVACY_BUDGET_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CollaborationPrivacyBudgetSummary> collaborationPrivacyBudgetSummaries;

    private final String nextToken;

    private ListCollaborationPrivacyBudgetsResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationPrivacyBudgetSummaries = builder.collaborationPrivacyBudgetSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollaborationPrivacyBudgetSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCollaborationPrivacyBudgetSummaries() {
        return collaborationPrivacyBudgetSummaries != null
                && !(collaborationPrivacyBudgetSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summaries of the collaboration privacy budgets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollaborationPrivacyBudgetSummaries}
     * method.
     * </p>
     * 
     * @return Summaries of the collaboration privacy budgets.
     */
    public final List<CollaborationPrivacyBudgetSummary> collaborationPrivacyBudgetSummaries() {
        return collaborationPrivacyBudgetSummaries;
    }

    /**
     * <p>
     * The pagination token that's used to fetch the next set of results.
     * </p>
     * 
     * @return The pagination token that's used to fetch the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCollaborationPrivacyBudgetSummaries() ? collaborationPrivacyBudgetSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCollaborationPrivacyBudgetsResponse)) {
            return false;
        }
        ListCollaborationPrivacyBudgetsResponse other = (ListCollaborationPrivacyBudgetsResponse) obj;
        return hasCollaborationPrivacyBudgetSummaries() == other.hasCollaborationPrivacyBudgetSummaries()
                && Objects.equals(collaborationPrivacyBudgetSummaries(), other.collaborationPrivacyBudgetSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListCollaborationPrivacyBudgetsResponse")
                .add("CollaborationPrivacyBudgetSummaries",
                        hasCollaborationPrivacyBudgetSummaries() ? collaborationPrivacyBudgetSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationPrivacyBudgetSummaries":
            return Optional.ofNullable(clazz.cast(collaborationPrivacyBudgetSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationPrivacyBudgetSummaries", COLLABORATION_PRIVACY_BUDGET_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCollaborationPrivacyBudgetsResponse, T> g) {
        return obj -> g.apply((ListCollaborationPrivacyBudgetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCollaborationPrivacyBudgetsResponse> {
        /**
         * <p>
         * Summaries of the collaboration privacy budgets.
         * </p>
         * 
         * @param collaborationPrivacyBudgetSummaries
         *        Summaries of the collaboration privacy budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationPrivacyBudgetSummaries(
                Collection<CollaborationPrivacyBudgetSummary> collaborationPrivacyBudgetSummaries);

        /**
         * <p>
         * Summaries of the collaboration privacy budgets.
         * </p>
         * 
         * @param collaborationPrivacyBudgetSummaries
         *        Summaries of the collaboration privacy budgets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationPrivacyBudgetSummaries(CollaborationPrivacyBudgetSummary... collaborationPrivacyBudgetSummaries);

        /**
         * <p>
         * Summaries of the collaboration privacy budgets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #collaborationPrivacyBudgetSummaries(List<CollaborationPrivacyBudgetSummary>)}.
         * 
         * @param collaborationPrivacyBudgetSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.CollaborationPrivacyBudgetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationPrivacyBudgetSummaries(java.util.Collection<CollaborationPrivacyBudgetSummary>)
         */
        Builder collaborationPrivacyBudgetSummaries(
                Consumer<CollaborationPrivacyBudgetSummary.Builder>... collaborationPrivacyBudgetSummaries);

        /**
         * <p>
         * The pagination token that's used to fetch the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's used to fetch the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private List<CollaborationPrivacyBudgetSummary> collaborationPrivacyBudgetSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCollaborationPrivacyBudgetsResponse model) {
            super(model);
            collaborationPrivacyBudgetSummaries(model.collaborationPrivacyBudgetSummaries);
            nextToken(model.nextToken);
        }

        public final List<CollaborationPrivacyBudgetSummary.Builder> getCollaborationPrivacyBudgetSummaries() {
            List<CollaborationPrivacyBudgetSummary.Builder> result = CollaborationPrivacyBudgetSummaryListCopier
                    .copyToBuilder(this.collaborationPrivacyBudgetSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollaborationPrivacyBudgetSummaries(
                Collection<CollaborationPrivacyBudgetSummary.BuilderImpl> collaborationPrivacyBudgetSummaries) {
            this.collaborationPrivacyBudgetSummaries = CollaborationPrivacyBudgetSummaryListCopier
                    .copyFromBuilder(collaborationPrivacyBudgetSummaries);
        }

        @Override
        public final Builder collaborationPrivacyBudgetSummaries(
                Collection<CollaborationPrivacyBudgetSummary> collaborationPrivacyBudgetSummaries) {
            this.collaborationPrivacyBudgetSummaries = CollaborationPrivacyBudgetSummaryListCopier
                    .copy(collaborationPrivacyBudgetSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationPrivacyBudgetSummaries(
                CollaborationPrivacyBudgetSummary... collaborationPrivacyBudgetSummaries) {
            collaborationPrivacyBudgetSummaries(Arrays.asList(collaborationPrivacyBudgetSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collaborationPrivacyBudgetSummaries(
                Consumer<CollaborationPrivacyBudgetSummary.Builder>... collaborationPrivacyBudgetSummaries) {
            collaborationPrivacyBudgetSummaries(Stream.of(collaborationPrivacyBudgetSummaries)
                    .map(c -> CollaborationPrivacyBudgetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCollaborationPrivacyBudgetsResponse build() {
            return new ListCollaborationPrivacyBudgetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
