/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSchemaAnalysisRuleResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetSchemaAnalysisRuleResponse.Builder, GetSchemaAnalysisRuleResponse> {
    private static final SdkField<AnalysisRule> ANALYSIS_RULE_FIELD = SdkField.<AnalysisRule> builder(MarshallingType.SDK_POJO)
            .memberName("analysisRule").getter(getter(GetSchemaAnalysisRuleResponse::analysisRule))
            .setter(setter(Builder::analysisRule)).constructor(AnalysisRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisRule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AnalysisRule analysisRule;

    private GetSchemaAnalysisRuleResponse(BuilderImpl builder) {
        super(builder);
        this.analysisRule = builder.analysisRule;
    }

    /**
     * <p>
     * A specification about how data from the configured table can be used.
     * </p>
     * 
     * @return A specification about how data from the configured table can be used.
     */
    public final AnalysisRule analysisRule() {
        return analysisRule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisRule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaAnalysisRuleResponse)) {
            return false;
        }
        GetSchemaAnalysisRuleResponse other = (GetSchemaAnalysisRuleResponse) obj;
        return Objects.equals(analysisRule(), other.analysisRule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSchemaAnalysisRuleResponse").add("AnalysisRule", analysisRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analysisRule":
            return Optional.ofNullable(clazz.cast(analysisRule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analysisRule", ANALYSIS_RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaAnalysisRuleResponse, T> g) {
        return obj -> g.apply((GetSchemaAnalysisRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSchemaAnalysisRuleResponse> {
        /**
         * <p>
         * A specification about how data from the configured table can be used.
         * </p>
         * 
         * @param analysisRule
         *        A specification about how data from the configured table can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisRule(AnalysisRule analysisRule);

        /**
         * <p>
         * A specification about how data from the configured table can be used.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRule.Builder} avoiding the need
         * to create one manually via {@link AnalysisRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisRule.Builder#build()} is called immediately and its
         * result is passed to {@link #analysisRule(AnalysisRule)}.
         * 
         * @param analysisRule
         *        a consumer that will call methods on {@link AnalysisRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisRule(AnalysisRule)
         */
        default Builder analysisRule(Consumer<AnalysisRule.Builder> analysisRule) {
            return analysisRule(AnalysisRule.builder().applyMutation(analysisRule).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private AnalysisRule analysisRule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaAnalysisRuleResponse model) {
            super(model);
            analysisRule(model.analysisRule);
        }

        public final AnalysisRule.Builder getAnalysisRule() {
            return analysisRule != null ? analysisRule.toBuilder() : null;
        }

        public final void setAnalysisRule(AnalysisRule.BuilderImpl analysisRule) {
            this.analysisRule = analysisRule != null ? analysisRule.build() : null;
        }

        @Override
        public final Builder analysisRule(AnalysisRule analysisRule) {
            this.analysisRule = analysisRule;
            return this;
        }

        @Override
        public GetSchemaAnalysisRuleResponse build() {
            return new GetSchemaAnalysisRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
