/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPrivacyBudgetTemplateResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetPrivacyBudgetTemplateResponse.Builder, GetPrivacyBudgetTemplateResponse> {
    private static final SdkField<PrivacyBudgetTemplate> PRIVACY_BUDGET_TEMPLATE_FIELD = SdkField
            .<PrivacyBudgetTemplate> builder(MarshallingType.SDK_POJO).memberName("privacyBudgetTemplate")
            .getter(getter(GetPrivacyBudgetTemplateResponse::privacyBudgetTemplate))
            .setter(setter(Builder::privacyBudgetTemplate)).constructor(PrivacyBudgetTemplate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privacyBudgetTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(PRIVACY_BUDGET_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final PrivacyBudgetTemplate privacyBudgetTemplate;

    private GetPrivacyBudgetTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.privacyBudgetTemplate = builder.privacyBudgetTemplate;
    }

    /**
     * <p>
     * Returns the details of the privacy budget template that you requested.
     * </p>
     * 
     * @return Returns the details of the privacy budget template that you requested.
     */
    public final PrivacyBudgetTemplate privacyBudgetTemplate() {
        return privacyBudgetTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(privacyBudgetTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPrivacyBudgetTemplateResponse)) {
            return false;
        }
        GetPrivacyBudgetTemplateResponse other = (GetPrivacyBudgetTemplateResponse) obj;
        return Objects.equals(privacyBudgetTemplate(), other.privacyBudgetTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPrivacyBudgetTemplateResponse").add("PrivacyBudgetTemplate", privacyBudgetTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "privacyBudgetTemplate":
            return Optional.ofNullable(clazz.cast(privacyBudgetTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("privacyBudgetTemplate", PRIVACY_BUDGET_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPrivacyBudgetTemplateResponse, T> g) {
        return obj -> g.apply((GetPrivacyBudgetTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetPrivacyBudgetTemplateResponse> {
        /**
         * <p>
         * Returns the details of the privacy budget template that you requested.
         * </p>
         * 
         * @param privacyBudgetTemplate
         *        Returns the details of the privacy budget template that you requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privacyBudgetTemplate(PrivacyBudgetTemplate privacyBudgetTemplate);

        /**
         * <p>
         * Returns the details of the privacy budget template that you requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrivacyBudgetTemplate.Builder} avoiding
         * the need to create one manually via {@link PrivacyBudgetTemplate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrivacyBudgetTemplate.Builder#build()} is called immediately and
         * its result is passed to {@link #privacyBudgetTemplate(PrivacyBudgetTemplate)}.
         * 
         * @param privacyBudgetTemplate
         *        a consumer that will call methods on {@link PrivacyBudgetTemplate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privacyBudgetTemplate(PrivacyBudgetTemplate)
         */
        default Builder privacyBudgetTemplate(Consumer<PrivacyBudgetTemplate.Builder> privacyBudgetTemplate) {
            return privacyBudgetTemplate(PrivacyBudgetTemplate.builder().applyMutation(privacyBudgetTemplate).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private PrivacyBudgetTemplate privacyBudgetTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPrivacyBudgetTemplateResponse model) {
            super(model);
            privacyBudgetTemplate(model.privacyBudgetTemplate);
        }

        public final PrivacyBudgetTemplate.Builder getPrivacyBudgetTemplate() {
            return privacyBudgetTemplate != null ? privacyBudgetTemplate.toBuilder() : null;
        }

        public final void setPrivacyBudgetTemplate(PrivacyBudgetTemplate.BuilderImpl privacyBudgetTemplate) {
            this.privacyBudgetTemplate = privacyBudgetTemplate != null ? privacyBudgetTemplate.build() : null;
        }

        @Override
        public final Builder privacyBudgetTemplate(PrivacyBudgetTemplate privacyBudgetTemplate) {
            this.privacyBudgetTemplate = privacyBudgetTemplate;
            return this;
        }

        @Override
        public GetPrivacyBudgetTemplateResponse build() {
            return new GetPrivacyBudgetTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
