/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationChangeRequestResponse extends CleanRoomsResponse implements
        ToCopyableBuilder<GetCollaborationChangeRequestResponse.Builder, GetCollaborationChangeRequestResponse> {
    private static final SdkField<CollaborationChangeRequest> COLLABORATION_CHANGE_REQUEST_FIELD = SdkField
            .<CollaborationChangeRequest> builder(MarshallingType.SDK_POJO)
            .memberName("collaborationChangeRequest")
            .getter(getter(GetCollaborationChangeRequestResponse::collaborationChangeRequest))
            .setter(setter(Builder::collaborationChangeRequest))
            .constructor(CollaborationChangeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationChangeRequest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLLABORATION_CHANGE_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CollaborationChangeRequest collaborationChangeRequest;

    private GetCollaborationChangeRequestResponse(BuilderImpl builder) {
        super(builder);
        this.collaborationChangeRequest = builder.collaborationChangeRequest;
    }

    /**
     * <p>
     * The collaboration change request that was requested.
     * </p>
     * 
     * @return The collaboration change request that was requested.
     */
    public final CollaborationChangeRequest collaborationChangeRequest() {
        return collaborationChangeRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationChangeRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationChangeRequestResponse)) {
            return false;
        }
        GetCollaborationChangeRequestResponse other = (GetCollaborationChangeRequestResponse) obj;
        return Objects.equals(collaborationChangeRequest(), other.collaborationChangeRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationChangeRequestResponse")
                .add("CollaborationChangeRequest", collaborationChangeRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationChangeRequest":
            return Optional.ofNullable(clazz.cast(collaborationChangeRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationChangeRequest", COLLABORATION_CHANGE_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationChangeRequestResponse, T> g) {
        return obj -> g.apply((GetCollaborationChangeRequestResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationChangeRequestResponse> {
        /**
         * <p>
         * The collaboration change request that was requested.
         * </p>
         * 
         * @param collaborationChangeRequest
         *        The collaboration change request that was requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationChangeRequest(CollaborationChangeRequest collaborationChangeRequest);

        /**
         * <p>
         * The collaboration change request that was requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollaborationChangeRequest.Builder}
         * avoiding the need to create one manually via {@link CollaborationChangeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollaborationChangeRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #collaborationChangeRequest(CollaborationChangeRequest)}.
         * 
         * @param collaborationChangeRequest
         *        a consumer that will call methods on {@link CollaborationChangeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collaborationChangeRequest(CollaborationChangeRequest)
         */
        default Builder collaborationChangeRequest(Consumer<CollaborationChangeRequest.Builder> collaborationChangeRequest) {
            return collaborationChangeRequest(CollaborationChangeRequest.builder().applyMutation(collaborationChangeRequest)
                    .build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private CollaborationChangeRequest collaborationChangeRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationChangeRequestResponse model) {
            super(model);
            collaborationChangeRequest(model.collaborationChangeRequest);
        }

        public final CollaborationChangeRequest.Builder getCollaborationChangeRequest() {
            return collaborationChangeRequest != null ? collaborationChangeRequest.toBuilder() : null;
        }

        public final void setCollaborationChangeRequest(CollaborationChangeRequest.BuilderImpl collaborationChangeRequest) {
            this.collaborationChangeRequest = collaborationChangeRequest != null ? collaborationChangeRequest.build() : null;
        }

        @Override
        public final Builder collaborationChangeRequest(CollaborationChangeRequest collaborationChangeRequest) {
            this.collaborationChangeRequest = collaborationChangeRequest;
            return this;
        }

        @Override
        public GetCollaborationChangeRequestResponse build() {
            return new GetCollaborationChangeRequestResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
