/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCollaborationChangeRequestRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<GetCollaborationChangeRequestRequest.Builder, GetCollaborationChangeRequestRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(GetCollaborationChangeRequestRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> CHANGE_REQUEST_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("changeRequestIdentifier").getter(getter(GetCollaborationChangeRequestRequest::changeRequestIdentifier))
            .setter(setter(Builder::changeRequestIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("changeRequestIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, CHANGE_REQUEST_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collaborationIdentifier;

    private final String changeRequestIdentifier;

    private GetCollaborationChangeRequestRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.changeRequestIdentifier = builder.changeRequestIdentifier;
    }

    /**
     * <p>
     * The identifier of the collaboration that the change request is made against.
     * </p>
     * 
     * @return The identifier of the collaboration that the change request is made against.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * A unique identifier for the change request to retrieve.
     * </p>
     * 
     * @return A unique identifier for the change request to retrieve.
     */
    public final String changeRequestIdentifier() {
        return changeRequestIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(changeRequestIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationChangeRequestRequest)) {
            return false;
        }
        GetCollaborationChangeRequestRequest other = (GetCollaborationChangeRequestRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(changeRequestIdentifier(), other.changeRequestIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCollaborationChangeRequestRequest").add("CollaborationIdentifier", collaborationIdentifier())
                .add("ChangeRequestIdentifier", changeRequestIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "changeRequestIdentifier":
            return Optional.ofNullable(clazz.cast(changeRequestIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("changeRequestIdentifier", CHANGE_REQUEST_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationChangeRequestRequest, T> g) {
        return obj -> g.apply((GetCollaborationChangeRequestRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCollaborationChangeRequestRequest> {
        /**
         * <p>
         * The identifier of the collaboration that the change request is made against.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The identifier of the collaboration that the change request is made against.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * A unique identifier for the change request to retrieve.
         * </p>
         * 
         * @param changeRequestIdentifier
         *        A unique identifier for the change request to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeRequestIdentifier(String changeRequestIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private String changeRequestIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationChangeRequestRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            changeRequestIdentifier(model.changeRequestIdentifier);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getChangeRequestIdentifier() {
            return changeRequestIdentifier;
        }

        public final void setChangeRequestIdentifier(String changeRequestIdentifier) {
            this.changeRequestIdentifier = changeRequestIdentifier;
        }

        @Override
        public final Builder changeRequestIdentifier(String changeRequestIdentifier) {
            this.changeRequestIdentifier = changeRequestIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCollaborationChangeRequestRequest build() {
            return new GetCollaborationChangeRequestRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
