/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The direct analysis configuration details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectAnalysisConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectAnalysisConfigurationDetails.Builder, DirectAnalysisConfigurationDetails> {
    private static final SdkField<List<String>> RECEIVER_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("receiverAccountIds")
            .getter(getter(DirectAnalysisConfigurationDetails::receiverAccountIds))
            .setter(setter(Builder::receiverAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("receiverAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECEIVER_ACCOUNT_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> receiverAccountIds;

    private DirectAnalysisConfigurationDetails(BuilderImpl builder) {
        this.receiverAccountIds = builder.receiverAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReceiverAccountIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReceiverAccountIds() {
        return receiverAccountIds != null && !(receiverAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The account IDs for the member who received the results of a protected query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReceiverAccountIds} method.
     * </p>
     * 
     * @return The account IDs for the member who received the results of a protected query.
     */
    public final List<String> receiverAccountIds() {
        return receiverAccountIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasReceiverAccountIds() ? receiverAccountIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectAnalysisConfigurationDetails)) {
            return false;
        }
        DirectAnalysisConfigurationDetails other = (DirectAnalysisConfigurationDetails) obj;
        return hasReceiverAccountIds() == other.hasReceiverAccountIds()
                && Objects.equals(receiverAccountIds(), other.receiverAccountIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectAnalysisConfigurationDetails")
                .add("ReceiverAccountIds", hasReceiverAccountIds() ? receiverAccountIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "receiverAccountIds":
            return Optional.ofNullable(clazz.cast(receiverAccountIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("receiverAccountIds", RECEIVER_ACCOUNT_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectAnalysisConfigurationDetails, T> g) {
        return obj -> g.apply((DirectAnalysisConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectAnalysisConfigurationDetails> {
        /**
         * <p>
         * The account IDs for the member who received the results of a protected query.
         * </p>
         * 
         * @param receiverAccountIds
         *        The account IDs for the member who received the results of a protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverAccountIds(Collection<String> receiverAccountIds);

        /**
         * <p>
         * The account IDs for the member who received the results of a protected query.
         * </p>
         * 
         * @param receiverAccountIds
         *        The account IDs for the member who received the results of a protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverAccountIds(String... receiverAccountIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> receiverAccountIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DirectAnalysisConfigurationDetails model) {
            receiverAccountIds(model.receiverAccountIds);
        }

        public final Collection<String> getReceiverAccountIds() {
            if (receiverAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return receiverAccountIds;
        }

        public final void setReceiverAccountIds(Collection<String> receiverAccountIds) {
            this.receiverAccountIds = ReceiverAccountIdsCopier.copy(receiverAccountIds);
        }

        @Override
        public final Builder receiverAccountIds(Collection<String> receiverAccountIds) {
            this.receiverAccountIds = ReceiverAccountIdsCopier.copy(receiverAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverAccountIds(String... receiverAccountIds) {
            receiverAccountIds(Arrays.asList(receiverAccountIds));
            return this;
        }

        @Override
        public DirectAnalysisConfigurationDetails build() {
            return new DirectAnalysisConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
