/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the total number of aggregations, as well as the remaining aggregations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacyPrivacyBudgetAggregation implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacyPrivacyBudgetAggregation.Builder, DifferentialPrivacyPrivacyBudgetAggregation> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DifferentialPrivacyPrivacyBudgetAggregation::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCount").getter(getter(DifferentialPrivacyPrivacyBudgetAggregation::maxCount))
            .setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCount").build()).build();

    private static final SdkField<Integer> REMAINING_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("remainingCount").getter(getter(DifferentialPrivacyPrivacyBudgetAggregation::remainingCount))
            .setter(setter(Builder::remainingCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remainingCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MAX_COUNT_FIELD,
            REMAINING_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer maxCount;

    private final Integer remainingCount;

    private DifferentialPrivacyPrivacyBudgetAggregation(BuilderImpl builder) {
        this.type = builder.type;
        this.maxCount = builder.maxCount;
        this.remainingCount = builder.remainingCount;
    }

    /**
     * <p>
     * The different types of aggregation functions that you can perform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DifferentialPrivacyAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The different types of aggregation functions that you can perform.
     * @see DifferentialPrivacyAggregationType
     */
    public final DifferentialPrivacyAggregationType type() {
        return DifferentialPrivacyAggregationType.fromValue(type);
    }

    /**
     * <p>
     * The different types of aggregation functions that you can perform.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DifferentialPrivacyAggregationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The different types of aggregation functions that you can perform.
     * @see DifferentialPrivacyAggregationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The maximum number of aggregation functions that you can perform with the given privacy budget.
     * </p>
     * 
     * @return The maximum number of aggregation functions that you can perform with the given privacy budget.
     */
    public final Integer maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * The remaining number of aggregation functions that can be run with the available privacy budget.
     * </p>
     * 
     * @return The remaining number of aggregation functions that can be run with the available privacy budget.
     */
    public final Integer remainingCount() {
        return remainingCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(remainingCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacyPrivacyBudgetAggregation)) {
            return false;
        }
        DifferentialPrivacyPrivacyBudgetAggregation other = (DifferentialPrivacyPrivacyBudgetAggregation) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(maxCount(), other.maxCount())
                && Objects.equals(remainingCount(), other.remainingCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacyPrivacyBudgetAggregation").add("Type", typeAsString())
                .add("MaxCount", maxCount()).add("RemainingCount", remainingCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "maxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        case "remainingCount":
            return Optional.ofNullable(clazz.cast(remainingCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("maxCount", MAX_COUNT_FIELD);
        map.put("remainingCount", REMAINING_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacyPrivacyBudgetAggregation, T> g) {
        return obj -> g.apply((DifferentialPrivacyPrivacyBudgetAggregation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacyPrivacyBudgetAggregation> {
        /**
         * <p>
         * The different types of aggregation functions that you can perform.
         * </p>
         * 
         * @param type
         *        The different types of aggregation functions that you can perform.
         * @see DifferentialPrivacyAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferentialPrivacyAggregationType
         */
        Builder type(String type);

        /**
         * <p>
         * The different types of aggregation functions that you can perform.
         * </p>
         * 
         * @param type
         *        The different types of aggregation functions that you can perform.
         * @see DifferentialPrivacyAggregationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DifferentialPrivacyAggregationType
         */
        Builder type(DifferentialPrivacyAggregationType type);

        /**
         * <p>
         * The maximum number of aggregation functions that you can perform with the given privacy budget.
         * </p>
         * 
         * @param maxCount
         *        The maximum number of aggregation functions that you can perform with the given privacy budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Integer maxCount);

        /**
         * <p>
         * The remaining number of aggregation functions that can be run with the available privacy budget.
         * </p>
         * 
         * @param remainingCount
         *        The remaining number of aggregation functions that can be run with the available privacy budget.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingCount(Integer remainingCount);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer maxCount;

        private Integer remainingCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacyPrivacyBudgetAggregation model) {
            type(model.type);
            maxCount(model.maxCount);
            remainingCount(model.remainingCount);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DifferentialPrivacyAggregationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getMaxCount() {
            return maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final Integer getRemainingCount() {
            return remainingCount;
        }

        public final void setRemainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
        }

        @Override
        public final Builder remainingCount(Integer remainingCount) {
            this.remainingCount = remainingCount;
            return this;
        }

        @Override
        public DifferentialPrivacyPrivacyBudgetAggregation build() {
            return new DifferentialPrivacyPrivacyBudgetAggregation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
