/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the unique identifier for your users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DifferentialPrivacyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DifferentialPrivacyConfiguration.Builder, DifferentialPrivacyConfiguration> {
    private static final SdkField<List<DifferentialPrivacyColumn>> COLUMNS_FIELD = SdkField
            .<List<DifferentialPrivacyColumn>> builder(MarshallingType.LIST)
            .memberName("columns")
            .getter(getter(DifferentialPrivacyConfiguration::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DifferentialPrivacyColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(DifferentialPrivacyColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DifferentialPrivacyColumn> columns;

    private DifferentialPrivacyConfiguration(BuilderImpl builder) {
        this.columns = builder.columns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the column (such as user_id) that contains the unique identifier of your users whose privacy you want
     * to protect. If you want to turn on diﬀerential privacy for two or more tables in a collaboration, you must
     * conﬁgure the same column as the user identiﬁer column in both analysis rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return The name of the column (such as user_id) that contains the unique identifier of your users whose privacy
     *         you want to protect. If you want to turn on diﬀerential privacy for two or more tables in a
     *         collaboration, you must conﬁgure the same column as the user identiﬁer column in both analysis rules.
     */
    public final List<DifferentialPrivacyColumn> columns() {
        return columns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacyConfiguration)) {
            return false;
        }
        DifferentialPrivacyConfiguration other = (DifferentialPrivacyConfiguration) obj;
        return hasColumns() == other.hasColumns() && Objects.equals(columns(), other.columns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DifferentialPrivacyConfiguration").add("Columns", hasColumns() ? columns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "columns":
            return Optional.ofNullable(clazz.cast(columns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("columns", COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacyConfiguration, T> g) {
        return obj -> g.apply((DifferentialPrivacyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DifferentialPrivacyConfiguration> {
        /**
         * <p>
         * The name of the column (such as user_id) that contains the unique identifier of your users whose privacy you
         * want to protect. If you want to turn on diﬀerential privacy for two or more tables in a collaboration, you
         * must conﬁgure the same column as the user identiﬁer column in both analysis rules.
         * </p>
         * 
         * @param columns
         *        The name of the column (such as user_id) that contains the unique identifier of your users whose
         *        privacy you want to protect. If you want to turn on diﬀerential privacy for two or more tables in a
         *        collaboration, you must conﬁgure the same column as the user identiﬁer column in both analysis rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<DifferentialPrivacyColumn> columns);

        /**
         * <p>
         * The name of the column (such as user_id) that contains the unique identifier of your users whose privacy you
         * want to protect. If you want to turn on diﬀerential privacy for two or more tables in a collaboration, you
         * must conﬁgure the same column as the user identiﬁer column in both analysis rules.
         * </p>
         * 
         * @param columns
         *        The name of the column (such as user_id) that contains the unique identifier of your users whose
         *        privacy you want to protect. If you want to turn on diﬀerential privacy for two or more tables in a
         *        collaboration, you must conﬁgure the same column as the user identiﬁer column in both analysis rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(DifferentialPrivacyColumn... columns);

        /**
         * <p>
         * The name of the column (such as user_id) that contains the unique identifier of your users whose privacy you
         * want to protect. If you want to turn on diﬀerential privacy for two or more tables in a collaboration, you
         * must conﬁgure the same column as the user identiﬁer column in both analysis rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyColumn.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyColumn.Builder#build()} is called
         * immediately and its result is passed to {@link #columns(List<DifferentialPrivacyColumn>)}.
         * 
         * @param columns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(java.util.Collection<DifferentialPrivacyColumn>)
         */
        Builder columns(Consumer<DifferentialPrivacyColumn.Builder>... columns);
    }

    static final class BuilderImpl implements Builder {
        private List<DifferentialPrivacyColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacyConfiguration model) {
            columns(model.columns);
        }

        public final List<DifferentialPrivacyColumn.Builder> getColumns() {
            List<DifferentialPrivacyColumn.Builder> result = DifferentialPrivacyColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<DifferentialPrivacyColumn.BuilderImpl> columns) {
            this.columns = DifferentialPrivacyColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<DifferentialPrivacyColumn> columns) {
            this.columns = DifferentialPrivacyColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(DifferentialPrivacyColumn... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<DifferentialPrivacyColumn.Builder>... columns) {
            columns(Stream.of(columns).map(c -> DifferentialPrivacyColumn.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DifferentialPrivacyConfiguration build() {
            return new DifferentialPrivacyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
