/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMembershipRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<CreateMembershipRequest.Builder, CreateMembershipRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collaborationIdentifier").getter(getter(CreateMembershipRequest::collaborationIdentifier))
            .setter(setter(Builder::collaborationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collaborationIdentifier").build())
            .build();

    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLogStatus").getter(getter(CreateMembershipRequest::queryLogStatusAsString))
            .setter(setter(Builder::queryLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()).build();

    private static final SdkField<String> JOB_LOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobLogStatus").getter(getter(CreateMembershipRequest::jobLogStatusAsString))
            .setter(setter(Builder::jobLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobLogStatus").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMembershipRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MembershipProtectedQueryResultConfiguration> DEFAULT_RESULT_CONFIGURATION_FIELD = SdkField
            .<MembershipProtectedQueryResultConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("defaultResultConfiguration")
            .getter(getter(CreateMembershipRequest::defaultResultConfiguration))
            .setter(setter(Builder::defaultResultConfiguration))
            .constructor(MembershipProtectedQueryResultConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultResultConfiguration").build())
            .build();

    private static final SdkField<MembershipProtectedJobResultConfiguration> DEFAULT_JOB_RESULT_CONFIGURATION_FIELD = SdkField
            .<MembershipProtectedJobResultConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("defaultJobResultConfiguration")
            .getter(getter(CreateMembershipRequest::defaultJobResultConfiguration))
            .setter(setter(Builder::defaultJobResultConfiguration))
            .constructor(MembershipProtectedJobResultConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultJobResultConfiguration")
                    .build()).build();

    private static final SdkField<MembershipPaymentConfiguration> PAYMENT_CONFIGURATION_FIELD = SdkField
            .<MembershipPaymentConfiguration> builder(MarshallingType.SDK_POJO).memberName("paymentConfiguration")
            .getter(getter(CreateMembershipRequest::paymentConfiguration)).setter(setter(Builder::paymentConfiguration))
            .constructor(MembershipPaymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COLLABORATION_IDENTIFIER_FIELD, QUERY_LOG_STATUS_FIELD, JOB_LOG_STATUS_FIELD, TAGS_FIELD,
            DEFAULT_RESULT_CONFIGURATION_FIELD, DEFAULT_JOB_RESULT_CONFIGURATION_FIELD, PAYMENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String collaborationIdentifier;

    private final String queryLogStatus;

    private final String jobLogStatus;

    private final Map<String, String> tags;

    private final MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

    private final MembershipProtectedJobResultConfiguration defaultJobResultConfiguration;

    private final MembershipPaymentConfiguration paymentConfiguration;

    private CreateMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.queryLogStatus = builder.queryLogStatus;
        this.jobLogStatus = builder.jobLogStatus;
        this.tags = builder.tags;
        this.defaultResultConfiguration = builder.defaultResultConfiguration;
        this.defaultJobResultConfiguration = builder.defaultJobResultConfiguration;
        this.paymentConfiguration = builder.paymentConfiguration;
    }

    /**
     * <p>
     * The unique ID for the associated collaboration.
     * </p>
     * 
     * @return The unique ID for the associated collaboration.
     */
    public final String collaborationIdentifier() {
        return collaborationIdentifier;
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those logs
     * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link MembershipQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the membership.</p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipQueryLogStatus
     */
    public final MembershipQueryLogStatus queryLogStatus() {
        return MembershipQueryLogStatus.fromValue(queryLogStatus);
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the membership.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those logs
     * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link MembershipQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the membership.</p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipQueryLogStatus
     */
    public final String queryLogStatusAsString() {
        return queryLogStatus;
    }

    /**
     * <p>
     * An indicator as to whether job logging has been enabled or disabled for the collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs can
     * be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobLogStatus} will
     * return {@link MembershipJobLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipJobLogStatus
     */
    public final MembershipJobLogStatus jobLogStatus() {
        return MembershipJobLogStatus.fromValue(jobLogStatus);
    }

    /**
     * <p>
     * An indicator as to whether job logging has been enabled or disabled for the collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs can
     * be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobLogStatus} will
     * return {@link MembershipJobLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see MembershipJobLogStatus
     */
    public final String jobLogStatusAsString() {
        return jobLogStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     * optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM
     * policies to control access to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     *         optional value, both of which you define. When you use tagging, you can also use tag-based access control
     *         in IAM policies to control access to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The default protected query result configuration as specified by the member who can receive results.
     * </p>
     * 
     * @return The default protected query result configuration as specified by the member who can receive results.
     */
    public final MembershipProtectedQueryResultConfiguration defaultResultConfiguration() {
        return defaultResultConfiguration;
    }

    /**
     * <p>
     * The default job result configuration that determines how job results are protected and managed within this
     * membership. This configuration applies to all jobs.
     * </p>
     * 
     * @return The default job result configuration that determines how job results are protected and managed within
     *         this membership. This configuration applies to all jobs.
     */
    public final MembershipProtectedJobResultConfiguration defaultJobResultConfiguration() {
        return defaultJobResultConfiguration;
    }

    /**
     * <p>
     * The payment responsibilities accepted by the collaboration member.
     * </p>
     * <p>
     * Not required if the collaboration member has the member ability to run queries.
     * </p>
     * <p>
     * Required if the collaboration member doesn't have the member ability to run queries but is configured as a payer
     * by the collaboration creator.
     * </p>
     * 
     * @return The payment responsibilities accepted by the collaboration member.</p>
     *         <p>
     *         Not required if the collaboration member has the member ability to run queries.
     *         </p>
     *         <p>
     *         Required if the collaboration member doesn't have the member ability to run queries but is configured as
     *         a payer by the collaboration creator.
     */
    public final MembershipPaymentConfiguration paymentConfiguration() {
        return paymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultResultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(defaultJobResultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(paymentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembershipRequest)) {
            return false;
        }
        CreateMembershipRequest other = (CreateMembershipRequest) obj;
        return Objects.equals(collaborationIdentifier(), other.collaborationIdentifier())
                && Objects.equals(queryLogStatusAsString(), other.queryLogStatusAsString())
                && Objects.equals(jobLogStatusAsString(), other.jobLogStatusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(defaultResultConfiguration(), other.defaultResultConfiguration())
                && Objects.equals(defaultJobResultConfiguration(), other.defaultJobResultConfiguration())
                && Objects.equals(paymentConfiguration(), other.paymentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMembershipRequest").add("CollaborationIdentifier", collaborationIdentifier())
                .add("QueryLogStatus", queryLogStatusAsString()).add("JobLogStatus", jobLogStatusAsString())
                .add("Tags", hasTags() ? tags() : null).add("DefaultResultConfiguration", defaultResultConfiguration())
                .add("DefaultJobResultConfiguration", defaultJobResultConfiguration())
                .add("PaymentConfiguration", paymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collaborationIdentifier":
            return Optional.ofNullable(clazz.cast(collaborationIdentifier()));
        case "queryLogStatus":
            return Optional.ofNullable(clazz.cast(queryLogStatusAsString()));
        case "jobLogStatus":
            return Optional.ofNullable(clazz.cast(jobLogStatusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "defaultResultConfiguration":
            return Optional.ofNullable(clazz.cast(defaultResultConfiguration()));
        case "defaultJobResultConfiguration":
            return Optional.ofNullable(clazz.cast(defaultJobResultConfiguration()));
        case "paymentConfiguration":
            return Optional.ofNullable(clazz.cast(paymentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("queryLogStatus", QUERY_LOG_STATUS_FIELD);
        map.put("jobLogStatus", JOB_LOG_STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("defaultResultConfiguration", DEFAULT_RESULT_CONFIGURATION_FIELD);
        map.put("defaultJobResultConfiguration", DEFAULT_JOB_RESULT_CONFIGURATION_FIELD);
        map.put("paymentConfiguration", PAYMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMembershipRequest, T> g) {
        return obj -> g.apply((CreateMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMembershipRequest> {
        /**
         * <p>
         * The unique ID for the associated collaboration.
         * </p>
         * 
         * @param collaborationIdentifier
         *        The unique ID for the associated collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collaborationIdentifier(String collaborationIdentifier);

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the membership.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
         * logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the membership.</p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and
         *        those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipQueryLogStatus
         */
        Builder queryLogStatus(String queryLogStatus);

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the membership.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
         * logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the membership.</p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and
         *        those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipQueryLogStatus
         */
        Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus);

        /**
         * <p>
         * An indicator as to whether job logging has been enabled or disabled for the collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs
         * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param jobLogStatus
         *        An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
         *        logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipJobLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipJobLogStatus
         */
        Builder jobLogStatus(String jobLogStatus);

        /**
         * <p>
         * An indicator as to whether job logging has been enabled or disabled for the collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those logs
         * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param jobLogStatus
         *        An indicator as to whether job logging has been enabled or disabled for the collaboration. </p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration and those
         *        logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see MembershipJobLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipJobLogStatus
         */
        Builder jobLogStatus(MembershipJobLogStatus jobLogStatus);

        /**
         * <p>
         * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
         * optional value, both of which you define. When you use tagging, you can also use tag-based access control in
         * IAM policies to control access to this resource.
         * </p>
         * 
         * @param tags
         *        An optional label that you can assign to a resource when you create it. Each tag consists of a key and
         *        an optional value, both of which you define. When you use tagging, you can also use tag-based access
         *        control in IAM policies to control access to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The default protected query result configuration as specified by the member who can receive results.
         * </p>
         * 
         * @param defaultResultConfiguration
         *        The default protected query result configuration as specified by the member who can receive results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration);

        /**
         * <p>
         * The default protected query result configuration as specified by the member who can receive results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipProtectedQueryResultConfiguration.Builder} avoiding the need to create one manually via
         * {@link MembershipProtectedQueryResultConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipProtectedQueryResultConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultResultConfiguration(MembershipProtectedQueryResultConfiguration)}.
         * 
         * @param defaultResultConfiguration
         *        a consumer that will call methods on {@link MembershipProtectedQueryResultConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultResultConfiguration(MembershipProtectedQueryResultConfiguration)
         */
        default Builder defaultResultConfiguration(
                Consumer<MembershipProtectedQueryResultConfiguration.Builder> defaultResultConfiguration) {
            return defaultResultConfiguration(MembershipProtectedQueryResultConfiguration.builder()
                    .applyMutation(defaultResultConfiguration).build());
        }

        /**
         * <p>
         * The default job result configuration that determines how job results are protected and managed within this
         * membership. This configuration applies to all jobs.
         * </p>
         * 
         * @param defaultJobResultConfiguration
         *        The default job result configuration that determines how job results are protected and managed within
         *        this membership. This configuration applies to all jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration defaultJobResultConfiguration);

        /**
         * <p>
         * The default job result configuration that determines how job results are protected and managed within this
         * membership. This configuration applies to all jobs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link MembershipProtectedJobResultConfiguration.Builder} avoiding the need to create one manually via
         * {@link MembershipProtectedJobResultConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipProtectedJobResultConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration)}.
         * 
         * @param defaultJobResultConfiguration
         *        a consumer that will call methods on {@link MembershipProtectedJobResultConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration)
         */
        default Builder defaultJobResultConfiguration(
                Consumer<MembershipProtectedJobResultConfiguration.Builder> defaultJobResultConfiguration) {
            return defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration.builder()
                    .applyMutation(defaultJobResultConfiguration).build());
        }

        /**
         * <p>
         * The payment responsibilities accepted by the collaboration member.
         * </p>
         * <p>
         * Not required if the collaboration member has the member ability to run queries.
         * </p>
         * <p>
         * Required if the collaboration member doesn't have the member ability to run queries but is configured as a
         * payer by the collaboration creator.
         * </p>
         * 
         * @param paymentConfiguration
         *        The payment responsibilities accepted by the collaboration member.</p>
         *        <p>
         *        Not required if the collaboration member has the member ability to run queries.
         *        </p>
         *        <p>
         *        Required if the collaboration member doesn't have the member ability to run queries but is configured
         *        as a payer by the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentConfiguration(MembershipPaymentConfiguration paymentConfiguration);

        /**
         * <p>
         * The payment responsibilities accepted by the collaboration member.
         * </p>
         * <p>
         * Not required if the collaboration member has the member ability to run queries.
         * </p>
         * <p>
         * Required if the collaboration member doesn't have the member ability to run queries but is configured as a
         * payer by the collaboration creator.
         * </p>
         * This is a convenience method that creates an instance of the {@link MembershipPaymentConfiguration.Builder}
         * avoiding the need to create one manually via {@link MembershipPaymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MembershipPaymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #paymentConfiguration(MembershipPaymentConfiguration)}.
         * 
         * @param paymentConfiguration
         *        a consumer that will call methods on {@link MembershipPaymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #paymentConfiguration(MembershipPaymentConfiguration)
         */
        default Builder paymentConfiguration(Consumer<MembershipPaymentConfiguration.Builder> paymentConfiguration) {
            return paymentConfiguration(MembershipPaymentConfiguration.builder().applyMutation(paymentConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String collaborationIdentifier;

        private String queryLogStatus;

        private String jobLogStatus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private MembershipProtectedQueryResultConfiguration defaultResultConfiguration;

        private MembershipProtectedJobResultConfiguration defaultJobResultConfiguration;

        private MembershipPaymentConfiguration paymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembershipRequest model) {
            super(model);
            collaborationIdentifier(model.collaborationIdentifier);
            queryLogStatus(model.queryLogStatus);
            jobLogStatus(model.jobLogStatus);
            tags(model.tags);
            defaultResultConfiguration(model.defaultResultConfiguration);
            defaultJobResultConfiguration(model.defaultJobResultConfiguration);
            paymentConfiguration(model.paymentConfiguration);
        }

        public final String getCollaborationIdentifier() {
            return collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getQueryLogStatus() {
            return queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(MembershipQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final String getJobLogStatus() {
            return jobLogStatus;
        }

        public final void setJobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
        }

        @Override
        public final Builder jobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
            return this;
        }

        @Override
        public final Builder jobLogStatus(MembershipJobLogStatus jobLogStatus) {
            this.jobLogStatus(jobLogStatus == null ? null : jobLogStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final MembershipProtectedQueryResultConfiguration.Builder getDefaultResultConfiguration() {
            return defaultResultConfiguration != null ? defaultResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultResultConfiguration(
                MembershipProtectedQueryResultConfiguration.BuilderImpl defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration != null ? defaultResultConfiguration.build() : null;
        }

        @Override
        public final Builder defaultResultConfiguration(MembershipProtectedQueryResultConfiguration defaultResultConfiguration) {
            this.defaultResultConfiguration = defaultResultConfiguration;
            return this;
        }

        public final MembershipProtectedJobResultConfiguration.Builder getDefaultJobResultConfiguration() {
            return defaultJobResultConfiguration != null ? defaultJobResultConfiguration.toBuilder() : null;
        }

        public final void setDefaultJobResultConfiguration(
                MembershipProtectedJobResultConfiguration.BuilderImpl defaultJobResultConfiguration) {
            this.defaultJobResultConfiguration = defaultJobResultConfiguration != null ? defaultJobResultConfiguration.build()
                    : null;
        }

        @Override
        public final Builder defaultJobResultConfiguration(MembershipProtectedJobResultConfiguration defaultJobResultConfiguration) {
            this.defaultJobResultConfiguration = defaultJobResultConfiguration;
            return this;
        }

        public final MembershipPaymentConfiguration.Builder getPaymentConfiguration() {
            return paymentConfiguration != null ? paymentConfiguration.toBuilder() : null;
        }

        public final void setPaymentConfiguration(MembershipPaymentConfiguration.BuilderImpl paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration != null ? paymentConfiguration.build() : null;
        }

        @Override
        public final Builder paymentConfiguration(MembershipPaymentConfiguration paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembershipRequest build() {
            return new CreateMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
