/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConfiguredAudienceModelAssociationResponse extends CleanRoomsResponse
        implements
        ToCopyableBuilder<CreateConfiguredAudienceModelAssociationResponse.Builder, CreateConfiguredAudienceModelAssociationResponse> {
    private static final SdkField<ConfiguredAudienceModelAssociation> CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_FIELD = SdkField
            .<ConfiguredAudienceModelAssociation> builder(MarshallingType.SDK_POJO)
            .memberName("configuredAudienceModelAssociation")
            .getter(getter(CreateConfiguredAudienceModelAssociationResponse::configuredAudienceModelAssociation))
            .setter(setter(Builder::configuredAudienceModelAssociation))
            .constructor(ConfiguredAudienceModelAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredAudienceModelAssociation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ConfiguredAudienceModelAssociation configuredAudienceModelAssociation;

    private CreateConfiguredAudienceModelAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.configuredAudienceModelAssociation = builder.configuredAudienceModelAssociation;
    }

    /**
     * <p>
     * Information about the configured audience model association.
     * </p>
     * 
     * @return Information about the configured audience model association.
     */
    public final ConfiguredAudienceModelAssociation configuredAudienceModelAssociation() {
        return configuredAudienceModelAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuredAudienceModelAssociation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConfiguredAudienceModelAssociationResponse)) {
            return false;
        }
        CreateConfiguredAudienceModelAssociationResponse other = (CreateConfiguredAudienceModelAssociationResponse) obj;
        return Objects.equals(configuredAudienceModelAssociation(), other.configuredAudienceModelAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConfiguredAudienceModelAssociationResponse")
                .add("ConfiguredAudienceModelAssociation", configuredAudienceModelAssociation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configuredAudienceModelAssociation":
            return Optional.ofNullable(clazz.cast(configuredAudienceModelAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("configuredAudienceModelAssociation", CONFIGURED_AUDIENCE_MODEL_ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConfiguredAudienceModelAssociationResponse, T> g) {
        return obj -> g.apply((CreateConfiguredAudienceModelAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateConfiguredAudienceModelAssociationResponse> {
        /**
         * <p>
         * Information about the configured audience model association.
         * </p>
         * 
         * @param configuredAudienceModelAssociation
         *        Information about the configured audience model association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuredAudienceModelAssociation(ConfiguredAudienceModelAssociation configuredAudienceModelAssociation);

        /**
         * <p>
         * Information about the configured audience model association.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredAudienceModelAssociation.Builder} avoiding the need to create one manually via
         * {@link ConfiguredAudienceModelAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredAudienceModelAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #configuredAudienceModelAssociation(ConfiguredAudienceModelAssociation)}.
         * 
         * @param configuredAudienceModelAssociation
         *        a consumer that will call methods on {@link ConfiguredAudienceModelAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuredAudienceModelAssociation(ConfiguredAudienceModelAssociation)
         */
        default Builder configuredAudienceModelAssociation(
                Consumer<ConfiguredAudienceModelAssociation.Builder> configuredAudienceModelAssociation) {
            return configuredAudienceModelAssociation(ConfiguredAudienceModelAssociation.builder()
                    .applyMutation(configuredAudienceModelAssociation).build());
        }
    }

    static final class BuilderImpl extends CleanRoomsResponse.BuilderImpl implements Builder {
        private ConfiguredAudienceModelAssociation configuredAudienceModelAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConfiguredAudienceModelAssociationResponse model) {
            super(model);
            configuredAudienceModelAssociation(model.configuredAudienceModelAssociation);
        }

        public final ConfiguredAudienceModelAssociation.Builder getConfiguredAudienceModelAssociation() {
            return configuredAudienceModelAssociation != null ? configuredAudienceModelAssociation.toBuilder() : null;
        }

        public final void setConfiguredAudienceModelAssociation(
                ConfiguredAudienceModelAssociation.BuilderImpl configuredAudienceModelAssociation) {
            this.configuredAudienceModelAssociation = configuredAudienceModelAssociation != null ? configuredAudienceModelAssociation
                    .build() : null;
        }

        @Override
        public final Builder configuredAudienceModelAssociation(
                ConfiguredAudienceModelAssociation configuredAudienceModelAssociation) {
            this.configuredAudienceModelAssociation = configuredAudienceModelAssociation;
            return this;
        }

        @Override
        public CreateConfiguredAudienceModelAssociationResponse build() {
            return new CreateConfiguredAudienceModelAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
