/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCollaborationRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<CreateCollaborationRequest.Builder, CreateCollaborationRequest> {
    private static final SdkField<List<MemberSpecification>> MEMBERS_FIELD = SdkField
            .<List<MemberSpecification>> builder(MarshallingType.LIST)
            .memberName("members")
            .getter(getter(CreateCollaborationRequest::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCollaborationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCollaborationRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> CREATOR_MEMBER_ABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("creatorMemberAbilities")
            .getter(getter(CreateCollaborationRequest::creatorMemberAbilitiesAsStrings))
            .setter(setter(Builder::creatorMemberAbilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorMemberAbilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MLMemberAbilities> CREATOR_ML_MEMBER_ABILITIES_FIELD = SdkField
            .<MLMemberAbilities> builder(MarshallingType.SDK_POJO).memberName("creatorMLMemberAbilities")
            .getter(getter(CreateCollaborationRequest::creatorMLMemberAbilities))
            .setter(setter(Builder::creatorMLMemberAbilities)).constructor(MLMemberAbilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorMLMemberAbilities").build())
            .build();

    private static final SdkField<String> CREATOR_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creatorDisplayName").getter(getter(CreateCollaborationRequest::creatorDisplayName))
            .setter(setter(Builder::creatorDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorDisplayName").build())
            .build();

    private static final SdkField<DataEncryptionMetadata> DATA_ENCRYPTION_METADATA_FIELD = SdkField
            .<DataEncryptionMetadata> builder(MarshallingType.SDK_POJO).memberName("dataEncryptionMetadata")
            .getter(getter(CreateCollaborationRequest::dataEncryptionMetadata)).setter(setter(Builder::dataEncryptionMetadata))
            .constructor(DataEncryptionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataEncryptionMetadata").build())
            .build();

    private static final SdkField<String> QUERY_LOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryLogStatus").getter(getter(CreateCollaborationRequest::queryLogStatusAsString))
            .setter(setter(Builder::queryLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogStatus").build()).build();

    private static final SdkField<String> JOB_LOG_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobLogStatus").getter(getter(CreateCollaborationRequest::jobLogStatusAsString))
            .setter(setter(Builder::jobLogStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobLogStatus").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCollaborationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PaymentConfiguration> CREATOR_PAYMENT_CONFIGURATION_FIELD = SdkField
            .<PaymentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("creatorPaymentConfiguration")
            .getter(getter(CreateCollaborationRequest::creatorPaymentConfiguration))
            .setter(setter(Builder::creatorPaymentConfiguration))
            .constructor(PaymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creatorPaymentConfiguration")
                    .build()).build();

    private static final SdkField<String> ANALYTICS_ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("analyticsEngine").getter(getter(CreateCollaborationRequest::analyticsEngineAsString))
            .setter(setter(Builder::analyticsEngine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyticsEngine").build()).build();

    private static final SdkField<List<String>> AUTO_APPROVED_CHANGE_REQUEST_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("autoApprovedChangeRequestTypes")
            .getter(getter(CreateCollaborationRequest::autoApprovedChangeRequestTypesAsStrings))
            .setter(setter(Builder::autoApprovedChangeRequestTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoApprovedChangeRequestTypes")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ALLOWED_RESULT_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedResultRegions")
            .getter(getter(CreateCollaborationRequest::allowedResultRegionsAsStrings))
            .setter(setter(Builder::allowedResultRegionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResultRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CREATOR_MEMBER_ABILITIES_FIELD, CREATOR_ML_MEMBER_ABILITIES_FIELD, CREATOR_DISPLAY_NAME_FIELD,
            DATA_ENCRYPTION_METADATA_FIELD, QUERY_LOG_STATUS_FIELD, JOB_LOG_STATUS_FIELD, TAGS_FIELD,
            CREATOR_PAYMENT_CONFIGURATION_FIELD, ANALYTICS_ENGINE_FIELD, AUTO_APPROVED_CHANGE_REQUEST_TYPES_FIELD,
            ALLOWED_RESULT_REGIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MemberSpecification> members;

    private final String name;

    private final String description;

    private final List<String> creatorMemberAbilities;

    private final MLMemberAbilities creatorMLMemberAbilities;

    private final String creatorDisplayName;

    private final DataEncryptionMetadata dataEncryptionMetadata;

    private final String queryLogStatus;

    private final String jobLogStatus;

    private final Map<String, String> tags;

    private final PaymentConfiguration creatorPaymentConfiguration;

    private final String analyticsEngine;

    private final List<String> autoApprovedChangeRequestTypes;

    private final List<String> allowedResultRegions;

    private CreateCollaborationRequest(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.name = builder.name;
        this.description = builder.description;
        this.creatorMemberAbilities = builder.creatorMemberAbilities;
        this.creatorMLMemberAbilities = builder.creatorMLMemberAbilities;
        this.creatorDisplayName = builder.creatorDisplayName;
        this.dataEncryptionMetadata = builder.dataEncryptionMetadata;
        this.queryLogStatus = builder.queryLogStatus;
        this.jobLogStatus = builder.jobLogStatus;
        this.tags = builder.tags;
        this.creatorPaymentConfiguration = builder.creatorPaymentConfiguration;
        this.analyticsEngine = builder.analyticsEngine;
        this.autoApprovedChangeRequestTypes = builder.autoApprovedChangeRequestTypes;
        this.allowedResultRegions = builder.allowedResultRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Members property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMembers() {
        return members != null && !(members instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of initial members, not including the creator. This list is immutable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMembers} method.
     * </p>
     * 
     * @return A list of initial members, not including the creator. This list is immutable.
     */
    public final List<MemberSpecification> members() {
        return members;
    }

    /**
     * <p>
     * The display name for a collaboration.
     * </p>
     * 
     * @return The display name for a collaboration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the collaboration provided by the collaboration owner.
     * </p>
     * 
     * @return A description of the collaboration provided by the collaboration owner.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The abilities granted to the collaboration creator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreatorMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration creator.
     */
    public final List<MemberAbility> creatorMemberAbilities() {
        return MemberAbilitiesCopier.copyStringToEnum(creatorMemberAbilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the CreatorMemberAbilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCreatorMemberAbilities() {
        return creatorMemberAbilities != null && !(creatorMemberAbilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The abilities granted to the collaboration creator.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreatorMemberAbilities} method.
     * </p>
     * 
     * @return The abilities granted to the collaboration creator.
     */
    public final List<String> creatorMemberAbilitiesAsStrings() {
        return creatorMemberAbilities;
    }

    /**
     * <p>
     * The ML abilities granted to the collaboration creator.
     * </p>
     * 
     * @return The ML abilities granted to the collaboration creator.
     */
    public final MLMemberAbilities creatorMLMemberAbilities() {
        return creatorMLMemberAbilities;
    }

    /**
     * <p>
     * The display name of the collaboration creator.
     * </p>
     * 
     * @return The display name of the collaboration creator.
     */
    public final String creatorDisplayName() {
        return creatorDisplayName;
    }

    /**
     * <p>
     * The settings for client-side encryption with Cryptographic Computing for Clean Rooms.
     * </p>
     * 
     * @return The settings for client-side encryption with Cryptographic Computing for Clean Rooms.
     */
    public final DataEncryptionMetadata dataEncryptionMetadata() {
        return dataEncryptionMetadata;
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those logs
     * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link CollaborationQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the collaboration.</p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see CollaborationQueryLogStatus
     */
    public final CollaborationQueryLogStatus queryLogStatus() {
        return CollaborationQueryLogStatus.fromValue(queryLogStatus);
    }

    /**
     * <p>
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those logs
     * can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryLogStatus}
     * will return {@link CollaborationQueryLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #queryLogStatusAsString}.
     * </p>
     * 
     * @return An indicator as to whether query logging has been enabled or disabled for the collaboration.</p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
     *         logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see CollaborationQueryLogStatus
     */
    public final String queryLogStatusAsString() {
        return queryLogStatus;
    }

    /**
     * <p>
     * Specifies whether job logs are enabled for this collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those logs can be
     * viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobLogStatus} will
     * return {@link CollaborationJobLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobLogStatusAsString}.
     * </p>
     * 
     * @return Specifies whether job logs are enabled for this collaboration. </p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those logs
     *         can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see CollaborationJobLogStatus
     */
    public final CollaborationJobLogStatus jobLogStatus() {
        return CollaborationJobLogStatus.fromValue(jobLogStatus);
    }

    /**
     * <p>
     * Specifies whether job logs are enabled for this collaboration.
     * </p>
     * <p>
     * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those logs can be
     * viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobLogStatus} will
     * return {@link CollaborationJobLogStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #jobLogStatusAsString}.
     * </p>
     * 
     * @return Specifies whether job logs are enabled for this collaboration. </p>
     *         <p>
     *         When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those logs
     *         can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
     * @see CollaborationJobLogStatus
     */
    public final String jobLogStatusAsString() {
        return jobLogStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     * optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM
     * policies to control access to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     *         optional value, both of which you define. When you use tagging, you can also use tag-based access control
     *         in IAM policies to control access to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The collaboration creator's payment responsibilities set by the collaboration creator.
     * </p>
     * <p>
     * If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the
     * member who can query is the default payer.
     * </p>
     * 
     * @return The collaboration creator's payment responsibilities set by the collaboration creator. </p>
     *         <p>
     *         If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then
     *         the member who can query is the default payer.
     */
    public final PaymentConfiguration creatorPaymentConfiguration() {
        return creatorPaymentConfiguration;
    }

    /**
     * <p>
     * The analytics engine.
     * </p>
     * <note>
     * <p>
     * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analyticsEngine}
     * will return {@link AnalyticsEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analyticsEngineAsString}.
     * </p>
     * 
     * @return The analytics engine.</p> <note>
     *         <p>
     *         After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     *         </p>
     * @see AnalyticsEngine
     */
    public final AnalyticsEngine analyticsEngine() {
        return AnalyticsEngine.fromValue(analyticsEngine);
    }

    /**
     * <p>
     * The analytics engine.
     * </p>
     * <note>
     * <p>
     * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #analyticsEngine}
     * will return {@link AnalyticsEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #analyticsEngineAsString}.
     * </p>
     * 
     * @return The analytics engine.</p> <note>
     *         <p>
     *         After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
     *         </p>
     * @see AnalyticsEngine
     */
    public final String analyticsEngineAsString() {
        return analyticsEngine;
    }

    /**
     * <p>
     * The types of change requests that are automatically approved for this collaboration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoApprovedChangeRequestTypes} method.
     * </p>
     * 
     * @return The types of change requests that are automatically approved for this collaboration.
     */
    public final List<AutoApprovedChangeType> autoApprovedChangeRequestTypes() {
        return AutoApprovedChangeTypeListCopier.copyStringToEnum(autoApprovedChangeRequestTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoApprovedChangeRequestTypes property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoApprovedChangeRequestTypes() {
        return autoApprovedChangeRequestTypes != null && !(autoApprovedChangeRequestTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of change requests that are automatically approved for this collaboration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoApprovedChangeRequestTypes} method.
     * </p>
     * 
     * @return The types of change requests that are automatically approved for this collaboration.
     */
    public final List<String> autoApprovedChangeRequestTypesAsStrings() {
        return autoApprovedChangeRequestTypes;
    }

    /**
     * <p>
     * The Amazon Web Services Regions where collaboration query results can be stored. When specified, results can only
     * be written to these Regions. This parameter enables you to meet your compliance and data governance requirements,
     * and implement regional data governance policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedResultRegions} method.
     * </p>
     * 
     * @return The Amazon Web Services Regions where collaboration query results can be stored. When specified, results
     *         can only be written to these Regions. This parameter enables you to meet your compliance and data
     *         governance requirements, and implement regional data governance policies.
     */
    public final List<SupportedS3Region> allowedResultRegions() {
        return AllowedResultRegionsCopier.copyStringToEnum(allowedResultRegions);
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedResultRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedResultRegions() {
        return allowedResultRegions != null && !(allowedResultRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services Regions where collaboration query results can be stored. When specified, results can only
     * be written to these Regions. This parameter enables you to meet your compliance and data governance requirements,
     * and implement regional data governance policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedResultRegions} method.
     * </p>
     * 
     * @return The Amazon Web Services Regions where collaboration query results can be stored. When specified, results
     *         can only be written to these Regions. This parameter enables you to meet your compliance and data
     *         governance requirements, and implement regional data governance policies.
     */
    public final List<String> allowedResultRegionsAsStrings() {
        return allowedResultRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMembers() ? members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasCreatorMemberAbilities() ? creatorMemberAbilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorMLMemberAbilities());
        hashCode = 31 * hashCode + Objects.hashCode(creatorDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(dataEncryptionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(queryLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobLogStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorPaymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(analyticsEngineAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAutoApprovedChangeRequestTypes() ? autoApprovedChangeRequestTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedResultRegions() ? allowedResultRegionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollaborationRequest)) {
            return false;
        }
        CreateCollaborationRequest other = (CreateCollaborationRequest) obj;
        return hasMembers() == other.hasMembers() && Objects.equals(members(), other.members())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && hasCreatorMemberAbilities() == other.hasCreatorMemberAbilities()
                && Objects.equals(creatorMemberAbilitiesAsStrings(), other.creatorMemberAbilitiesAsStrings())
                && Objects.equals(creatorMLMemberAbilities(), other.creatorMLMemberAbilities())
                && Objects.equals(creatorDisplayName(), other.creatorDisplayName())
                && Objects.equals(dataEncryptionMetadata(), other.dataEncryptionMetadata())
                && Objects.equals(queryLogStatusAsString(), other.queryLogStatusAsString())
                && Objects.equals(jobLogStatusAsString(), other.jobLogStatusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(creatorPaymentConfiguration(), other.creatorPaymentConfiguration())
                && Objects.equals(analyticsEngineAsString(), other.analyticsEngineAsString())
                && hasAutoApprovedChangeRequestTypes() == other.hasAutoApprovedChangeRequestTypes()
                && Objects.equals(autoApprovedChangeRequestTypesAsStrings(), other.autoApprovedChangeRequestTypesAsStrings())
                && hasAllowedResultRegions() == other.hasAllowedResultRegions()
                && Objects.equals(allowedResultRegionsAsStrings(), other.allowedResultRegionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateCollaborationRequest")
                .add("Members", hasMembers() ? members() : null)
                .add("Name", name())
                .add("Description", description())
                .add("CreatorMemberAbilities", hasCreatorMemberAbilities() ? creatorMemberAbilitiesAsStrings() : null)
                .add("CreatorMLMemberAbilities", creatorMLMemberAbilities())
                .add("CreatorDisplayName", creatorDisplayName())
                .add("DataEncryptionMetadata", dataEncryptionMetadata())
                .add("QueryLogStatus", queryLogStatusAsString())
                .add("JobLogStatus", jobLogStatusAsString())
                .add("Tags", hasTags() ? tags() : null)
                .add("CreatorPaymentConfiguration", creatorPaymentConfiguration())
                .add("AnalyticsEngine", analyticsEngineAsString())
                .add("AutoApprovedChangeRequestTypes",
                        hasAutoApprovedChangeRequestTypes() ? autoApprovedChangeRequestTypesAsStrings() : null)
                .add("AllowedResultRegions", hasAllowedResultRegions() ? allowedResultRegionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "members":
            return Optional.ofNullable(clazz.cast(members()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creatorMemberAbilities":
            return Optional.ofNullable(clazz.cast(creatorMemberAbilitiesAsStrings()));
        case "creatorMLMemberAbilities":
            return Optional.ofNullable(clazz.cast(creatorMLMemberAbilities()));
        case "creatorDisplayName":
            return Optional.ofNullable(clazz.cast(creatorDisplayName()));
        case "dataEncryptionMetadata":
            return Optional.ofNullable(clazz.cast(dataEncryptionMetadata()));
        case "queryLogStatus":
            return Optional.ofNullable(clazz.cast(queryLogStatusAsString()));
        case "jobLogStatus":
            return Optional.ofNullable(clazz.cast(jobLogStatusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "creatorPaymentConfiguration":
            return Optional.ofNullable(clazz.cast(creatorPaymentConfiguration()));
        case "analyticsEngine":
            return Optional.ofNullable(clazz.cast(analyticsEngineAsString()));
        case "autoApprovedChangeRequestTypes":
            return Optional.ofNullable(clazz.cast(autoApprovedChangeRequestTypesAsStrings()));
        case "allowedResultRegions":
            return Optional.ofNullable(clazz.cast(allowedResultRegionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("members", MEMBERS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creatorMemberAbilities", CREATOR_MEMBER_ABILITIES_FIELD);
        map.put("creatorMLMemberAbilities", CREATOR_ML_MEMBER_ABILITIES_FIELD);
        map.put("creatorDisplayName", CREATOR_DISPLAY_NAME_FIELD);
        map.put("dataEncryptionMetadata", DATA_ENCRYPTION_METADATA_FIELD);
        map.put("queryLogStatus", QUERY_LOG_STATUS_FIELD);
        map.put("jobLogStatus", JOB_LOG_STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("creatorPaymentConfiguration", CREATOR_PAYMENT_CONFIGURATION_FIELD);
        map.put("analyticsEngine", ANALYTICS_ENGINE_FIELD);
        map.put("autoApprovedChangeRequestTypes", AUTO_APPROVED_CHANGE_REQUEST_TYPES_FIELD);
        map.put("allowedResultRegions", ALLOWED_RESULT_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCollaborationRequest, T> g) {
        return obj -> g.apply((CreateCollaborationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCollaborationRequest> {
        /**
         * <p>
         * A list of initial members, not including the creator. This list is immutable.
         * </p>
         * 
         * @param members
         *        A list of initial members, not including the creator. This list is immutable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<MemberSpecification> members);

        /**
         * <p>
         * A list of initial members, not including the creator. This list is immutable.
         * </p>
         * 
         * @param members
         *        A list of initial members, not including the creator. This list is immutable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(MemberSpecification... members);

        /**
         * <p>
         * A list of initial members, not including the creator. This list is immutable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.MemberSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cleanrooms.model.MemberSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.MemberSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #members(List<MemberSpecification>)}.
         * 
         * @param members
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.MemberSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(java.util.Collection<MemberSpecification>)
         */
        Builder members(Consumer<MemberSpecification.Builder>... members);

        /**
         * <p>
         * The display name for a collaboration.
         * </p>
         * 
         * @param name
         *        The display name for a collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the collaboration provided by the collaboration owner.
         * </p>
         * 
         * @param description
         *        A description of the collaboration provided by the collaboration owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The abilities granted to the collaboration creator.
         * </p>
         * 
         * @param creatorMemberAbilities
         *        The abilities granted to the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorMemberAbilitiesWithStrings(Collection<String> creatorMemberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration creator.
         * </p>
         * 
         * @param creatorMemberAbilities
         *        The abilities granted to the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorMemberAbilitiesWithStrings(String... creatorMemberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration creator.
         * </p>
         * 
         * @param creatorMemberAbilities
         *        The abilities granted to the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorMemberAbilities(Collection<MemberAbility> creatorMemberAbilities);

        /**
         * <p>
         * The abilities granted to the collaboration creator.
         * </p>
         * 
         * @param creatorMemberAbilities
         *        The abilities granted to the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorMemberAbilities(MemberAbility... creatorMemberAbilities);

        /**
         * <p>
         * The ML abilities granted to the collaboration creator.
         * </p>
         * 
         * @param creatorMLMemberAbilities
         *        The ML abilities granted to the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorMLMemberAbilities(MLMemberAbilities creatorMLMemberAbilities);

        /**
         * <p>
         * The ML abilities granted to the collaboration creator.
         * </p>
         * This is a convenience method that creates an instance of the {@link MLMemberAbilities.Builder} avoiding the
         * need to create one manually via {@link MLMemberAbilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MLMemberAbilities.Builder#build()} is called immediately and its
         * result is passed to {@link #creatorMLMemberAbilities(MLMemberAbilities)}.
         * 
         * @param creatorMLMemberAbilities
         *        a consumer that will call methods on {@link MLMemberAbilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creatorMLMemberAbilities(MLMemberAbilities)
         */
        default Builder creatorMLMemberAbilities(Consumer<MLMemberAbilities.Builder> creatorMLMemberAbilities) {
            return creatorMLMemberAbilities(MLMemberAbilities.builder().applyMutation(creatorMLMemberAbilities).build());
        }

        /**
         * <p>
         * The display name of the collaboration creator.
         * </p>
         * 
         * @param creatorDisplayName
         *        The display name of the collaboration creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorDisplayName(String creatorDisplayName);

        /**
         * <p>
         * The settings for client-side encryption with Cryptographic Computing for Clean Rooms.
         * </p>
         * 
         * @param dataEncryptionMetadata
         *        The settings for client-side encryption with Cryptographic Computing for Clean Rooms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEncryptionMetadata(DataEncryptionMetadata dataEncryptionMetadata);

        /**
         * <p>
         * The settings for client-side encryption with Cryptographic Computing for Clean Rooms.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataEncryptionMetadata.Builder} avoiding
         * the need to create one manually via {@link DataEncryptionMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataEncryptionMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #dataEncryptionMetadata(DataEncryptionMetadata)}.
         * 
         * @param dataEncryptionMetadata
         *        a consumer that will call methods on {@link DataEncryptionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataEncryptionMetadata(DataEncryptionMetadata)
         */
        default Builder dataEncryptionMetadata(Consumer<DataEncryptionMetadata.Builder> dataEncryptionMetadata) {
            return dataEncryptionMetadata(DataEncryptionMetadata.builder().applyMutation(dataEncryptionMetadata).build());
        }

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
         * logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the collaboration.</p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and
         *        those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see CollaborationQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollaborationQueryLogStatus
         */
        Builder queryLogStatus(String queryLogStatus);

        /**
         * <p>
         * An indicator as to whether query logging has been enabled or disabled for the collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and those
         * logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param queryLogStatus
         *        An indicator as to whether query logging has been enabled or disabled for the collaboration.</p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about queries run within this collaboration and
         *        those logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see CollaborationQueryLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollaborationQueryLogStatus
         */
        Builder queryLogStatus(CollaborationQueryLogStatus queryLogStatus);

        /**
         * <p>
         * Specifies whether job logs are enabled for this collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those logs can
         * be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param jobLogStatus
         *        Specifies whether job logs are enabled for this collaboration. </p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those
         *        logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see CollaborationJobLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollaborationJobLogStatus
         */
        Builder jobLogStatus(String jobLogStatus);

        /**
         * <p>
         * Specifies whether job logs are enabled for this collaboration.
         * </p>
         * <p>
         * When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those logs can
         * be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * </p>
         * 
         * @param jobLogStatus
         *        Specifies whether job logs are enabled for this collaboration. </p>
         *        <p>
         *        When <code>ENABLED</code>, Clean Rooms logs details about jobs run within this collaboration; those
         *        logs can be viewed in Amazon CloudWatch Logs. The default value is <code>DISABLED</code>.
         * @see CollaborationJobLogStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollaborationJobLogStatus
         */
        Builder jobLogStatus(CollaborationJobLogStatus jobLogStatus);

        /**
         * <p>
         * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
         * optional value, both of which you define. When you use tagging, you can also use tag-based access control in
         * IAM policies to control access to this resource.
         * </p>
         * 
         * @param tags
         *        An optional label that you can assign to a resource when you create it. Each tag consists of a key and
         *        an optional value, both of which you define. When you use tagging, you can also use tag-based access
         *        control in IAM policies to control access to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The collaboration creator's payment responsibilities set by the collaboration creator.
         * </p>
         * <p>
         * If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the
         * member who can query is the default payer.
         * </p>
         * 
         * @param creatorPaymentConfiguration
         *        The collaboration creator's payment responsibilities set by the collaboration creator. </p>
         *        <p>
         *        If the collaboration creator hasn't specified anyone as the member paying for query compute costs,
         *        then the member who can query is the default payer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorPaymentConfiguration(PaymentConfiguration creatorPaymentConfiguration);

        /**
         * <p>
         * The collaboration creator's payment responsibilities set by the collaboration creator.
         * </p>
         * <p>
         * If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the
         * member who can query is the default payer.
         * </p>
         * This is a convenience method that creates an instance of the {@link PaymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link PaymentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PaymentConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #creatorPaymentConfiguration(PaymentConfiguration)}.
         * 
         * @param creatorPaymentConfiguration
         *        a consumer that will call methods on {@link PaymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #creatorPaymentConfiguration(PaymentConfiguration)
         */
        default Builder creatorPaymentConfiguration(Consumer<PaymentConfiguration.Builder> creatorPaymentConfiguration) {
            return creatorPaymentConfiguration(PaymentConfiguration.builder().applyMutation(creatorPaymentConfiguration).build());
        }

        /**
         * <p>
         * The analytics engine.
         * </p>
         * <note>
         * <p>
         * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         * </p>
         * </note>
         * 
         * @param analyticsEngine
         *        The analytics engine.</p> <note>
         *        <p>
         *        After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         *        </p>
         * @see AnalyticsEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsEngine
         */
        Builder analyticsEngine(String analyticsEngine);

        /**
         * <p>
         * The analytics engine.
         * </p>
         * <note>
         * <p>
         * After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         * </p>
         * </note>
         * 
         * @param analyticsEngine
         *        The analytics engine.</p> <note>
         *        <p>
         *        After July 16, 2025, the <code>CLEAN_ROOMS_SQL</code> parameter will no longer be available.
         *        </p>
         * @see AnalyticsEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsEngine
         */
        Builder analyticsEngine(AnalyticsEngine analyticsEngine);

        /**
         * <p>
         * The types of change requests that are automatically approved for this collaboration.
         * </p>
         * 
         * @param autoApprovedChangeRequestTypes
         *        The types of change requests that are automatically approved for this collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoApprovedChangeRequestTypesWithStrings(Collection<String> autoApprovedChangeRequestTypes);

        /**
         * <p>
         * The types of change requests that are automatically approved for this collaboration.
         * </p>
         * 
         * @param autoApprovedChangeRequestTypes
         *        The types of change requests that are automatically approved for this collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoApprovedChangeRequestTypesWithStrings(String... autoApprovedChangeRequestTypes);

        /**
         * <p>
         * The types of change requests that are automatically approved for this collaboration.
         * </p>
         * 
         * @param autoApprovedChangeRequestTypes
         *        The types of change requests that are automatically approved for this collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoApprovedChangeRequestTypes(Collection<AutoApprovedChangeType> autoApprovedChangeRequestTypes);

        /**
         * <p>
         * The types of change requests that are automatically approved for this collaboration.
         * </p>
         * 
         * @param autoApprovedChangeRequestTypes
         *        The types of change requests that are automatically approved for this collaboration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoApprovedChangeRequestTypes(AutoApprovedChangeType... autoApprovedChangeRequestTypes);

        /**
         * <p>
         * The Amazon Web Services Regions where collaboration query results can be stored. When specified, results can
         * only be written to these Regions. This parameter enables you to meet your compliance and data governance
         * requirements, and implement regional data governance policies.
         * </p>
         * 
         * @param allowedResultRegions
         *        The Amazon Web Services Regions where collaboration query results can be stored. When specified,
         *        results can only be written to these Regions. This parameter enables you to meet your compliance and
         *        data governance requirements, and implement regional data governance policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultRegionsWithStrings(Collection<String> allowedResultRegions);

        /**
         * <p>
         * The Amazon Web Services Regions where collaboration query results can be stored. When specified, results can
         * only be written to these Regions. This parameter enables you to meet your compliance and data governance
         * requirements, and implement regional data governance policies.
         * </p>
         * 
         * @param allowedResultRegions
         *        The Amazon Web Services Regions where collaboration query results can be stored. When specified,
         *        results can only be written to these Regions. This parameter enables you to meet your compliance and
         *        data governance requirements, and implement regional data governance policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultRegionsWithStrings(String... allowedResultRegions);

        /**
         * <p>
         * The Amazon Web Services Regions where collaboration query results can be stored. When specified, results can
         * only be written to these Regions. This parameter enables you to meet your compliance and data governance
         * requirements, and implement regional data governance policies.
         * </p>
         * 
         * @param allowedResultRegions
         *        The Amazon Web Services Regions where collaboration query results can be stored. When specified,
         *        results can only be written to these Regions. This parameter enables you to meet your compliance and
         *        data governance requirements, and implement regional data governance policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultRegions(Collection<SupportedS3Region> allowedResultRegions);

        /**
         * <p>
         * The Amazon Web Services Regions where collaboration query results can be stored. When specified, results can
         * only be written to these Regions. This parameter enables you to meet your compliance and data governance
         * requirements, and implement regional data governance policies.
         * </p>
         * 
         * @param allowedResultRegions
         *        The Amazon Web Services Regions where collaboration query results can be stored. When specified,
         *        results can only be written to these Regions. This parameter enables you to meet your compliance and
         *        data governance requirements, and implement regional data governance policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedResultRegions(SupportedS3Region... allowedResultRegions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private List<MemberSpecification> members = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private String description;

        private List<String> creatorMemberAbilities = DefaultSdkAutoConstructList.getInstance();

        private MLMemberAbilities creatorMLMemberAbilities;

        private String creatorDisplayName;

        private DataEncryptionMetadata dataEncryptionMetadata;

        private String queryLogStatus;

        private String jobLogStatus;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private PaymentConfiguration creatorPaymentConfiguration;

        private String analyticsEngine;

        private List<String> autoApprovedChangeRequestTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> allowedResultRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollaborationRequest model) {
            super(model);
            members(model.members);
            name(model.name);
            description(model.description);
            creatorMemberAbilitiesWithStrings(model.creatorMemberAbilities);
            creatorMLMemberAbilities(model.creatorMLMemberAbilities);
            creatorDisplayName(model.creatorDisplayName);
            dataEncryptionMetadata(model.dataEncryptionMetadata);
            queryLogStatus(model.queryLogStatus);
            jobLogStatus(model.jobLogStatus);
            tags(model.tags);
            creatorPaymentConfiguration(model.creatorPaymentConfiguration);
            analyticsEngine(model.analyticsEngine);
            autoApprovedChangeRequestTypesWithStrings(model.autoApprovedChangeRequestTypes);
            allowedResultRegionsWithStrings(model.allowedResultRegions);
        }

        public final List<MemberSpecification.Builder> getMembers() {
            List<MemberSpecification.Builder> result = MemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<MemberSpecification.BuilderImpl> members) {
            this.members = MemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<MemberSpecification> members) {
            this.members = MemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(MemberSpecification... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<MemberSpecification.Builder>... members) {
            members(Stream.of(members).map(c -> MemberSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCreatorMemberAbilities() {
            if (creatorMemberAbilities instanceof SdkAutoConstructList) {
                return null;
            }
            return creatorMemberAbilities;
        }

        public final void setCreatorMemberAbilities(Collection<String> creatorMemberAbilities) {
            this.creatorMemberAbilities = MemberAbilitiesCopier.copy(creatorMemberAbilities);
        }

        @Override
        public final Builder creatorMemberAbilitiesWithStrings(Collection<String> creatorMemberAbilities) {
            this.creatorMemberAbilities = MemberAbilitiesCopier.copy(creatorMemberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creatorMemberAbilitiesWithStrings(String... creatorMemberAbilities) {
            creatorMemberAbilitiesWithStrings(Arrays.asList(creatorMemberAbilities));
            return this;
        }

        @Override
        public final Builder creatorMemberAbilities(Collection<MemberAbility> creatorMemberAbilities) {
            this.creatorMemberAbilities = MemberAbilitiesCopier.copyEnumToString(creatorMemberAbilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creatorMemberAbilities(MemberAbility... creatorMemberAbilities) {
            creatorMemberAbilities(Arrays.asList(creatorMemberAbilities));
            return this;
        }

        public final MLMemberAbilities.Builder getCreatorMLMemberAbilities() {
            return creatorMLMemberAbilities != null ? creatorMLMemberAbilities.toBuilder() : null;
        }

        public final void setCreatorMLMemberAbilities(MLMemberAbilities.BuilderImpl creatorMLMemberAbilities) {
            this.creatorMLMemberAbilities = creatorMLMemberAbilities != null ? creatorMLMemberAbilities.build() : null;
        }

        @Override
        public final Builder creatorMLMemberAbilities(MLMemberAbilities creatorMLMemberAbilities) {
            this.creatorMLMemberAbilities = creatorMLMemberAbilities;
            return this;
        }

        public final String getCreatorDisplayName() {
            return creatorDisplayName;
        }

        public final void setCreatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
        }

        @Override
        public final Builder creatorDisplayName(String creatorDisplayName) {
            this.creatorDisplayName = creatorDisplayName;
            return this;
        }

        public final DataEncryptionMetadata.Builder getDataEncryptionMetadata() {
            return dataEncryptionMetadata != null ? dataEncryptionMetadata.toBuilder() : null;
        }

        public final void setDataEncryptionMetadata(DataEncryptionMetadata.BuilderImpl dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata != null ? dataEncryptionMetadata.build() : null;
        }

        @Override
        public final Builder dataEncryptionMetadata(DataEncryptionMetadata dataEncryptionMetadata) {
            this.dataEncryptionMetadata = dataEncryptionMetadata;
            return this;
        }

        public final String getQueryLogStatus() {
            return queryLogStatus;
        }

        public final void setQueryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
        }

        @Override
        public final Builder queryLogStatus(String queryLogStatus) {
            this.queryLogStatus = queryLogStatus;
            return this;
        }

        @Override
        public final Builder queryLogStatus(CollaborationQueryLogStatus queryLogStatus) {
            this.queryLogStatus(queryLogStatus == null ? null : queryLogStatus.toString());
            return this;
        }

        public final String getJobLogStatus() {
            return jobLogStatus;
        }

        public final void setJobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
        }

        @Override
        public final Builder jobLogStatus(String jobLogStatus) {
            this.jobLogStatus = jobLogStatus;
            return this;
        }

        @Override
        public final Builder jobLogStatus(CollaborationJobLogStatus jobLogStatus) {
            this.jobLogStatus(jobLogStatus == null ? null : jobLogStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final PaymentConfiguration.Builder getCreatorPaymentConfiguration() {
            return creatorPaymentConfiguration != null ? creatorPaymentConfiguration.toBuilder() : null;
        }

        public final void setCreatorPaymentConfiguration(PaymentConfiguration.BuilderImpl creatorPaymentConfiguration) {
            this.creatorPaymentConfiguration = creatorPaymentConfiguration != null ? creatorPaymentConfiguration.build() : null;
        }

        @Override
        public final Builder creatorPaymentConfiguration(PaymentConfiguration creatorPaymentConfiguration) {
            this.creatorPaymentConfiguration = creatorPaymentConfiguration;
            return this;
        }

        public final String getAnalyticsEngine() {
            return analyticsEngine;
        }

        public final void setAnalyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
        }

        @Override
        public final Builder analyticsEngine(String analyticsEngine) {
            this.analyticsEngine = analyticsEngine;
            return this;
        }

        @Override
        public final Builder analyticsEngine(AnalyticsEngine analyticsEngine) {
            this.analyticsEngine(analyticsEngine == null ? null : analyticsEngine.toString());
            return this;
        }

        public final Collection<String> getAutoApprovedChangeRequestTypes() {
            if (autoApprovedChangeRequestTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return autoApprovedChangeRequestTypes;
        }

        public final void setAutoApprovedChangeRequestTypes(Collection<String> autoApprovedChangeRequestTypes) {
            this.autoApprovedChangeRequestTypes = AutoApprovedChangeTypeListCopier.copy(autoApprovedChangeRequestTypes);
        }

        @Override
        public final Builder autoApprovedChangeRequestTypesWithStrings(Collection<String> autoApprovedChangeRequestTypes) {
            this.autoApprovedChangeRequestTypes = AutoApprovedChangeTypeListCopier.copy(autoApprovedChangeRequestTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoApprovedChangeRequestTypesWithStrings(String... autoApprovedChangeRequestTypes) {
            autoApprovedChangeRequestTypesWithStrings(Arrays.asList(autoApprovedChangeRequestTypes));
            return this;
        }

        @Override
        public final Builder autoApprovedChangeRequestTypes(Collection<AutoApprovedChangeType> autoApprovedChangeRequestTypes) {
            this.autoApprovedChangeRequestTypes = AutoApprovedChangeTypeListCopier
                    .copyEnumToString(autoApprovedChangeRequestTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoApprovedChangeRequestTypes(AutoApprovedChangeType... autoApprovedChangeRequestTypes) {
            autoApprovedChangeRequestTypes(Arrays.asList(autoApprovedChangeRequestTypes));
            return this;
        }

        public final Collection<String> getAllowedResultRegions() {
            if (allowedResultRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedResultRegions;
        }

        public final void setAllowedResultRegions(Collection<String> allowedResultRegions) {
            this.allowedResultRegions = AllowedResultRegionsCopier.copy(allowedResultRegions);
        }

        @Override
        public final Builder allowedResultRegionsWithStrings(Collection<String> allowedResultRegions) {
            this.allowedResultRegions = AllowedResultRegionsCopier.copy(allowedResultRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultRegionsWithStrings(String... allowedResultRegions) {
            allowedResultRegionsWithStrings(Arrays.asList(allowedResultRegions));
            return this;
        }

        @Override
        public final Builder allowedResultRegions(Collection<SupportedS3Region> allowedResultRegions) {
            this.allowedResultRegions = AllowedResultRegionsCopier.copyEnumToString(allowedResultRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultRegions(SupportedS3Region... allowedResultRegions) {
            allowedResultRegions(Arrays.asList(allowedResultRegions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCollaborationRequest build() {
            return new CreateCollaborationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
