/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnalysisTemplateRequest extends CleanRoomsRequest implements
        ToCopyableBuilder<CreateAnalysisTemplateRequest.Builder, CreateAnalysisTemplateRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAnalysisTemplateRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipIdentifier").getter(getter(CreateAnalysisTemplateRequest::membershipIdentifier))
            .setter(setter(Builder::membershipIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAnalysisTemplateRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(CreateAnalysisTemplateRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<AnalysisSource> SOURCE_FIELD = SdkField.<AnalysisSource> builder(MarshallingType.SDK_POJO)
            .memberName("source").getter(getter(CreateAnalysisTemplateRequest::source)).setter(setter(Builder::source))
            .constructor(AnalysisSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAnalysisTemplateRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AnalysisParameter>> ANALYSIS_PARAMETERS_FIELD = SdkField
            .<List<AnalysisParameter>> builder(MarshallingType.LIST)
            .memberName("analysisParameters")
            .getter(getter(CreateAnalysisTemplateRequest::analysisParameters))
            .setter(setter(Builder::analysisParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AnalysisSchema> SCHEMA_FIELD = SdkField.<AnalysisSchema> builder(MarshallingType.SDK_POJO)
            .memberName("schema").getter(getter(CreateAnalysisTemplateRequest::schema)).setter(setter(Builder::schema))
            .constructor(AnalysisSchema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()).build();

    private static final SdkField<ErrorMessageConfiguration> ERROR_MESSAGE_CONFIGURATION_FIELD = SdkField
            .<ErrorMessageConfiguration> builder(MarshallingType.SDK_POJO).memberName("errorMessageConfiguration")
            .getter(getter(CreateAnalysisTemplateRequest::errorMessageConfiguration))
            .setter(setter(Builder::errorMessageConfiguration)).constructor(ErrorMessageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessageConfiguration").build())
            .build();

    private static final SdkField<SyntheticDataParameters> SYNTHETIC_DATA_PARAMETERS_FIELD = SdkField
            .<SyntheticDataParameters> builder(MarshallingType.SDK_POJO).memberName("syntheticDataParameters")
            .getter(getter(CreateAnalysisTemplateRequest::syntheticDataParameters))
            .setter(setter(Builder::syntheticDataParameters)).constructor(SyntheticDataParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntheticDataParameters").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            MEMBERSHIP_IDENTIFIER_FIELD, NAME_FIELD, FORMAT_FIELD, SOURCE_FIELD, TAGS_FIELD, ANALYSIS_PARAMETERS_FIELD,
            SCHEMA_FIELD, ERROR_MESSAGE_CONFIGURATION_FIELD, SYNTHETIC_DATA_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final String membershipIdentifier;

    private final String name;

    private final String format;

    private final AnalysisSource source;

    private final Map<String, String> tags;

    private final List<AnalysisParameter> analysisParameters;

    private final AnalysisSchema schema;

    private final ErrorMessageConfiguration errorMessageConfiguration;

    private final SyntheticDataParameters syntheticDataParameters;

    private CreateAnalysisTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.format = builder.format;
        this.source = builder.source;
        this.tags = builder.tags;
        this.analysisParameters = builder.analysisParameters;
        this.schema = builder.schema;
        this.errorMessageConfiguration = builder.errorMessageConfiguration;
        this.syntheticDataParameters = builder.syntheticDataParameters;
    }

    /**
     * <p>
     * The description of the analysis template.
     * </p>
     * 
     * @return The description of the analysis template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier for a membership resource.
     * </p>
     * 
     * @return The identifier for a membership resource.
     */
    public final String membershipIdentifier() {
        return membershipIdentifier;
    }

    /**
     * <p>
     * The name of the analysis template.
     * </p>
     * 
     * @return The name of the analysis template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The format of the analysis template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link AnalysisFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the analysis template.
     * @see AnalysisFormat
     */
    public final AnalysisFormat format() {
        return AnalysisFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the analysis template.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link AnalysisFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the analysis template.
     * @see AnalysisFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The information in the analysis template.
     * </p>
     * 
     * @return The information in the analysis template.
     */
    public final AnalysisSource source() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     * optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM
     * policies to control access to this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
     *         optional value, both of which you define. When you use tagging, you can also use tag-based access control
     *         in IAM policies to control access to this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AnalysisParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAnalysisParameters() {
        return analysisParameters != null && !(analysisParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters of the analysis template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAnalysisParameters} method.
     * </p>
     * 
     * @return The parameters of the analysis template.
     */
    public final List<AnalysisParameter> analysisParameters() {
        return analysisParameters;
    }

    /**
     * Returns the value of the Schema property for this object.
     * 
     * @return The value of the Schema property for this object.
     */
    public final AnalysisSchema schema() {
        return schema;
    }

    /**
     * <p>
     * The configuration that specifies the level of detail in error messages returned by analyses using this template.
     * When set to <code>DETAILED</code>, error messages include more information to help troubleshoot issues with
     * PySpark jobs. Detailed error messages may expose underlying data, including sensitive information. Recommended
     * for faster troubleshooting in development and testing environments.
     * </p>
     * 
     * @return The configuration that specifies the level of detail in error messages returned by analyses using this
     *         template. When set to <code>DETAILED</code>, error messages include more information to help troubleshoot
     *         issues with PySpark jobs. Detailed error messages may expose underlying data, including sensitive
     *         information. Recommended for faster troubleshooting in development and testing environments.
     */
    public final ErrorMessageConfiguration errorMessageConfiguration() {
        return errorMessageConfiguration;
    }

    /**
     * <p>
     * The parameters for generating synthetic data when running the analysis template.
     * </p>
     * 
     * @return The parameters for generating synthetic data when running the analysis template.
     */
    public final SyntheticDataParameters syntheticDataParameters() {
        return syntheticDataParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAnalysisParameters() ? analysisParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(syntheticDataParameters());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalysisTemplateRequest)) {
            return false;
        }
        CreateAnalysisTemplateRequest other = (CreateAnalysisTemplateRequest) obj;
        return Objects.equals(description(), other.description())
                && Objects.equals(membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(source(), other.source())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasAnalysisParameters() == other.hasAnalysisParameters()
                && Objects.equals(analysisParameters(), other.analysisParameters()) && Objects.equals(schema(), other.schema())
                && Objects.equals(errorMessageConfiguration(), other.errorMessageConfiguration())
                && Objects.equals(syntheticDataParameters(), other.syntheticDataParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnalysisTemplateRequest").add("Description", description())
                .add("MembershipIdentifier", membershipIdentifier()).add("Name", name()).add("Format", formatAsString())
                .add("Source", source()).add("Tags", hasTags() ? tags() : null)
                .add("AnalysisParameters", analysisParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Schema", schema()).add("ErrorMessageConfiguration", errorMessageConfiguration())
                .add("SyntheticDataParameters", syntheticDataParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "membershipIdentifier":
            return Optional.ofNullable(clazz.cast(membershipIdentifier()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "analysisParameters":
            return Optional.ofNullable(clazz.cast(analysisParameters()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "errorMessageConfiguration":
            return Optional.ofNullable(clazz.cast(errorMessageConfiguration()));
        case "syntheticDataParameters":
            return Optional.ofNullable(clazz.cast(syntheticDataParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("membershipIdentifier", MEMBERSHIP_IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("analysisParameters", ANALYSIS_PARAMETERS_FIELD);
        map.put("schema", SCHEMA_FIELD);
        map.put("errorMessageConfiguration", ERROR_MESSAGE_CONFIGURATION_FIELD);
        map.put("syntheticDataParameters", SYNTHETIC_DATA_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalysisTemplateRequest, T> g) {
        return obj -> g.apply((CreateAnalysisTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CleanRoomsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnalysisTemplateRequest> {
        /**
         * <p>
         * The description of the analysis template.
         * </p>
         * 
         * @param description
         *        The description of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier for a membership resource.
         * </p>
         * 
         * @param membershipIdentifier
         *        The identifier for a membership resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipIdentifier(String membershipIdentifier);

        /**
         * <p>
         * The name of the analysis template.
         * </p>
         * 
         * @param name
         *        The name of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The format of the analysis template.
         * </p>
         * 
         * @param format
         *        The format of the analysis template.
         * @see AnalysisFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the analysis template.
         * </p>
         * 
         * @param format
         *        The format of the analysis template.
         * @see AnalysisFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalysisFormat
         */
        Builder format(AnalysisFormat format);

        /**
         * <p>
         * The information in the analysis template.
         * </p>
         * 
         * @param source
         *        The information in the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(AnalysisSource source);

        /**
         * <p>
         * The information in the analysis template.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisSource.Builder} avoiding the need
         * to create one manually via {@link AnalysisSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisSource.Builder#build()} is called immediately and its
         * result is passed to {@link #source(AnalysisSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link AnalysisSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(AnalysisSource)
         */
        default Builder source(Consumer<AnalysisSource.Builder> source) {
            return source(AnalysisSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * An optional label that you can assign to a resource when you create it. Each tag consists of a key and an
         * optional value, both of which you define. When you use tagging, you can also use tag-based access control in
         * IAM policies to control access to this resource.
         * </p>
         * 
         * @param tags
         *        An optional label that you can assign to a resource when you create it. Each tag consists of a key and
         *        an optional value, both of which you define. When you use tagging, you can also use tag-based access
         *        control in IAM policies to control access to this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The parameters of the analysis template.
         * </p>
         * 
         * @param analysisParameters
         *        The parameters of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisParameters(Collection<AnalysisParameter> analysisParameters);

        /**
         * <p>
         * The parameters of the analysis template.
         * </p>
         * 
         * @param analysisParameters
         *        The parameters of the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisParameters(AnalysisParameter... analysisParameters);

        /**
         * <p>
         * The parameters of the analysis template.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #analysisParameters(List<AnalysisParameter>)}.
         * 
         * @param analysisParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cleanrooms.model.AnalysisParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisParameters(java.util.Collection<AnalysisParameter>)
         */
        Builder analysisParameters(Consumer<AnalysisParameter.Builder>... analysisParameters);

        /**
         * Sets the value of the Schema property for this object.
         *
         * @param schema
         *        The new value for the Schema property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(AnalysisSchema schema);

        /**
         * Sets the value of the Schema property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AnalysisSchema.Builder} avoiding the need
         * to create one manually via {@link AnalysisSchema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisSchema.Builder#build()} is called immediately and its
         * result is passed to {@link #schema(AnalysisSchema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link AnalysisSchema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(AnalysisSchema)
         */
        default Builder schema(Consumer<AnalysisSchema.Builder> schema) {
            return schema(AnalysisSchema.builder().applyMutation(schema).build());
        }

        /**
         * <p>
         * The configuration that specifies the level of detail in error messages returned by analyses using this
         * template. When set to <code>DETAILED</code>, error messages include more information to help troubleshoot
         * issues with PySpark jobs. Detailed error messages may expose underlying data, including sensitive
         * information. Recommended for faster troubleshooting in development and testing environments.
         * </p>
         * 
         * @param errorMessageConfiguration
         *        The configuration that specifies the level of detail in error messages returned by analyses using this
         *        template. When set to <code>DETAILED</code>, error messages include more information to help
         *        troubleshoot issues with PySpark jobs. Detailed error messages may expose underlying data, including
         *        sensitive information. Recommended for faster troubleshooting in development and testing environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessageConfiguration(ErrorMessageConfiguration errorMessageConfiguration);

        /**
         * <p>
         * The configuration that specifies the level of detail in error messages returned by analyses using this
         * template. When set to <code>DETAILED</code>, error messages include more information to help troubleshoot
         * issues with PySpark jobs. Detailed error messages may expose underlying data, including sensitive
         * information. Recommended for faster troubleshooting in development and testing environments.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorMessageConfiguration.Builder}
         * avoiding the need to create one manually via {@link ErrorMessageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorMessageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #errorMessageConfiguration(ErrorMessageConfiguration)}.
         * 
         * @param errorMessageConfiguration
         *        a consumer that will call methods on {@link ErrorMessageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorMessageConfiguration(ErrorMessageConfiguration)
         */
        default Builder errorMessageConfiguration(Consumer<ErrorMessageConfiguration.Builder> errorMessageConfiguration) {
            return errorMessageConfiguration(ErrorMessageConfiguration.builder().applyMutation(errorMessageConfiguration).build());
        }

        /**
         * <p>
         * The parameters for generating synthetic data when running the analysis template.
         * </p>
         * 
         * @param syntheticDataParameters
         *        The parameters for generating synthetic data when running the analysis template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syntheticDataParameters(SyntheticDataParameters syntheticDataParameters);

        /**
         * <p>
         * The parameters for generating synthetic data when running the analysis template.
         * </p>
         * This is a convenience method that creates an instance of the {@link SyntheticDataParameters.Builder} avoiding
         * the need to create one manually via {@link SyntheticDataParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyntheticDataParameters.Builder#build()} is called immediately
         * and its result is passed to {@link #syntheticDataParameters(SyntheticDataParameters)}.
         * 
         * @param syntheticDataParameters
         *        a consumer that will call methods on {@link SyntheticDataParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syntheticDataParameters(SyntheticDataParameters)
         */
        default Builder syntheticDataParameters(Consumer<SyntheticDataParameters.Builder> syntheticDataParameters) {
            return syntheticDataParameters(SyntheticDataParameters.builder().applyMutation(syntheticDataParameters).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CleanRoomsRequest.BuilderImpl implements Builder {
        private String description;

        private String membershipIdentifier;

        private String name;

        private String format;

        private AnalysisSource source;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<AnalysisParameter> analysisParameters = DefaultSdkAutoConstructList.getInstance();

        private AnalysisSchema schema;

        private ErrorMessageConfiguration errorMessageConfiguration;

        private SyntheticDataParameters syntheticDataParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalysisTemplateRequest model) {
            super(model);
            description(model.description);
            membershipIdentifier(model.membershipIdentifier);
            name(model.name);
            format(model.format);
            source(model.source);
            tags(model.tags);
            analysisParameters(model.analysisParameters);
            schema(model.schema);
            errorMessageConfiguration(model.errorMessageConfiguration);
            syntheticDataParameters(model.syntheticDataParameters);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMembershipIdentifier() {
            return membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(AnalysisFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final AnalysisSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(AnalysisSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(AnalysisSource source) {
            this.source = source;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<AnalysisParameter.Builder> getAnalysisParameters() {
            List<AnalysisParameter.Builder> result = AnalysisParameterListCopier.copyToBuilder(this.analysisParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisParameters(Collection<AnalysisParameter.BuilderImpl> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copyFromBuilder(analysisParameters);
        }

        @Override
        public final Builder analysisParameters(Collection<AnalysisParameter> analysisParameters) {
            this.analysisParameters = AnalysisParameterListCopier.copy(analysisParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(AnalysisParameter... analysisParameters) {
            analysisParameters(Arrays.asList(analysisParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisParameters(Consumer<AnalysisParameter.Builder>... analysisParameters) {
            analysisParameters(Stream.of(analysisParameters).map(c -> AnalysisParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AnalysisSchema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(AnalysisSchema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(AnalysisSchema schema) {
            this.schema = schema;
            return this;
        }

        public final ErrorMessageConfiguration.Builder getErrorMessageConfiguration() {
            return errorMessageConfiguration != null ? errorMessageConfiguration.toBuilder() : null;
        }

        public final void setErrorMessageConfiguration(ErrorMessageConfiguration.BuilderImpl errorMessageConfiguration) {
            this.errorMessageConfiguration = errorMessageConfiguration != null ? errorMessageConfiguration.build() : null;
        }

        @Override
        public final Builder errorMessageConfiguration(ErrorMessageConfiguration errorMessageConfiguration) {
            this.errorMessageConfiguration = errorMessageConfiguration;
            return this;
        }

        public final SyntheticDataParameters.Builder getSyntheticDataParameters() {
            return syntheticDataParameters != null ? syntheticDataParameters.toBuilder() : null;
        }

        public final void setSyntheticDataParameters(SyntheticDataParameters.BuilderImpl syntheticDataParameters) {
            this.syntheticDataParameters = syntheticDataParameters != null ? syntheticDataParameters.build() : null;
        }

        @Override
        public final Builder syntheticDataParameters(SyntheticDataParameters syntheticDataParameters) {
            this.syntheticDataParameters = syntheticDataParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnalysisTemplateRequest build() {
            return new CreateAnalysisTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
