/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls on the query specifications that can be run on an associated configured table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfiguredTableAssociationAnalysisRulePolicyV1 implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfiguredTableAssociationAnalysisRulePolicyV1.Builder, ConfiguredTableAssociationAnalysisRulePolicyV1> {
    private static final SdkField<ConfiguredTableAssociationAnalysisRuleList> LIST_FIELD = SdkField
            .<ConfiguredTableAssociationAnalysisRuleList> builder(MarshallingType.SDK_POJO).memberName("list")
            .getter(getter(ConfiguredTableAssociationAnalysisRulePolicyV1::list)).setter(setter(Builder::list))
            .constructor(ConfiguredTableAssociationAnalysisRuleList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("list").build()).build();

    private static final SdkField<ConfiguredTableAssociationAnalysisRuleAggregation> AGGREGATION_FIELD = SdkField
            .<ConfiguredTableAssociationAnalysisRuleAggregation> builder(MarshallingType.SDK_POJO).memberName("aggregation")
            .getter(getter(ConfiguredTableAssociationAnalysisRulePolicyV1::aggregation)).setter(setter(Builder::aggregation))
            .constructor(ConfiguredTableAssociationAnalysisRuleAggregation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregation").build()).build();

    private static final SdkField<ConfiguredTableAssociationAnalysisRuleCustom> CUSTOM_FIELD = SdkField
            .<ConfiguredTableAssociationAnalysisRuleCustom> builder(MarshallingType.SDK_POJO).memberName("custom")
            .getter(getter(ConfiguredTableAssociationAnalysisRulePolicyV1::custom)).setter(setter(Builder::custom))
            .constructor(ConfiguredTableAssociationAnalysisRuleCustom::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_FIELD, AGGREGATION_FIELD,
            CUSTOM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ConfiguredTableAssociationAnalysisRuleList list;

    private final ConfiguredTableAssociationAnalysisRuleAggregation aggregation;

    private final ConfiguredTableAssociationAnalysisRuleCustom custom;

    private final Type type;

    private ConfiguredTableAssociationAnalysisRulePolicyV1(BuilderImpl builder) {
        this.list = builder.list;
        this.aggregation = builder.aggregation;
        this.custom = builder.custom;
        this.type = builder.type;
    }

    /**
     * <p>
     * Analysis rule type that enables only list queries on a configured table.
     * </p>
     * 
     * @return Analysis rule type that enables only list queries on a configured table.
     */
    public final ConfiguredTableAssociationAnalysisRuleList list() {
        return list;
    }

    /**
     * <p>
     * Analysis rule type that enables only aggregation queries on a configured table.
     * </p>
     * 
     * @return Analysis rule type that enables only aggregation queries on a configured table.
     */
    public final ConfiguredTableAssociationAnalysisRuleAggregation aggregation() {
        return aggregation;
    }

    /**
     * <p>
     * Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables. It
     * supports differential privacy.
     * </p>
     * 
     * @return Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables.
     *         It supports differential privacy.
     */
    public final ConfiguredTableAssociationAnalysisRuleCustom custom() {
        return custom;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(list());
        hashCode = 31 * hashCode + Objects.hashCode(aggregation());
        hashCode = 31 * hashCode + Objects.hashCode(custom());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAssociationAnalysisRulePolicyV1)) {
            return false;
        }
        ConfiguredTableAssociationAnalysisRulePolicyV1 other = (ConfiguredTableAssociationAnalysisRulePolicyV1) obj;
        return Objects.equals(list(), other.list()) && Objects.equals(aggregation(), other.aggregation())
                && Objects.equals(custom(), other.custom());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfiguredTableAssociationAnalysisRulePolicyV1").add("List", list())
                .add("Aggregation", aggregation()).add("Custom", custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "list":
            return Optional.ofNullable(clazz.cast(list()));
        case "aggregation":
            return Optional.ofNullable(clazz.cast(aggregation()));
        case "custom":
            return Optional.ofNullable(clazz.cast(custom()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #list()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only list queries on a configured table.
     * </p>
     * 
     * @param list
     *        Analysis rule type that enables only list queries on a configured table.
     */
    public static ConfiguredTableAssociationAnalysisRulePolicyV1 fromList(ConfiguredTableAssociationAnalysisRuleList list) {
        return builder().list(list).build();
    }

    /**
     * Create an instance of this class with {@link #list()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only list queries on a configured table.
     * </p>
     * 
     * @param list
     *        Analysis rule type that enables only list queries on a configured table.
     */
    public static ConfiguredTableAssociationAnalysisRulePolicyV1 fromList(
            Consumer<ConfiguredTableAssociationAnalysisRuleList.Builder> list) {
        ConfiguredTableAssociationAnalysisRuleList.Builder builder = ConfiguredTableAssociationAnalysisRuleList.builder();
        list.accept(builder);
        return fromList(builder.build());
    }

    /**
     * Create an instance of this class with {@link #aggregation()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only aggregation queries on a configured table.
     * </p>
     * 
     * @param aggregation
     *        Analysis rule type that enables only aggregation queries on a configured table.
     */
    public static ConfiguredTableAssociationAnalysisRulePolicyV1 fromAggregation(
            ConfiguredTableAssociationAnalysisRuleAggregation aggregation) {
        return builder().aggregation(aggregation).build();
    }

    /**
     * Create an instance of this class with {@link #aggregation()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables only aggregation queries on a configured table.
     * </p>
     * 
     * @param aggregation
     *        Analysis rule type that enables only aggregation queries on a configured table.
     */
    public static ConfiguredTableAssociationAnalysisRulePolicyV1 fromAggregation(
            Consumer<ConfiguredTableAssociationAnalysisRuleAggregation.Builder> aggregation) {
        ConfiguredTableAssociationAnalysisRuleAggregation.Builder builder = ConfiguredTableAssociationAnalysisRuleAggregation
                .builder();
        aggregation.accept(builder);
        return fromAggregation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables. It
     * supports differential privacy.
     * </p>
     * 
     * @param custom
     *        Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables.
     *        It supports differential privacy.
     */
    public static ConfiguredTableAssociationAnalysisRulePolicyV1 fromCustom(ConfiguredTableAssociationAnalysisRuleCustom custom) {
        return builder().custom(custom).build();
    }

    /**
     * Create an instance of this class with {@link #custom()} initialized to the given value.
     *
     * <p>
     * Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables. It
     * supports differential privacy.
     * </p>
     * 
     * @param custom
     *        Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables.
     *        It supports differential privacy.
     */
    public static ConfiguredTableAssociationAnalysisRulePolicyV1 fromCustom(
            Consumer<ConfiguredTableAssociationAnalysisRuleCustom.Builder> custom) {
        ConfiguredTableAssociationAnalysisRuleCustom.Builder builder = ConfiguredTableAssociationAnalysisRuleCustom.builder();
        custom.accept(builder);
        return fromCustom(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("list", LIST_FIELD);
        map.put("aggregation", AGGREGATION_FIELD);
        map.put("custom", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAssociationAnalysisRulePolicyV1, T> g) {
        return obj -> g.apply((ConfiguredTableAssociationAnalysisRulePolicyV1) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfiguredTableAssociationAnalysisRulePolicyV1> {
        /**
         * <p>
         * Analysis rule type that enables only list queries on a configured table.
         * </p>
         * 
         * @param list
         *        Analysis rule type that enables only list queries on a configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder list(ConfiguredTableAssociationAnalysisRuleList list);

        /**
         * <p>
         * Analysis rule type that enables only list queries on a configured table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAssociationAnalysisRuleList.Builder} avoiding the need to create one manually via
         * {@link ConfiguredTableAssociationAnalysisRuleList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAssociationAnalysisRuleList.Builder#build()} is
         * called immediately and its result is passed to {@link #list(ConfiguredTableAssociationAnalysisRuleList)}.
         * 
         * @param list
         *        a consumer that will call methods on {@link ConfiguredTableAssociationAnalysisRuleList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #list(ConfiguredTableAssociationAnalysisRuleList)
         */
        default Builder list(Consumer<ConfiguredTableAssociationAnalysisRuleList.Builder> list) {
            return list(ConfiguredTableAssociationAnalysisRuleList.builder().applyMutation(list).build());
        }

        /**
         * <p>
         * Analysis rule type that enables only aggregation queries on a configured table.
         * </p>
         * 
         * @param aggregation
         *        Analysis rule type that enables only aggregation queries on a configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregation(ConfiguredTableAssociationAnalysisRuleAggregation aggregation);

        /**
         * <p>
         * Analysis rule type that enables only aggregation queries on a configured table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAssociationAnalysisRuleAggregation.Builder} avoiding the need to create one manually
         * via {@link ConfiguredTableAssociationAnalysisRuleAggregation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link ConfiguredTableAssociationAnalysisRuleAggregation.Builder#build()} is called immediately and its
         * result is passed to {@link #aggregation(ConfiguredTableAssociationAnalysisRuleAggregation)}.
         * 
         * @param aggregation
         *        a consumer that will call methods on {@link ConfiguredTableAssociationAnalysisRuleAggregation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregation(ConfiguredTableAssociationAnalysisRuleAggregation)
         */
        default Builder aggregation(Consumer<ConfiguredTableAssociationAnalysisRuleAggregation.Builder> aggregation) {
            return aggregation(ConfiguredTableAssociationAnalysisRuleAggregation.builder().applyMutation(aggregation).build());
        }

        /**
         * <p>
         * Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables. It
         * supports differential privacy.
         * </p>
         * 
         * @param custom
         *        Analysis rule type that enables the table owner to approve custom SQL queries on their configured
         *        tables. It supports differential privacy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder custom(ConfiguredTableAssociationAnalysisRuleCustom custom);

        /**
         * <p>
         * Analysis rule type that enables the table owner to approve custom SQL queries on their configured tables. It
         * supports differential privacy.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ConfiguredTableAssociationAnalysisRuleCustom.Builder} avoiding the need to create one manually via
         * {@link ConfiguredTableAssociationAnalysisRuleCustom#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfiguredTableAssociationAnalysisRuleCustom.Builder#build()} is
         * called immediately and its result is passed to {@link #custom(ConfiguredTableAssociationAnalysisRuleCustom)}.
         * 
         * @param custom
         *        a consumer that will call methods on {@link ConfiguredTableAssociationAnalysisRuleCustom.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #custom(ConfiguredTableAssociationAnalysisRuleCustom)
         */
        default Builder custom(Consumer<ConfiguredTableAssociationAnalysisRuleCustom.Builder> custom) {
            return custom(ConfiguredTableAssociationAnalysisRuleCustom.builder().applyMutation(custom).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ConfiguredTableAssociationAnalysisRuleList list;

        private ConfiguredTableAssociationAnalysisRuleAggregation aggregation;

        private ConfiguredTableAssociationAnalysisRuleCustom custom;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAssociationAnalysisRulePolicyV1 model) {
            list(model.list);
            aggregation(model.aggregation);
            custom(model.custom);
        }

        public final ConfiguredTableAssociationAnalysisRuleList.Builder getList() {
            return list != null ? list.toBuilder() : null;
        }

        public final void setList(ConfiguredTableAssociationAnalysisRuleList.BuilderImpl list) {
            Object oldValue = this.list;
            this.list = list != null ? list.build() : null;
            handleUnionValueChange(Type.LIST, oldValue, this.list);
        }

        @Override
        public final Builder list(ConfiguredTableAssociationAnalysisRuleList list) {
            Object oldValue = this.list;
            this.list = list;
            handleUnionValueChange(Type.LIST, oldValue, this.list);
            return this;
        }

        public final ConfiguredTableAssociationAnalysisRuleAggregation.Builder getAggregation() {
            return aggregation != null ? aggregation.toBuilder() : null;
        }

        public final void setAggregation(ConfiguredTableAssociationAnalysisRuleAggregation.BuilderImpl aggregation) {
            Object oldValue = this.aggregation;
            this.aggregation = aggregation != null ? aggregation.build() : null;
            handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
        }

        @Override
        public final Builder aggregation(ConfiguredTableAssociationAnalysisRuleAggregation aggregation) {
            Object oldValue = this.aggregation;
            this.aggregation = aggregation;
            handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
            return this;
        }

        public final ConfiguredTableAssociationAnalysisRuleCustom.Builder getCustom() {
            return custom != null ? custom.toBuilder() : null;
        }

        public final void setCustom(ConfiguredTableAssociationAnalysisRuleCustom.BuilderImpl custom) {
            Object oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(ConfiguredTableAssociationAnalysisRuleCustom custom) {
            Object oldValue = this.custom;
            this.custom = custom;
            handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        @Override
        public ConfiguredTableAssociationAnalysisRulePolicyV1 build() {
            return new ConfiguredTableAssociationAnalysisRulePolicyV1(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ConfiguredTableAssociationAnalysisRulePolicyV1#type()
     */
    public enum Type {
        LIST,

        AGGREGATION,

        CUSTOM,

        UNKNOWN_TO_SDK_VERSION
    }
}
