/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single change within a collaboration change request, containing the change identifier and specification.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Change implements SdkPojo, Serializable, ToCopyableBuilder<Change.Builder, Change> {
    private static final SdkField<String> SPECIFICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("specificationType").getter(getter(Change::specificationTypeAsString))
            .setter(setter(Builder::specificationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specificationType").build()).build();

    private static final SdkField<ChangeSpecification> SPECIFICATION_FIELD = SdkField
            .<ChangeSpecification> builder(MarshallingType.SDK_POJO).memberName("specification")
            .getter(getter(Change::specification)).setter(setter(Builder::specification))
            .constructor(ChangeSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("specification").build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("types")
            .getter(getter(Change::typesAsStrings))
            .setter(setter(Builder::typesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPECIFICATION_TYPE_FIELD,
            SPECIFICATION_FIELD, TYPES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String specificationType;

    private final ChangeSpecification specification;

    private final List<String> types;

    private Change(BuilderImpl builder) {
        this.specificationType = builder.specificationType;
        this.specification = builder.specification;
        this.types = builder.types;
    }

    /**
     * <p>
     * The type of specification for this change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specificationType}
     * will return {@link ChangeSpecificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specificationTypeAsString}.
     * </p>
     * 
     * @return The type of specification for this change.
     * @see ChangeSpecificationType
     */
    public final ChangeSpecificationType specificationType() {
        return ChangeSpecificationType.fromValue(specificationType);
    }

    /**
     * <p>
     * The type of specification for this change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #specificationType}
     * will return {@link ChangeSpecificationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #specificationTypeAsString}.
     * </p>
     * 
     * @return The type of specification for this change.
     * @see ChangeSpecificationType
     */
    public final String specificationTypeAsString() {
        return specificationType;
    }

    /**
     * <p>
     * The specification details for this change.
     * </p>
     * 
     * @return The specification details for this change.
     */
    public final ChangeSpecification specification() {
        return specification;
    }

    /**
     * <p>
     * The list of change types that were applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The list of change types that were applied.
     */
    public final List<ChangeType> types() {
        return ChangeTypeListCopier.copyStringToEnum(types);
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of change types that were applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The list of change types that were applied.
     */
    public final List<String> typesAsStrings() {
        return types;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(specificationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(specification());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? typesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Change)) {
            return false;
        }
        Change other = (Change) obj;
        return Objects.equals(specificationTypeAsString(), other.specificationTypeAsString())
                && Objects.equals(specification(), other.specification()) && hasTypes() == other.hasTypes()
                && Objects.equals(typesAsStrings(), other.typesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Change").add("SpecificationType", specificationTypeAsString())
                .add("Specification", specification()).add("Types", hasTypes() ? typesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "specificationType":
            return Optional.ofNullable(clazz.cast(specificationTypeAsString()));
        case "specification":
            return Optional.ofNullable(clazz.cast(specification()));
        case "types":
            return Optional.ofNullable(clazz.cast(typesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("specificationType", SPECIFICATION_TYPE_FIELD);
        map.put("specification", SPECIFICATION_FIELD);
        map.put("types", TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Change, T> g) {
        return obj -> g.apply((Change) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Change> {
        /**
         * <p>
         * The type of specification for this change.
         * </p>
         * 
         * @param specificationType
         *        The type of specification for this change.
         * @see ChangeSpecificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSpecificationType
         */
        Builder specificationType(String specificationType);

        /**
         * <p>
         * The type of specification for this change.
         * </p>
         * 
         * @param specificationType
         *        The type of specification for this change.
         * @see ChangeSpecificationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChangeSpecificationType
         */
        Builder specificationType(ChangeSpecificationType specificationType);

        /**
         * <p>
         * The specification details for this change.
         * </p>
         * 
         * @param specification
         *        The specification details for this change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder specification(ChangeSpecification specification);

        /**
         * <p>
         * The specification details for this change.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeSpecification.Builder} avoiding the
         * need to create one manually via {@link ChangeSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #specification(ChangeSpecification)}.
         * 
         * @param specification
         *        a consumer that will call methods on {@link ChangeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #specification(ChangeSpecification)
         */
        default Builder specification(Consumer<ChangeSpecification.Builder> specification) {
            return specification(ChangeSpecification.builder().applyMutation(specification).build());
        }

        /**
         * <p>
         * The list of change types that were applied.
         * </p>
         * 
         * @param types
         *        The list of change types that were applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(Collection<String> types);

        /**
         * <p>
         * The list of change types that were applied.
         * </p>
         * 
         * @param types
         *        The list of change types that were applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typesWithStrings(String... types);

        /**
         * <p>
         * The list of change types that were applied.
         * </p>
         * 
         * @param types
         *        The list of change types that were applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<ChangeType> types);

        /**
         * <p>
         * The list of change types that were applied.
         * </p>
         * 
         * @param types
         *        The list of change types that were applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(ChangeType... types);
    }

    static final class BuilderImpl implements Builder {
        private String specificationType;

        private ChangeSpecification specification;

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Change model) {
            specificationType(model.specificationType);
            specification(model.specification);
            typesWithStrings(model.types);
        }

        public final String getSpecificationType() {
            return specificationType;
        }

        public final void setSpecificationType(String specificationType) {
            this.specificationType = specificationType;
        }

        @Override
        public final Builder specificationType(String specificationType) {
            this.specificationType = specificationType;
            return this;
        }

        @Override
        public final Builder specificationType(ChangeSpecificationType specificationType) {
            this.specificationType(specificationType == null ? null : specificationType.toString());
            return this;
        }

        public final ChangeSpecification.Builder getSpecification() {
            return specification != null ? specification.toBuilder() : null;
        }

        public final void setSpecification(ChangeSpecification.BuilderImpl specification) {
            this.specification = specification != null ? specification.build() : null;
        }

        @Override
        public final Builder specification(ChangeSpecification specification) {
            this.specification = specification;
            return this;
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = ChangeTypeListCopier.copy(types);
        }

        @Override
        public final Builder typesWithStrings(Collection<String> types) {
            this.types = ChangeTypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typesWithStrings(String... types) {
            typesWithStrings(Arrays.asList(types));
            return this;
        }

        @Override
        public final Builder types(Collection<ChangeType> types) {
            this.types = ChangeTypeListCopier.copyEnumToString(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(ChangeType... types) {
            types(Arrays.asList(types));
            return this;
        }

        @Override
        public Change build() {
            return new Change(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
