/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The analysis source metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisSourceMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisSourceMetadata.Builder, AnalysisSourceMetadata> {
    private static final SdkField<AnalysisTemplateArtifactMetadata> ARTIFACTS_FIELD = SdkField
            .<AnalysisTemplateArtifactMetadata> builder(MarshallingType.SDK_POJO).memberName("artifacts")
            .getter(getter(AnalysisSourceMetadata::artifacts)).setter(setter(Builder::artifacts))
            .constructor(AnalysisTemplateArtifactMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnalysisTemplateArtifactMetadata artifacts;

    private final Type type;

    private AnalysisSourceMetadata(BuilderImpl builder) {
        this.artifacts = builder.artifacts;
        this.type = builder.type;
    }

    /**
     * <p>
     * The artifacts of the analysis source metadata.
     * </p>
     * 
     * @return The artifacts of the analysis source metadata.
     */
    public final AnalysisTemplateArtifactMetadata artifacts() {
        return artifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(artifacts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSourceMetadata)) {
            return false;
        }
        AnalysisSourceMetadata other = (AnalysisSourceMetadata) obj;
        return Objects.equals(artifacts(), other.artifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisSourceMetadata").add("Artifacts", artifacts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "artifacts":
            return Optional.ofNullable(clazz.cast(artifacts()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #artifacts()} initialized to the given value.
     *
     * <p>
     * The artifacts of the analysis source metadata.
     * </p>
     * 
     * @param artifacts
     *        The artifacts of the analysis source metadata.
     */
    public static AnalysisSourceMetadata fromArtifacts(AnalysisTemplateArtifactMetadata artifacts) {
        return builder().artifacts(artifacts).build();
    }

    /**
     * Create an instance of this class with {@link #artifacts()} initialized to the given value.
     *
     * <p>
     * The artifacts of the analysis source metadata.
     * </p>
     * 
     * @param artifacts
     *        The artifacts of the analysis source metadata.
     */
    public static AnalysisSourceMetadata fromArtifacts(Consumer<AnalysisTemplateArtifactMetadata.Builder> artifacts) {
        AnalysisTemplateArtifactMetadata.Builder builder = AnalysisTemplateArtifactMetadata.builder();
        artifacts.accept(builder);
        return fromArtifacts(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("artifacts", ARTIFACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSourceMetadata, T> g) {
        return obj -> g.apply((AnalysisSourceMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisSourceMetadata> {
        /**
         * <p>
         * The artifacts of the analysis source metadata.
         * </p>
         * 
         * @param artifacts
         *        The artifacts of the analysis source metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(AnalysisTemplateArtifactMetadata artifacts);

        /**
         * <p>
         * The artifacts of the analysis source metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisTemplateArtifactMetadata.Builder}
         * avoiding the need to create one manually via {@link AnalysisTemplateArtifactMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisTemplateArtifactMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #artifacts(AnalysisTemplateArtifactMetadata)}.
         * 
         * @param artifacts
         *        a consumer that will call methods on {@link AnalysisTemplateArtifactMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifacts(AnalysisTemplateArtifactMetadata)
         */
        default Builder artifacts(Consumer<AnalysisTemplateArtifactMetadata.Builder> artifacts) {
            return artifacts(AnalysisTemplateArtifactMetadata.builder().applyMutation(artifacts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnalysisTemplateArtifactMetadata artifacts;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSourceMetadata model) {
            artifacts(model.artifacts);
        }

        public final AnalysisTemplateArtifactMetadata.Builder getArtifacts() {
            return artifacts != null ? artifacts.toBuilder() : null;
        }

        public final void setArtifacts(AnalysisTemplateArtifactMetadata.BuilderImpl artifacts) {
            Object oldValue = this.artifacts;
            this.artifacts = artifacts != null ? artifacts.build() : null;
            handleUnionValueChange(Type.ARTIFACTS, oldValue, this.artifacts);
        }

        @Override
        public final Builder artifacts(AnalysisTemplateArtifactMetadata artifacts) {
            Object oldValue = this.artifacts;
            this.artifacts = artifacts;
            handleUnionValueChange(Type.ARTIFACTS, oldValue, this.artifacts);
            return this;
        }

        @Override
        public AnalysisSourceMetadata build() {
            return new AnalysisSourceMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AnalysisSourceMetadata#type()
     */
    public enum Type {
        ARTIFACTS,

        UNKNOWN_TO_SDK_VERSION
    }
}
