/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Controls on the query specifications that can be run on configured table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisRulePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalysisRulePolicy.Builder, AnalysisRulePolicy> {
    private static final SdkField<AnalysisRulePolicyV1> V1_FIELD = SdkField
            .<AnalysisRulePolicyV1> builder(MarshallingType.SDK_POJO).memberName("v1").getter(getter(AnalysisRulePolicy::v1))
            .setter(setter(Builder::v1)).constructor(AnalysisRulePolicyV1::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("v1").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V1_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AnalysisRulePolicyV1 v1;

    private final Type type;

    private AnalysisRulePolicy(BuilderImpl builder) {
        this.v1 = builder.v1;
        this.type = builder.type;
    }

    /**
     * <p>
     * Controls on the query specifications that can be run on configured table.
     * </p>
     * 
     * @return Controls on the query specifications that can be run on configured table.
     */
    public final AnalysisRulePolicyV1 v1() {
        return v1;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(v1());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRulePolicy)) {
            return false;
        }
        AnalysisRulePolicy other = (AnalysisRulePolicy) obj;
        return Objects.equals(v1(), other.v1());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalysisRulePolicy").add("V1", v1()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "v1":
            return Optional.ofNullable(clazz.cast(v1()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #v1()} initialized to the given value.
     *
     * <p>
     * Controls on the query specifications that can be run on configured table.
     * </p>
     * 
     * @param v1
     *        Controls on the query specifications that can be run on configured table.
     */
    public static AnalysisRulePolicy fromV1(AnalysisRulePolicyV1 v1) {
        return builder().v1(v1).build();
    }

    /**
     * Create an instance of this class with {@link #v1()} initialized to the given value.
     *
     * <p>
     * Controls on the query specifications that can be run on configured table.
     * </p>
     * 
     * @param v1
     *        Controls on the query specifications that can be run on configured table.
     */
    public static AnalysisRulePolicy fromV1(Consumer<AnalysisRulePolicyV1.Builder> v1) {
        AnalysisRulePolicyV1.Builder builder = AnalysisRulePolicyV1.builder();
        v1.accept(builder);
        return fromV1(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("v1", V1_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRulePolicy, T> g) {
        return obj -> g.apply((AnalysisRulePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisRulePolicy> {
        /**
         * <p>
         * Controls on the query specifications that can be run on configured table.
         * </p>
         * 
         * @param v1
         *        Controls on the query specifications that can be run on configured table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder v1(AnalysisRulePolicyV1 v1);

        /**
         * <p>
         * Controls on the query specifications that can be run on configured table.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnalysisRulePolicyV1.Builder} avoiding
         * the need to create one manually via {@link AnalysisRulePolicyV1#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnalysisRulePolicyV1.Builder#build()} is called immediately and
         * its result is passed to {@link #v1(AnalysisRulePolicyV1)}.
         * 
         * @param v1
         *        a consumer that will call methods on {@link AnalysisRulePolicyV1.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #v1(AnalysisRulePolicyV1)
         */
        default Builder v1(Consumer<AnalysisRulePolicyV1.Builder> v1) {
            return v1(AnalysisRulePolicyV1.builder().applyMutation(v1).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnalysisRulePolicyV1 v1;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRulePolicy model) {
            v1(model.v1);
        }

        public final AnalysisRulePolicyV1.Builder getV1() {
            return v1 != null ? v1.toBuilder() : null;
        }

        public final void setV1(AnalysisRulePolicyV1.BuilderImpl v1) {
            Object oldValue = this.v1;
            this.v1 = v1 != null ? v1.build() : null;
            handleUnionValueChange(Type.V1, oldValue, this.v1);
        }

        @Override
        public final Builder v1(AnalysisRulePolicyV1 v1) {
            Object oldValue = this.v1;
            this.v1 = v1;
            handleUnionValueChange(Type.V1, oldValue, this.v1);
            return this;
        }

        @Override
        public AnalysisRulePolicy build() {
            return new AnalysisRulePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AnalysisRulePolicy#type()
     */
    public enum Type {
        V1,

        UNKNOWN_TO_SDK_VERSION
    }
}
