/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.AccessBudgetsPrivacyTemplateParametersInput;
import software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyTemplateParametersInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PrivacyBudgetTemplateParametersInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PrivacyBudgetTemplateParametersInput> {
    private static final SdkField<DifferentialPrivacyTemplateParametersInput> DIFFERENTIAL_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("differentialPrivacy").getter(PrivacyBudgetTemplateParametersInput.getter(PrivacyBudgetTemplateParametersInput::differentialPrivacy)).setter(PrivacyBudgetTemplateParametersInput.setter(Builder::differentialPrivacy)).constructor(DifferentialPrivacyTemplateParametersInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build()}).build();
    private static final SdkField<AccessBudgetsPrivacyTemplateParametersInput> ACCESS_BUDGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("accessBudget").getter(PrivacyBudgetTemplateParametersInput.getter(PrivacyBudgetTemplateParametersInput::accessBudget)).setter(PrivacyBudgetTemplateParametersInput.setter(Builder::accessBudget)).constructor(AccessBudgetsPrivacyTemplateParametersInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessBudget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIFFERENTIAL_PRIVACY_FIELD, ACCESS_BUDGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PrivacyBudgetTemplateParametersInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DifferentialPrivacyTemplateParametersInput differentialPrivacy;
    private final AccessBudgetsPrivacyTemplateParametersInput accessBudget;
    private final Type type;

    private PrivacyBudgetTemplateParametersInput(BuilderImpl builder) {
        this.differentialPrivacy = builder.differentialPrivacy;
        this.accessBudget = builder.accessBudget;
        this.type = builder.type;
    }

    public final DifferentialPrivacyTemplateParametersInput differentialPrivacy() {
        return this.differentialPrivacy;
    }

    public final AccessBudgetsPrivacyTemplateParametersInput accessBudget() {
        return this.accessBudget;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.differentialPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessBudget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivacyBudgetTemplateParametersInput)) {
            return false;
        }
        PrivacyBudgetTemplateParametersInput other = (PrivacyBudgetTemplateParametersInput)obj;
        return Objects.equals(this.differentialPrivacy(), other.differentialPrivacy()) && Objects.equals(this.accessBudget(), other.accessBudget());
    }

    public final String toString() {
        return ToString.builder((String)"PrivacyBudgetTemplateParametersInput").add("DifferentialPrivacy", (Object)this.differentialPrivacy()).add("AccessBudget", (Object)this.accessBudget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "differentialPrivacy": {
                return Optional.ofNullable(clazz.cast(this.differentialPrivacy()));
            }
            case "accessBudget": {
                return Optional.ofNullable(clazz.cast(this.accessBudget()));
            }
        }
        return Optional.empty();
    }

    public static PrivacyBudgetTemplateParametersInput fromDifferentialPrivacy(DifferentialPrivacyTemplateParametersInput differentialPrivacy) {
        return (PrivacyBudgetTemplateParametersInput)PrivacyBudgetTemplateParametersInput.builder().differentialPrivacy(differentialPrivacy).build();
    }

    public static PrivacyBudgetTemplateParametersInput fromDifferentialPrivacy(Consumer<DifferentialPrivacyTemplateParametersInput.Builder> differentialPrivacy) {
        DifferentialPrivacyTemplateParametersInput.Builder builder = DifferentialPrivacyTemplateParametersInput.builder();
        differentialPrivacy.accept(builder);
        return PrivacyBudgetTemplateParametersInput.fromDifferentialPrivacy((DifferentialPrivacyTemplateParametersInput)builder.build());
    }

    public static PrivacyBudgetTemplateParametersInput fromAccessBudget(AccessBudgetsPrivacyTemplateParametersInput accessBudget) {
        return (PrivacyBudgetTemplateParametersInput)PrivacyBudgetTemplateParametersInput.builder().accessBudget(accessBudget).build();
    }

    public static PrivacyBudgetTemplateParametersInput fromAccessBudget(Consumer<AccessBudgetsPrivacyTemplateParametersInput.Builder> accessBudget) {
        AccessBudgetsPrivacyTemplateParametersInput.Builder builder = AccessBudgetsPrivacyTemplateParametersInput.builder();
        accessBudget.accept(builder);
        return PrivacyBudgetTemplateParametersInput.fromAccessBudget((AccessBudgetsPrivacyTemplateParametersInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("differentialPrivacy", DIFFERENTIAL_PRIVACY_FIELD);
        map.put("accessBudget", ACCESS_BUDGET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivacyBudgetTemplateParametersInput, T> g) {
        return obj -> g.apply((PrivacyBudgetTemplateParametersInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        DIFFERENTIAL_PRIVACY,
        ACCESS_BUDGET,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private DifferentialPrivacyTemplateParametersInput differentialPrivacy;
        private AccessBudgetsPrivacyTemplateParametersInput accessBudget;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PrivacyBudgetTemplateParametersInput model) {
            this.differentialPrivacy(model.differentialPrivacy);
            this.accessBudget(model.accessBudget);
        }

        public final DifferentialPrivacyTemplateParametersInput.Builder getDifferentialPrivacy() {
            return this.differentialPrivacy != null ? this.differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyTemplateParametersInput.BuilderImpl differentialPrivacy) {
            DifferentialPrivacyTemplateParametersInput oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
            this.handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyTemplateParametersInput differentialPrivacy) {
            DifferentialPrivacyTemplateParametersInput oldValue = this.differentialPrivacy;
            this.differentialPrivacy = differentialPrivacy;
            this.handleUnionValueChange(Type.DIFFERENTIAL_PRIVACY, oldValue, this.differentialPrivacy);
            return this;
        }

        public final AccessBudgetsPrivacyTemplateParametersInput.Builder getAccessBudget() {
            return this.accessBudget != null ? this.accessBudget.toBuilder() : null;
        }

        public final void setAccessBudget(AccessBudgetsPrivacyTemplateParametersInput.BuilderImpl accessBudget) {
            AccessBudgetsPrivacyTemplateParametersInput oldValue = this.accessBudget;
            this.accessBudget = accessBudget != null ? accessBudget.build() : null;
            this.handleUnionValueChange(Type.ACCESS_BUDGET, oldValue, this.accessBudget);
        }

        @Override
        public final Builder accessBudget(AccessBudgetsPrivacyTemplateParametersInput accessBudget) {
            AccessBudgetsPrivacyTemplateParametersInput oldValue = this.accessBudget;
            this.accessBudget = accessBudget;
            this.handleUnionValueChange(Type.ACCESS_BUDGET, oldValue, this.accessBudget);
            return this;
        }

        public PrivacyBudgetTemplateParametersInput build() {
            return new PrivacyBudgetTemplateParametersInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PrivacyBudgetTemplateParametersInput> {
        public Builder differentialPrivacy(DifferentialPrivacyTemplateParametersInput var1);

        default public Builder differentialPrivacy(Consumer<DifferentialPrivacyTemplateParametersInput.Builder> differentialPrivacy) {
            return this.differentialPrivacy((DifferentialPrivacyTemplateParametersInput)((DifferentialPrivacyTemplateParametersInput.Builder)DifferentialPrivacyTemplateParametersInput.builder().applyMutation(differentialPrivacy)).build());
        }

        public Builder accessBudget(AccessBudgetsPrivacyTemplateParametersInput var1);

        default public Builder accessBudget(Consumer<AccessBudgetsPrivacyTemplateParametersInput.Builder> accessBudget) {
            return this.accessBudget((AccessBudgetsPrivacyTemplateParametersInput)((AccessBudgetsPrivacyTemplateParametersInput.Builder)AccessBudgetsPrivacyTemplateParametersInput.builder().applyMutation(accessBudget)).build());
        }
    }
}

