/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.ChangeInput;
import software.amazon.awssdk.services.cleanrooms.model.ChangeInputListCopier;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCollaborationChangeRequestRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateCollaborationChangeRequestRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(CreateCollaborationChangeRequestRequest.getter(CreateCollaborationChangeRequestRequest::collaborationIdentifier)).setter(CreateCollaborationChangeRequestRequest.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<List<ChangeInput>> CHANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("changes").getter(CreateCollaborationChangeRequestRequest.getter(CreateCollaborationChangeRequestRequest::changes)).setter(CreateCollaborationChangeRequestRequest.setter(Builder::changes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_IDENTIFIER_FIELD, CHANGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCollaborationChangeRequestRequest.memberNameToFieldInitializer();
    private final String collaborationIdentifier;
    private final List<ChangeInput> changes;

    private CreateCollaborationChangeRequestRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.changes = builder.changes;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final boolean hasChanges() {
        return this.changes != null && !(this.changes instanceof SdkAutoConstructList);
    }

    public final List<ChangeInput> changes() {
        return this.changes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChanges() ? this.changes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollaborationChangeRequestRequest)) {
            return false;
        }
        CreateCollaborationChangeRequestRequest other = (CreateCollaborationChangeRequestRequest)((Object)obj);
        return Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && this.hasChanges() == other.hasChanges() && Objects.equals(this.changes(), other.changes());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCollaborationChangeRequestRequest").add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("Changes", this.hasChanges() ? this.changes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "changes": {
                return Optional.ofNullable(clazz.cast(this.changes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("changes", CHANGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCollaborationChangeRequestRequest, T> g) {
        return obj -> g.apply((CreateCollaborationChangeRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String collaborationIdentifier;
        private List<ChangeInput> changes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollaborationChangeRequestRequest model) {
            super(model);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.changes(model.changes);
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final List<ChangeInput.Builder> getChanges() {
            List<ChangeInput.Builder> result = ChangeInputListCopier.copyToBuilder(this.changes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChanges(Collection<ChangeInput.BuilderImpl> changes) {
            this.changes = ChangeInputListCopier.copyFromBuilder(changes);
        }

        @Override
        public final Builder changes(Collection<ChangeInput> changes) {
            this.changes = ChangeInputListCopier.copy(changes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(ChangeInput ... changes) {
            this.changes(Arrays.asList(changes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changes(Consumer<ChangeInput.Builder> ... changes) {
            this.changes(Stream.of(changes).map(c -> (ChangeInput)((ChangeInput.Builder)ChangeInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCollaborationChangeRequestRequest build() {
            return new CreateCollaborationChangeRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCollaborationChangeRequestRequest> {
        public Builder collaborationIdentifier(String var1);

        public Builder changes(Collection<ChangeInput> var1);

        public Builder changes(ChangeInput ... var1);

        public Builder changes(Consumer<ChangeInput.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

