/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.AccessBudgetType;
import software.amazon.awssdk.services.cleanrooms.model.AutoRefreshMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BudgetParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BudgetParameter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(BudgetParameter.getter(BudgetParameter::typeAsString)).setter(BudgetParameter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Integer> BUDGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("budget").getter(BudgetParameter.getter(BudgetParameter::budget)).setter(BudgetParameter.setter(Builder::budget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("budget").build()}).build();
    private static final SdkField<String> AUTO_REFRESH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("autoRefresh").getter(BudgetParameter.getter(BudgetParameter::autoRefreshAsString)).setter(BudgetParameter.setter(Builder::autoRefresh)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRefresh").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, BUDGET_FIELD, AUTO_REFRESH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BudgetParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Integer budget;
    private final String autoRefresh;

    private BudgetParameter(BuilderImpl builder) {
        this.type = builder.type;
        this.budget = builder.budget;
        this.autoRefresh = builder.autoRefresh;
    }

    public final AccessBudgetType type() {
        return AccessBudgetType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer budget() {
        return this.budget;
    }

    public final AutoRefreshMode autoRefresh() {
        return AutoRefreshMode.fromValue(this.autoRefresh);
    }

    public final String autoRefreshAsString() {
        return this.autoRefresh;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.budget());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRefreshAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetParameter)) {
            return false;
        }
        BudgetParameter other = (BudgetParameter)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.budget(), other.budget()) && Objects.equals(this.autoRefreshAsString(), other.autoRefreshAsString());
    }

    public final String toString() {
        return ToString.builder((String)"BudgetParameter").add("Type", (Object)this.typeAsString()).add("Budget", (Object)this.budget()).add("AutoRefresh", (Object)this.autoRefreshAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "budget": {
                return Optional.ofNullable(clazz.cast(this.budget()));
            }
            case "autoRefresh": {
                return Optional.ofNullable(clazz.cast(this.autoRefreshAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("budget", BUDGET_FIELD);
        map.put("autoRefresh", AUTO_REFRESH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BudgetParameter, T> g) {
        return obj -> g.apply((BudgetParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer budget;
        private String autoRefresh;

        private BuilderImpl() {
        }

        private BuilderImpl(BudgetParameter model) {
            this.type(model.type);
            this.budget(model.budget);
            this.autoRefresh(model.autoRefresh);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccessBudgetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getBudget() {
            return this.budget;
        }

        public final void setBudget(Integer budget) {
            this.budget = budget;
        }

        @Override
        public final Builder budget(Integer budget) {
            this.budget = budget;
            return this;
        }

        public final String getAutoRefresh() {
            return this.autoRefresh;
        }

        public final void setAutoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
        }

        @Override
        public final Builder autoRefresh(String autoRefresh) {
            this.autoRefresh = autoRefresh;
            return this;
        }

        @Override
        public final Builder autoRefresh(AutoRefreshMode autoRefresh) {
            this.autoRefresh(autoRefresh == null ? null : autoRefresh.toString());
            return this;
        }

        public BudgetParameter build() {
            return new BudgetParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BudgetParameter> {
        public Builder type(String var1);

        public Builder type(AccessBudgetType var1);

        public Builder budget(Integer var1);

        public Builder autoRefresh(String var1);

        public Builder autoRefresh(AutoRefreshMode var1);
    }
}

