/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.Hash;
import software.amazon.awssdk.services.cleanrooms.model.HashListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisTemplateArtifactMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisTemplateArtifactMetadata> {
    private static final SdkField<Hash> ENTRY_POINT_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("entryPointHash").getter(AnalysisTemplateArtifactMetadata.getter(AnalysisTemplateArtifactMetadata::entryPointHash)).setter(AnalysisTemplateArtifactMetadata.setter(Builder::entryPointHash)).constructor(Hash::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPointHash").build()}).build();
    private static final SdkField<List<Hash>> ADDITIONAL_ARTIFACT_HASHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalArtifactHashes").getter(AnalysisTemplateArtifactMetadata.getter(AnalysisTemplateArtifactMetadata::additionalArtifactHashes)).setter(AnalysisTemplateArtifactMetadata.setter(Builder::additionalArtifactHashes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalArtifactHashes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Hash::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_POINT_HASH_FIELD, ADDITIONAL_ARTIFACT_HASHES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisTemplateArtifactMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Hash entryPointHash;
    private final List<Hash> additionalArtifactHashes;

    private AnalysisTemplateArtifactMetadata(BuilderImpl builder) {
        this.entryPointHash = builder.entryPointHash;
        this.additionalArtifactHashes = builder.additionalArtifactHashes;
    }

    public final Hash entryPointHash() {
        return this.entryPointHash;
    }

    public final boolean hasAdditionalArtifactHashes() {
        return this.additionalArtifactHashes != null && !(this.additionalArtifactHashes instanceof SdkAutoConstructList);
    }

    public final List<Hash> additionalArtifactHashes() {
        return this.additionalArtifactHashes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entryPointHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalArtifactHashes() ? this.additionalArtifactHashes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisTemplateArtifactMetadata)) {
            return false;
        }
        AnalysisTemplateArtifactMetadata other = (AnalysisTemplateArtifactMetadata)obj;
        return Objects.equals(this.entryPointHash(), other.entryPointHash()) && this.hasAdditionalArtifactHashes() == other.hasAdditionalArtifactHashes() && Objects.equals(this.additionalArtifactHashes(), other.additionalArtifactHashes());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisTemplateArtifactMetadata").add("EntryPointHash", (Object)this.entryPointHash()).add("AdditionalArtifactHashes", this.hasAdditionalArtifactHashes() ? this.additionalArtifactHashes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entryPointHash": {
                return Optional.ofNullable(clazz.cast(this.entryPointHash()));
            }
            case "additionalArtifactHashes": {
                return Optional.ofNullable(clazz.cast(this.additionalArtifactHashes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entryPointHash", ENTRY_POINT_HASH_FIELD);
        map.put("additionalArtifactHashes", ADDITIONAL_ARTIFACT_HASHES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisTemplateArtifactMetadata, T> g) {
        return obj -> g.apply((AnalysisTemplateArtifactMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Hash entryPointHash;
        private List<Hash> additionalArtifactHashes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisTemplateArtifactMetadata model) {
            this.entryPointHash(model.entryPointHash);
            this.additionalArtifactHashes(model.additionalArtifactHashes);
        }

        public final Hash.Builder getEntryPointHash() {
            return this.entryPointHash != null ? this.entryPointHash.toBuilder() : null;
        }

        public final void setEntryPointHash(Hash.BuilderImpl entryPointHash) {
            this.entryPointHash = entryPointHash != null ? entryPointHash.build() : null;
        }

        @Override
        public final Builder entryPointHash(Hash entryPointHash) {
            this.entryPointHash = entryPointHash;
            return this;
        }

        public final List<Hash.Builder> getAdditionalArtifactHashes() {
            List<Hash.Builder> result = HashListCopier.copyToBuilder(this.additionalArtifactHashes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalArtifactHashes(Collection<Hash.BuilderImpl> additionalArtifactHashes) {
            this.additionalArtifactHashes = HashListCopier.copyFromBuilder(additionalArtifactHashes);
        }

        @Override
        public final Builder additionalArtifactHashes(Collection<Hash> additionalArtifactHashes) {
            this.additionalArtifactHashes = HashListCopier.copy(additionalArtifactHashes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifactHashes(Hash ... additionalArtifactHashes) {
            this.additionalArtifactHashes(Arrays.asList(additionalArtifactHashes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalArtifactHashes(Consumer<Hash.Builder> ... additionalArtifactHashes) {
            this.additionalArtifactHashes(Stream.of(additionalArtifactHashes).map(c -> (Hash)((Hash.Builder)Hash.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AnalysisTemplateArtifactMetadata build() {
            return new AnalysisTemplateArtifactMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisTemplateArtifactMetadata> {
        public Builder entryPointHash(Hash var1);

        default public Builder entryPointHash(Consumer<Hash.Builder> entryPointHash) {
            return this.entryPointHash((Hash)((Hash.Builder)Hash.builder().applyMutation(entryPointHash)).build());
        }

        public Builder additionalArtifactHashes(Collection<Hash> var1);

        public Builder additionalArtifactHashes(Hash ... var1);

        public Builder additionalArtifactHashes(Consumer<Hash.Builder> ... var1);
    }
}

