/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.ConsolidatedPolicyAggregation;
import software.amazon.awssdk.services.cleanrooms.model.ConsolidatedPolicyCustom;
import software.amazon.awssdk.services.cleanrooms.model.ConsolidatedPolicyList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsolidatedPolicyV1
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsolidatedPolicyV1> {
    private static final SdkField<ConsolidatedPolicyList> LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("list").getter(ConsolidatedPolicyV1.getter(ConsolidatedPolicyV1::list)).setter(ConsolidatedPolicyV1.setter(Builder::list)).constructor(ConsolidatedPolicyList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("list").build()}).build();
    private static final SdkField<ConsolidatedPolicyAggregation> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregation").getter(ConsolidatedPolicyV1.getter(ConsolidatedPolicyV1::aggregation)).setter(ConsolidatedPolicyV1.setter(Builder::aggregation)).constructor(ConsolidatedPolicyAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregation").build()}).build();
    private static final SdkField<ConsolidatedPolicyCustom> CUSTOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("custom").getter(ConsolidatedPolicyV1.getter(ConsolidatedPolicyV1::custom)).setter(ConsolidatedPolicyV1.setter(Builder::custom)).constructor(ConsolidatedPolicyCustom::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_FIELD, AGGREGATION_FIELD, CUSTOM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConsolidatedPolicyV1.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ConsolidatedPolicyList list;
    private final ConsolidatedPolicyAggregation aggregation;
    private final ConsolidatedPolicyCustom custom;
    private final Type type;

    private ConsolidatedPolicyV1(BuilderImpl builder) {
        this.list = builder.list;
        this.aggregation = builder.aggregation;
        this.custom = builder.custom;
        this.type = builder.type;
    }

    public final ConsolidatedPolicyList list() {
        return this.list;
    }

    public final ConsolidatedPolicyAggregation aggregation() {
        return this.aggregation;
    }

    public final ConsolidatedPolicyCustom custom() {
        return this.custom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.list());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregation());
        hashCode = 31 * hashCode + Objects.hashCode(this.custom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedPolicyV1)) {
            return false;
        }
        ConsolidatedPolicyV1 other = (ConsolidatedPolicyV1)obj;
        return Objects.equals(this.list(), other.list()) && Objects.equals(this.aggregation(), other.aggregation()) && Objects.equals(this.custom(), other.custom());
    }

    public final String toString() {
        return ToString.builder((String)"ConsolidatedPolicyV1").add("List", (Object)this.list()).add("Aggregation", (Object)this.aggregation()).add("Custom", (Object)this.custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "list": {
                return Optional.ofNullable(clazz.cast(this.list()));
            }
            case "aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregation()));
            }
            case "custom": {
                return Optional.ofNullable(clazz.cast(this.custom()));
            }
        }
        return Optional.empty();
    }

    public static ConsolidatedPolicyV1 fromList(ConsolidatedPolicyList list) {
        return (ConsolidatedPolicyV1)ConsolidatedPolicyV1.builder().list(list).build();
    }

    public static ConsolidatedPolicyV1 fromList(Consumer<ConsolidatedPolicyList.Builder> list) {
        ConsolidatedPolicyList.Builder builder = ConsolidatedPolicyList.builder();
        list.accept(builder);
        return ConsolidatedPolicyV1.fromList((ConsolidatedPolicyList)builder.build());
    }

    public static ConsolidatedPolicyV1 fromAggregation(ConsolidatedPolicyAggregation aggregation) {
        return (ConsolidatedPolicyV1)ConsolidatedPolicyV1.builder().aggregation(aggregation).build();
    }

    public static ConsolidatedPolicyV1 fromAggregation(Consumer<ConsolidatedPolicyAggregation.Builder> aggregation) {
        ConsolidatedPolicyAggregation.Builder builder = ConsolidatedPolicyAggregation.builder();
        aggregation.accept(builder);
        return ConsolidatedPolicyV1.fromAggregation((ConsolidatedPolicyAggregation)builder.build());
    }

    public static ConsolidatedPolicyV1 fromCustom(ConsolidatedPolicyCustom custom) {
        return (ConsolidatedPolicyV1)ConsolidatedPolicyV1.builder().custom(custom).build();
    }

    public static ConsolidatedPolicyV1 fromCustom(Consumer<ConsolidatedPolicyCustom.Builder> custom) {
        ConsolidatedPolicyCustom.Builder builder = ConsolidatedPolicyCustom.builder();
        custom.accept(builder);
        return ConsolidatedPolicyV1.fromCustom((ConsolidatedPolicyCustom)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", LIST_FIELD);
        map.put("aggregation", AGGREGATION_FIELD);
        map.put("custom", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedPolicyV1, T> g) {
        return obj -> g.apply((ConsolidatedPolicyV1)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        LIST,
        AGGREGATION,
        CUSTOM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ConsolidatedPolicyList list;
        private ConsolidatedPolicyAggregation aggregation;
        private ConsolidatedPolicyCustom custom;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedPolicyV1 model) {
            this.list(model.list);
            this.aggregation(model.aggregation);
            this.custom(model.custom);
        }

        public final ConsolidatedPolicyList.Builder getList() {
            return this.list != null ? this.list.toBuilder() : null;
        }

        public final void setList(ConsolidatedPolicyList.BuilderImpl list) {
            ConsolidatedPolicyList oldValue = this.list;
            this.list = list != null ? list.build() : null;
            this.handleUnionValueChange(Type.LIST, oldValue, this.list);
        }

        @Override
        public final Builder list(ConsolidatedPolicyList list) {
            ConsolidatedPolicyList oldValue = this.list;
            this.list = list;
            this.handleUnionValueChange(Type.LIST, oldValue, this.list);
            return this;
        }

        public final ConsolidatedPolicyAggregation.Builder getAggregation() {
            return this.aggregation != null ? this.aggregation.toBuilder() : null;
        }

        public final void setAggregation(ConsolidatedPolicyAggregation.BuilderImpl aggregation) {
            ConsolidatedPolicyAggregation oldValue = this.aggregation;
            this.aggregation = aggregation != null ? aggregation.build() : null;
            this.handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
        }

        @Override
        public final Builder aggregation(ConsolidatedPolicyAggregation aggregation) {
            ConsolidatedPolicyAggregation oldValue = this.aggregation;
            this.aggregation = aggregation;
            this.handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
            return this;
        }

        public final ConsolidatedPolicyCustom.Builder getCustom() {
            return this.custom != null ? this.custom.toBuilder() : null;
        }

        public final void setCustom(ConsolidatedPolicyCustom.BuilderImpl custom) {
            ConsolidatedPolicyCustom oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            this.handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(ConsolidatedPolicyCustom custom) {
            ConsolidatedPolicyCustom oldValue = this.custom;
            this.custom = custom;
            this.handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        public ConsolidatedPolicyV1 build() {
            return new ConsolidatedPolicyV1(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsolidatedPolicyV1> {
        public Builder list(ConsolidatedPolicyList var1);

        default public Builder list(Consumer<ConsolidatedPolicyList.Builder> list) {
            return this.list((ConsolidatedPolicyList)((ConsolidatedPolicyList.Builder)ConsolidatedPolicyList.builder().applyMutation(list)).build());
        }

        public Builder aggregation(ConsolidatedPolicyAggregation var1);

        default public Builder aggregation(Consumer<ConsolidatedPolicyAggregation.Builder> aggregation) {
            return this.aggregation((ConsolidatedPolicyAggregation)((ConsolidatedPolicyAggregation.Builder)ConsolidatedPolicyAggregation.builder().applyMutation(aggregation)).build());
        }

        public Builder custom(ConsolidatedPolicyCustom var1);

        default public Builder custom(Consumer<ConsolidatedPolicyCustom.Builder> custom) {
            return this.custom((ConsolidatedPolicyCustom)((ConsolidatedPolicyCustom.Builder)ConsolidatedPolicyCustom.builder().applyMutation(custom)).build());
        }
    }
}

