/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateArnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetCollaborationAnalysisTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, BatchGetCollaborationAnalysisTemplateRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(BatchGetCollaborationAnalysisTemplateRequest.getter(BatchGetCollaborationAnalysisTemplateRequest::collaborationIdentifier)).setter(BatchGetCollaborationAnalysisTemplateRequest.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<List<String>> ANALYSIS_TEMPLATE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisTemplateArns").getter(BatchGetCollaborationAnalysisTemplateRequest.getter(BatchGetCollaborationAnalysisTemplateRequest::analysisTemplateArns)).setter(BatchGetCollaborationAnalysisTemplateRequest.setter(Builder::analysisTemplateArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisTemplateArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_IDENTIFIER_FIELD, ANALYSIS_TEMPLATE_ARNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetCollaborationAnalysisTemplateRequest.memberNameToFieldInitializer();
    private final String collaborationIdentifier;
    private final List<String> analysisTemplateArns;

    private BatchGetCollaborationAnalysisTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.analysisTemplateArns = builder.analysisTemplateArns;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final boolean hasAnalysisTemplateArns() {
        return this.analysisTemplateArns != null && !(this.analysisTemplateArns instanceof SdkAutoConstructList);
    }

    public final List<String> analysisTemplateArns() {
        return this.analysisTemplateArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisTemplateArns() ? this.analysisTemplateArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCollaborationAnalysisTemplateRequest)) {
            return false;
        }
        BatchGetCollaborationAnalysisTemplateRequest other = (BatchGetCollaborationAnalysisTemplateRequest)((Object)obj);
        return Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && this.hasAnalysisTemplateArns() == other.hasAnalysisTemplateArns() && Objects.equals(this.analysisTemplateArns(), other.analysisTemplateArns());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetCollaborationAnalysisTemplateRequest").add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("AnalysisTemplateArns", this.hasAnalysisTemplateArns() ? this.analysisTemplateArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "analysisTemplateArns": {
                return Optional.ofNullable(clazz.cast(this.analysisTemplateArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("analysisTemplateArns", ANALYSIS_TEMPLATE_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCollaborationAnalysisTemplateRequest, T> g) {
        return obj -> g.apply((BatchGetCollaborationAnalysisTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String collaborationIdentifier;
        private List<String> analysisTemplateArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCollaborationAnalysisTemplateRequest model) {
            super(model);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.analysisTemplateArns(model.analysisTemplateArns);
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final Collection<String> getAnalysisTemplateArns() {
            if (this.analysisTemplateArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.analysisTemplateArns;
        }

        public final void setAnalysisTemplateArns(Collection<String> analysisTemplateArns) {
            this.analysisTemplateArns = AnalysisTemplateArnListCopier.copy(analysisTemplateArns);
        }

        @Override
        public final Builder analysisTemplateArns(Collection<String> analysisTemplateArns) {
            this.analysisTemplateArns = AnalysisTemplateArnListCopier.copy(analysisTemplateArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisTemplateArns(String ... analysisTemplateArns) {
            this.analysisTemplateArns(Arrays.asList(analysisTemplateArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetCollaborationAnalysisTemplateRequest build() {
            return new BatchGetCollaborationAnalysisTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetCollaborationAnalysisTemplateRequest> {
        public Builder collaborationIdentifier(String var1);

        public Builder analysisTemplateArns(Collection<String> var1);

        public Builder analysisTemplateArns(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

