/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationIdNamespaceAssociationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationIdNamespaceAssociationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationIdNamespaceAssociationsResponse;

public class ListCollaborationIdNamespaceAssociationsPublisher
implements SdkPublisher<ListCollaborationIdNamespaceAssociationsResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListCollaborationIdNamespaceAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationIdNamespaceAssociationsPublisher(CleanRoomsAsyncClient client, ListCollaborationIdNamespaceAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationIdNamespaceAssociationsPublisher(CleanRoomsAsyncClient client, ListCollaborationIdNamespaceAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationIdNamespaceAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationIdNamespaceAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationIdNamespaceAssociationSummary> collaborationIdNamespaceAssociationSummaries() {
        Function<ListCollaborationIdNamespaceAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationIdNamespaceAssociationSummaries() != null) {
                return response.collaborationIdNamespaceAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationIdNamespaceAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationIdNamespaceAssociationsResponseFetcher
    implements AsyncPageFetcher<ListCollaborationIdNamespaceAssociationsResponse> {
        private ListCollaborationIdNamespaceAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationIdNamespaceAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationIdNamespaceAssociationsResponse> nextPage(ListCollaborationIdNamespaceAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationIdNamespaceAssociationsPublisher.this.client.listCollaborationIdNamespaceAssociations(ListCollaborationIdNamespaceAssociationsPublisher.this.firstRequest);
            }
            return ListCollaborationIdNamespaceAssociationsPublisher.this.client.listCollaborationIdNamespaceAssociations((ListCollaborationIdNamespaceAssociationsRequest)((Object)ListCollaborationIdNamespaceAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

