/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRulePolicy;
import software.amazon.awssdk.services.cleanrooms.model.ConfiguredTableAnalysisRuleType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfiguredTableAnalysisRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfiguredTableAnalysisRule> {
    private static final SdkField<String> CONFIGURED_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableId").getter(ConfiguredTableAnalysisRule.getter(ConfiguredTableAnalysisRule::configuredTableId)).setter(ConfiguredTableAnalysisRule.setter(Builder::configuredTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableId").build()}).build();
    private static final SdkField<String> CONFIGURED_TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configuredTableArn").getter(ConfiguredTableAnalysisRule.getter(ConfiguredTableAnalysisRule::configuredTableArn)).setter(ConfiguredTableAnalysisRule.setter(Builder::configuredTableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuredTableArn").build()}).build();
    private static final SdkField<ConfiguredTableAnalysisRulePolicy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("policy").getter(ConfiguredTableAnalysisRule.getter(ConfiguredTableAnalysisRule::policy)).setter(ConfiguredTableAnalysisRule.setter(Builder::policy)).constructor(ConfiguredTableAnalysisRulePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ConfiguredTableAnalysisRule.getter(ConfiguredTableAnalysisRule::typeAsString)).setter(ConfiguredTableAnalysisRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ConfiguredTableAnalysisRule.getter(ConfiguredTableAnalysisRule::createTime)).setter(ConfiguredTableAnalysisRule.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(ConfiguredTableAnalysisRule.getter(ConfiguredTableAnalysisRule::updateTime)).setter(ConfiguredTableAnalysisRule.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURED_TABLE_ID_FIELD, CONFIGURED_TABLE_ARN_FIELD, POLICY_FIELD, TYPE_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfiguredTableAnalysisRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String configuredTableId;
    private final String configuredTableArn;
    private final ConfiguredTableAnalysisRulePolicy policy;
    private final String type;
    private final Instant createTime;
    private final Instant updateTime;

    private ConfiguredTableAnalysisRule(BuilderImpl builder) {
        this.configuredTableId = builder.configuredTableId;
        this.configuredTableArn = builder.configuredTableArn;
        this.policy = builder.policy;
        this.type = builder.type;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
    }

    public final String configuredTableId() {
        return this.configuredTableId;
    }

    public final String configuredTableArn() {
        return this.configuredTableArn;
    }

    public final ConfiguredTableAnalysisRulePolicy policy() {
        return this.policy;
    }

    public final ConfiguredTableAnalysisRuleType type() {
        return ConfiguredTableAnalysisRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuredTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfiguredTableAnalysisRule)) {
            return false;
        }
        ConfiguredTableAnalysisRule other = (ConfiguredTableAnalysisRule)obj;
        return Objects.equals(this.configuredTableId(), other.configuredTableId()) && Objects.equals(this.configuredTableArn(), other.configuredTableArn()) && Objects.equals(this.policy(), other.policy()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ConfiguredTableAnalysisRule").add("ConfiguredTableId", (Object)this.configuredTableId()).add("ConfiguredTableArn", (Object)this.configuredTableArn()).add("Policy", (Object)this.policy()).add("Type", (Object)this.typeAsString()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configuredTableId": {
                return Optional.ofNullable(clazz.cast(this.configuredTableId()));
            }
            case "configuredTableArn": {
                return Optional.ofNullable(clazz.cast(this.configuredTableArn()));
            }
            case "policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configuredTableId", CONFIGURED_TABLE_ID_FIELD);
        map.put("configuredTableArn", CONFIGURED_TABLE_ARN_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfiguredTableAnalysisRule, T> g) {
        return obj -> g.apply((ConfiguredTableAnalysisRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String configuredTableId;
        private String configuredTableArn;
        private ConfiguredTableAnalysisRulePolicy policy;
        private String type;
        private Instant createTime;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfiguredTableAnalysisRule model) {
            this.configuredTableId(model.configuredTableId);
            this.configuredTableArn(model.configuredTableArn);
            this.policy(model.policy);
            this.type(model.type);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
        }

        public final String getConfiguredTableId() {
            return this.configuredTableId;
        }

        public final void setConfiguredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
        }

        @Override
        public final Builder configuredTableId(String configuredTableId) {
            this.configuredTableId = configuredTableId;
            return this;
        }

        public final String getConfiguredTableArn() {
            return this.configuredTableArn;
        }

        public final void setConfiguredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
        }

        @Override
        public final Builder configuredTableArn(String configuredTableArn) {
            this.configuredTableArn = configuredTableArn;
            return this;
        }

        public final ConfiguredTableAnalysisRulePolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        public final void setPolicy(ConfiguredTableAnalysisRulePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(ConfiguredTableAnalysisRulePolicy policy) {
            this.policy = policy;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConfiguredTableAnalysisRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public ConfiguredTableAnalysisRule build() {
            return new ConfiguredTableAnalysisRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfiguredTableAnalysisRule> {
        public Builder configuredTableId(String var1);

        public Builder configuredTableArn(String var1);

        public Builder policy(ConfiguredTableAnalysisRulePolicy var1);

        default public Builder policy(Consumer<ConfiguredTableAnalysisRulePolicy.Builder> policy) {
            return this.policy((ConfiguredTableAnalysisRulePolicy)((ConfiguredTableAnalysisRulePolicy.Builder)ConfiguredTableAnalysisRulePolicy.builder().applyMutation(policy)).build());
        }

        public Builder type(String var1);

        public Builder type(ConfiguredTableAnalysisRuleType var1);

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);
    }
}

