/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateSummaryListCopier;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnalysisTemplatesResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, ListAnalysisTemplatesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAnalysisTemplatesResponse.getter(ListAnalysisTemplatesResponse::nextToken)).setter(ListAnalysisTemplatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<AnalysisTemplateSummary>> ANALYSIS_TEMPLATE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("analysisTemplateSummaries").getter(ListAnalysisTemplatesResponse.getter(ListAnalysisTemplatesResponse::analysisTemplateSummaries)).setter(ListAnalysisTemplatesResponse.setter(Builder::analysisTemplateSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisTemplateSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisTemplateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ANALYSIS_TEMPLATE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAnalysisTemplatesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<AnalysisTemplateSummary> analysisTemplateSummaries;

    private ListAnalysisTemplatesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.analysisTemplateSummaries = builder.analysisTemplateSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasAnalysisTemplateSummaries() {
        return this.analysisTemplateSummaries != null && !(this.analysisTemplateSummaries instanceof SdkAutoConstructList);
    }

    public final List<AnalysisTemplateSummary> analysisTemplateSummaries() {
        return this.analysisTemplateSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnalysisTemplateSummaries() ? this.analysisTemplateSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalysisTemplatesResponse)) {
            return false;
        }
        ListAnalysisTemplatesResponse other = (ListAnalysisTemplatesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasAnalysisTemplateSummaries() == other.hasAnalysisTemplateSummaries() && Objects.equals(this.analysisTemplateSummaries(), other.analysisTemplateSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnalysisTemplatesResponse").add("NextToken", (Object)this.nextToken()).add("AnalysisTemplateSummaries", this.hasAnalysisTemplateSummaries() ? this.analysisTemplateSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "analysisTemplateSummaries": {
                return Optional.ofNullable(clazz.cast(this.analysisTemplateSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("analysisTemplateSummaries", ANALYSIS_TEMPLATE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAnalysisTemplatesResponse, T> g) {
        return obj -> g.apply((ListAnalysisTemplatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<AnalysisTemplateSummary> analysisTemplateSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalysisTemplatesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.analysisTemplateSummaries(model.analysisTemplateSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<AnalysisTemplateSummary.Builder> getAnalysisTemplateSummaries() {
            List<AnalysisTemplateSummary.Builder> result = AnalysisTemplateSummaryListCopier.copyToBuilder(this.analysisTemplateSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnalysisTemplateSummaries(Collection<AnalysisTemplateSummary.BuilderImpl> analysisTemplateSummaries) {
            this.analysisTemplateSummaries = AnalysisTemplateSummaryListCopier.copyFromBuilder(analysisTemplateSummaries);
        }

        @Override
        public final Builder analysisTemplateSummaries(Collection<AnalysisTemplateSummary> analysisTemplateSummaries) {
            this.analysisTemplateSummaries = AnalysisTemplateSummaryListCopier.copy(analysisTemplateSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisTemplateSummaries(AnalysisTemplateSummary ... analysisTemplateSummaries) {
            this.analysisTemplateSummaries(Arrays.asList(analysisTemplateSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisTemplateSummaries(Consumer<AnalysisTemplateSummary.Builder> ... analysisTemplateSummaries) {
            this.analysisTemplateSummaries(Stream.of(analysisTemplateSummaries).map(c -> (AnalysisTemplateSummary)((AnalysisTemplateSummary.Builder)AnalysisTemplateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAnalysisTemplatesResponse build() {
            return new ListAnalysisTemplatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnalysisTemplatesResponse> {
        public Builder nextToken(String var1);

        public Builder analysisTemplateSummaries(Collection<AnalysisTemplateSummary> var1);

        public Builder analysisTemplateSummaries(AnalysisTemplateSummary ... var1);

        public Builder analysisTemplateSummaries(Consumer<AnalysisTemplateSummary.Builder> ... var1);
    }
}

