/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisTemplateArtifacts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisSource> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(AnalysisSource.getter(AnalysisSource::text)).setter(AnalysisSource.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<AnalysisTemplateArtifacts> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifacts").getter(AnalysisSource.getter(AnalysisSource::artifacts)).setter(AnalysisSource.setter(Builder::artifacts)).constructor(AnalysisTemplateArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, ARTIFACTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalysisSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final AnalysisTemplateArtifacts artifacts;
    private final Type type;

    private AnalysisSource(BuilderImpl builder) {
        this.text = builder.text;
        this.artifacts = builder.artifacts;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final AnalysisTemplateArtifacts artifacts() {
        return this.artifacts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSource)) {
            return false;
        }
        AnalysisSource other = (AnalysisSource)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.artifacts(), other.artifacts());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisSource").add("Text", (Object)(this.text() == null ? null : "*** Sensitive Data Redacted ***")).add("Artifacts", (Object)this.artifacts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
        }
        return Optional.empty();
    }

    public static AnalysisSource fromText(String text) {
        return (AnalysisSource)AnalysisSource.builder().text(text).build();
    }

    public static AnalysisSource fromArtifacts(AnalysisTemplateArtifacts artifacts) {
        return (AnalysisSource)AnalysisSource.builder().artifacts(artifacts).build();
    }

    public static AnalysisSource fromArtifacts(Consumer<AnalysisTemplateArtifacts.Builder> artifacts) {
        AnalysisTemplateArtifacts.Builder builder = AnalysisTemplateArtifacts.builder();
        artifacts.accept(builder);
        return AnalysisSource.fromArtifacts((AnalysisTemplateArtifacts)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("artifacts", ARTIFACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSource, T> g) {
        return obj -> g.apply((AnalysisSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        ARTIFACTS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private AnalysisTemplateArtifacts artifacts;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSource model) {
            this.text(model.text);
            this.artifacts(model.artifacts);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final AnalysisTemplateArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        public final void setArtifacts(AnalysisTemplateArtifacts.BuilderImpl artifacts) {
            AnalysisTemplateArtifacts oldValue = this.artifacts;
            this.artifacts = artifacts != null ? artifacts.build() : null;
            this.handleUnionValueChange(Type.ARTIFACTS, oldValue, this.artifacts);
        }

        @Override
        public final Builder artifacts(AnalysisTemplateArtifacts artifacts) {
            AnalysisTemplateArtifacts oldValue = this.artifacts;
            this.artifacts = artifacts;
            this.handleUnionValueChange(Type.ARTIFACTS, oldValue, this.artifacts);
            return this;
        }

        public AnalysisSource build() {
            return new AnalysisSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisSource> {
        public Builder text(String var1);

        public Builder artifacts(AnalysisTemplateArtifacts var1);

        default public Builder artifacts(Consumer<AnalysisTemplateArtifacts.Builder> artifacts) {
            return this.artifacts((AnalysisTemplateArtifacts)((AnalysisTemplateArtifacts.Builder)AnalysisTemplateArtifacts.builder().applyMutation(artifacts)).build());
        }
    }
}

