/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryMemberOutputListCopier;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryS3Output;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySingleMemberOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedQueryDistributeOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedQueryDistributeOutput> {
    private static final SdkField<ProtectedQueryS3Output> S3_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3").getter(ProtectedQueryDistributeOutput.getter(ProtectedQueryDistributeOutput::s3)).setter(ProtectedQueryDistributeOutput.setter(Builder::s3)).constructor(ProtectedQueryS3Output::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()}).build();
    private static final SdkField<List<ProtectedQuerySingleMemberOutput>> MEMBER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("memberList").getter(ProtectedQueryDistributeOutput.getter(ProtectedQueryDistributeOutput::memberList)).setter(ProtectedQueryDistributeOutput.setter(Builder::memberList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProtectedQuerySingleMemberOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_FIELD, MEMBER_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ProtectedQueryDistributeOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ProtectedQueryS3Output s3;
    private final List<ProtectedQuerySingleMemberOutput> memberList;

    private ProtectedQueryDistributeOutput(BuilderImpl builder) {
        this.s3 = builder.s3;
        this.memberList = builder.memberList;
    }

    public final ProtectedQueryS3Output s3() {
        return this.s3;
    }

    public final boolean hasMemberList() {
        return this.memberList != null && !(this.memberList instanceof SdkAutoConstructList);
    }

    public final List<ProtectedQuerySingleMemberOutput> memberList() {
        return this.memberList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMemberList() ? this.memberList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQueryDistributeOutput)) {
            return false;
        }
        ProtectedQueryDistributeOutput other = (ProtectedQueryDistributeOutput)obj;
        return Objects.equals(this.s3(), other.s3()) && this.hasMemberList() == other.hasMemberList() && Objects.equals(this.memberList(), other.memberList());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedQueryDistributeOutput").add("S3", (Object)this.s3()).add("MemberList", this.hasMemberList() ? this.memberList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3": {
                return Optional.ofNullable(clazz.cast(this.s3()));
            }
            case "memberList": {
                return Optional.ofNullable(clazz.cast(this.memberList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3", S3_FIELD);
        map.put("memberList", MEMBER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQueryDistributeOutput, T> g) {
        return obj -> g.apply((ProtectedQueryDistributeOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ProtectedQueryS3Output s3;
        private List<ProtectedQuerySingleMemberOutput> memberList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQueryDistributeOutput model) {
            this.s3(model.s3);
            this.memberList(model.memberList);
        }

        public final ProtectedQueryS3Output.Builder getS3() {
            return this.s3 != null ? this.s3.toBuilder() : null;
        }

        public final void setS3(ProtectedQueryS3Output.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        @Override
        public final Builder s3(ProtectedQueryS3Output s3) {
            this.s3 = s3;
            return this;
        }

        public final List<ProtectedQuerySingleMemberOutput.Builder> getMemberList() {
            List<ProtectedQuerySingleMemberOutput.Builder> result = ProtectedQueryMemberOutputListCopier.copyToBuilder(this.memberList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMemberList(Collection<ProtectedQuerySingleMemberOutput.BuilderImpl> memberList) {
            this.memberList = ProtectedQueryMemberOutputListCopier.copyFromBuilder(memberList);
        }

        @Override
        public final Builder memberList(Collection<ProtectedQuerySingleMemberOutput> memberList) {
            this.memberList = ProtectedQueryMemberOutputListCopier.copy(memberList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberList(ProtectedQuerySingleMemberOutput ... memberList) {
            this.memberList(Arrays.asList(memberList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder memberList(Consumer<ProtectedQuerySingleMemberOutput.Builder> ... memberList) {
            this.memberList(Stream.of(memberList).map(c -> (ProtectedQuerySingleMemberOutput)((ProtectedQuerySingleMemberOutput.Builder)ProtectedQuerySingleMemberOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ProtectedQueryDistributeOutput build() {
            return new ProtectedQueryDistributeOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedQueryDistributeOutput> {
        public Builder s3(ProtectedQueryS3Output var1);

        default public Builder s3(Consumer<ProtectedQueryS3Output.Builder> s3) {
            return this.s3((ProtectedQueryS3Output)((ProtectedQueryS3Output.Builder)ProtectedQueryS3Output.builder().applyMutation(s3)).build());
        }

        public Builder memberList(Collection<ProtectedQuerySingleMemberOutput> var1);

        public Builder memberList(ProtectedQuerySingleMemberOutput ... var1);

        public Builder memberList(Consumer<ProtectedQuerySingleMemberOutput.Builder> ... var1);
    }
}

