/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListMembersRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListMembersResponse;
import software.amazon.awssdk.services.cleanrooms.model.MemberSummary;

public class ListMembersPublisher
implements SdkPublisher<ListMembersResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListMembersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMembersPublisher(CleanRoomsAsyncClient client, ListMembersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMembersPublisher(CleanRoomsAsyncClient client, ListMembersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMembersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMembersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MemberSummary> memberSummaries() {
        Function<ListMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.memberSummaries() != null) {
                return response.memberSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMembersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMembersResponseFetcher
    implements AsyncPageFetcher<ListMembersResponse> {
        private ListMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMembersResponse> nextPage(ListMembersResponse previousPage) {
            if (previousPage == null) {
                return ListMembersPublisher.this.client.listMembers(ListMembersPublisher.this.firstRequest);
            }
            return ListMembersPublisher.this.client.listMembers((ListMembersRequest)((Object)ListMembersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

