/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListPrivacyBudgetsResponse;
import software.amazon.awssdk.services.cleanrooms.model.PrivacyBudgetSummary;

public class ListPrivacyBudgetsIterable
implements SdkIterable<ListPrivacyBudgetsResponse> {
    private final CleanRoomsClient client;
    private final ListPrivacyBudgetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPrivacyBudgetsIterable(CleanRoomsClient client, ListPrivacyBudgetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPrivacyBudgetsResponseFetcher();
    }

    public Iterator<ListPrivacyBudgetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PrivacyBudgetSummary> privacyBudgetSummaries() {
        Function<ListPrivacyBudgetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.privacyBudgetSummaries() != null) {
                return response.privacyBudgetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPrivacyBudgetsResponseFetcher
    implements SyncPageFetcher<ListPrivacyBudgetsResponse> {
        private ListPrivacyBudgetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrivacyBudgetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPrivacyBudgetsResponse nextPage(ListPrivacyBudgetsResponse previousPage) {
            if (previousPage == null) {
                return ListPrivacyBudgetsIterable.this.client.listPrivacyBudgets(ListPrivacyBudgetsIterable.this.firstRequest);
            }
            return ListPrivacyBudgetsIterable.this.client.listPrivacyBudgets((ListPrivacyBudgetsRequest)((Object)ListPrivacyBudgetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

