/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AdditionalAnalyses;
import software.amazon.awssdk.services.cleanrooms.model.AllowedAdditionalAnalysesCopier;
import software.amazon.awssdk.services.cleanrooms.model.AllowedResultReceiversCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.ConsolidatedPolicyListJoinColumnsListCopier;
import software.amazon.awssdk.services.cleanrooms.model.JoinOperator;
import software.amazon.awssdk.services.cleanrooms.model.JoinOperatorsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsolidatedPolicyList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsolidatedPolicyList> {
    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("joinColumns").getter(ConsolidatedPolicyList.getter(ConsolidatedPolicyList::joinColumns)).setter(ConsolidatedPolicyList.setter(Builder::joinColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_JOIN_OPERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedJoinOperators").getter(ConsolidatedPolicyList.getter(ConsolidatedPolicyList::allowedJoinOperatorsAsStrings)).setter(ConsolidatedPolicyList.setter(Builder::allowedJoinOperatorsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedJoinOperators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIST_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listColumns").getter(ConsolidatedPolicyList.getter(ConsolidatedPolicyList::listColumns)).setter(ConsolidatedPolicyList.setter(Builder::listColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADDITIONAL_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalAnalyses").getter(ConsolidatedPolicyList.getter(ConsolidatedPolicyList::additionalAnalysesAsString)).setter(ConsolidatedPolicyList.setter(Builder::additionalAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAnalyses").build()}).build();
    private static final SdkField<List<String>> ALLOWED_RESULT_RECEIVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedResultReceivers").getter(ConsolidatedPolicyList.getter(ConsolidatedPolicyList::allowedResultReceivers)).setter(ConsolidatedPolicyList.setter(Builder::allowedResultReceivers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedResultReceivers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_ADDITIONAL_ANALYSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedAdditionalAnalyses").getter(ConsolidatedPolicyList.getter(ConsolidatedPolicyList::allowedAdditionalAnalyses)).setter(ConsolidatedPolicyList.setter(Builder::allowedAdditionalAnalyses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedAdditionalAnalyses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_COLUMNS_FIELD, ALLOWED_JOIN_OPERATORS_FIELD, LIST_COLUMNS_FIELD, ADDITIONAL_ANALYSES_FIELD, ALLOWED_RESULT_RECEIVERS_FIELD, ALLOWED_ADDITIONAL_ANALYSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConsolidatedPolicyList.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> joinColumns;
    private final List<String> allowedJoinOperators;
    private final List<String> listColumns;
    private final String additionalAnalyses;
    private final List<String> allowedResultReceivers;
    private final List<String> allowedAdditionalAnalyses;

    private ConsolidatedPolicyList(BuilderImpl builder) {
        this.joinColumns = builder.joinColumns;
        this.allowedJoinOperators = builder.allowedJoinOperators;
        this.listColumns = builder.listColumns;
        this.additionalAnalyses = builder.additionalAnalyses;
        this.allowedResultReceivers = builder.allowedResultReceivers;
        this.allowedAdditionalAnalyses = builder.allowedAdditionalAnalyses;
    }

    public final boolean hasJoinColumns() {
        return this.joinColumns != null && !(this.joinColumns instanceof SdkAutoConstructList);
    }

    public final List<String> joinColumns() {
        return this.joinColumns;
    }

    public final List<JoinOperator> allowedJoinOperators() {
        return JoinOperatorsListCopier.copyStringToEnum(this.allowedJoinOperators);
    }

    public final boolean hasAllowedJoinOperators() {
        return this.allowedJoinOperators != null && !(this.allowedJoinOperators instanceof SdkAutoConstructList);
    }

    public final List<String> allowedJoinOperatorsAsStrings() {
        return this.allowedJoinOperators;
    }

    public final boolean hasListColumns() {
        return this.listColumns != null && !(this.listColumns instanceof SdkAutoConstructList);
    }

    public final List<String> listColumns() {
        return this.listColumns;
    }

    public final AdditionalAnalyses additionalAnalyses() {
        return AdditionalAnalyses.fromValue(this.additionalAnalyses);
    }

    public final String additionalAnalysesAsString() {
        return this.additionalAnalyses;
    }

    public final boolean hasAllowedResultReceivers() {
        return this.allowedResultReceivers != null && !(this.allowedResultReceivers instanceof SdkAutoConstructList);
    }

    public final List<String> allowedResultReceivers() {
        return this.allowedResultReceivers;
    }

    public final boolean hasAllowedAdditionalAnalyses() {
        return this.allowedAdditionalAnalyses != null && !(this.allowedAdditionalAnalyses instanceof SdkAutoConstructList);
    }

    public final List<String> allowedAdditionalAnalyses() {
        return this.allowedAdditionalAnalyses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJoinColumns() ? this.joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedJoinOperators() ? this.allowedJoinOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListColumns() ? this.listColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalAnalysesAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedResultReceivers() ? this.allowedResultReceivers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedAdditionalAnalyses() ? this.allowedAdditionalAnalyses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsolidatedPolicyList)) {
            return false;
        }
        ConsolidatedPolicyList other = (ConsolidatedPolicyList)obj;
        return this.hasJoinColumns() == other.hasJoinColumns() && Objects.equals(this.joinColumns(), other.joinColumns()) && this.hasAllowedJoinOperators() == other.hasAllowedJoinOperators() && Objects.equals(this.allowedJoinOperatorsAsStrings(), other.allowedJoinOperatorsAsStrings()) && this.hasListColumns() == other.hasListColumns() && Objects.equals(this.listColumns(), other.listColumns()) && Objects.equals(this.additionalAnalysesAsString(), other.additionalAnalysesAsString()) && this.hasAllowedResultReceivers() == other.hasAllowedResultReceivers() && Objects.equals(this.allowedResultReceivers(), other.allowedResultReceivers()) && this.hasAllowedAdditionalAnalyses() == other.hasAllowedAdditionalAnalyses() && Objects.equals(this.allowedAdditionalAnalyses(), other.allowedAdditionalAnalyses());
    }

    public final String toString() {
        return ToString.builder((String)"ConsolidatedPolicyList").add("JoinColumns", this.hasJoinColumns() ? this.joinColumns() : null).add("AllowedJoinOperators", this.hasAllowedJoinOperators() ? this.allowedJoinOperatorsAsStrings() : null).add("ListColumns", this.hasListColumns() ? this.listColumns() : null).add("AdditionalAnalyses", (Object)this.additionalAnalysesAsString()).add("AllowedResultReceivers", this.hasAllowedResultReceivers() ? this.allowedResultReceivers() : null).add("AllowedAdditionalAnalyses", this.hasAllowedAdditionalAnalyses() ? this.allowedAdditionalAnalyses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "joinColumns": {
                return Optional.ofNullable(clazz.cast(this.joinColumns()));
            }
            case "allowedJoinOperators": {
                return Optional.ofNullable(clazz.cast(this.allowedJoinOperatorsAsStrings()));
            }
            case "listColumns": {
                return Optional.ofNullable(clazz.cast(this.listColumns()));
            }
            case "additionalAnalyses": {
                return Optional.ofNullable(clazz.cast(this.additionalAnalysesAsString()));
            }
            case "allowedResultReceivers": {
                return Optional.ofNullable(clazz.cast(this.allowedResultReceivers()));
            }
            case "allowedAdditionalAnalyses": {
                return Optional.ofNullable(clazz.cast(this.allowedAdditionalAnalyses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("joinColumns", JOIN_COLUMNS_FIELD);
        map.put("allowedJoinOperators", ALLOWED_JOIN_OPERATORS_FIELD);
        map.put("listColumns", LIST_COLUMNS_FIELD);
        map.put("additionalAnalyses", ADDITIONAL_ANALYSES_FIELD);
        map.put("allowedResultReceivers", ALLOWED_RESULT_RECEIVERS_FIELD);
        map.put("allowedAdditionalAnalyses", ALLOWED_ADDITIONAL_ANALYSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsolidatedPolicyList, T> g) {
        return obj -> g.apply((ConsolidatedPolicyList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedJoinOperators = DefaultSdkAutoConstructList.getInstance();
        private List<String> listColumns = DefaultSdkAutoConstructList.getInstance();
        private String additionalAnalyses;
        private List<String> allowedResultReceivers = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedAdditionalAnalyses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConsolidatedPolicyList model) {
            this.joinColumns(model.joinColumns);
            this.allowedJoinOperatorsWithStrings(model.allowedJoinOperators);
            this.listColumns(model.listColumns);
            this.additionalAnalyses(model.additionalAnalyses);
            this.allowedResultReceivers(model.allowedResultReceivers);
            this.allowedAdditionalAnalyses(model.allowedAdditionalAnalyses);
        }

        public final Collection<String> getJoinColumns() {
            if (this.joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = ConsolidatedPolicyListJoinColumnsListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = ConsolidatedPolicyListJoinColumnsListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String ... joinColumns) {
            this.joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final Collection<String> getAllowedJoinOperators() {
            if (this.allowedJoinOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedJoinOperators;
        }

        public final void setAllowedJoinOperators(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
        }

        @Override
        public final Builder allowedJoinOperatorsWithStrings(Collection<String> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copy(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperatorsWithStrings(String ... allowedJoinOperators) {
            this.allowedJoinOperatorsWithStrings(Arrays.asList(allowedJoinOperators));
            return this;
        }

        @Override
        public final Builder allowedJoinOperators(Collection<JoinOperator> allowedJoinOperators) {
            this.allowedJoinOperators = JoinOperatorsListCopier.copyEnumToString(allowedJoinOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedJoinOperators(JoinOperator ... allowedJoinOperators) {
            this.allowedJoinOperators(Arrays.asList(allowedJoinOperators));
            return this;
        }

        public final Collection<String> getListColumns() {
            if (this.listColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listColumns;
        }

        public final void setListColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
        }

        @Override
        public final Builder listColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listColumns(String ... listColumns) {
            this.listColumns(Arrays.asList(listColumns));
            return this;
        }

        public final String getAdditionalAnalyses() {
            return this.additionalAnalyses;
        }

        public final void setAdditionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
        }

        @Override
        public final Builder additionalAnalyses(String additionalAnalyses) {
            this.additionalAnalyses = additionalAnalyses;
            return this;
        }

        @Override
        public final Builder additionalAnalyses(AdditionalAnalyses additionalAnalyses) {
            this.additionalAnalyses(additionalAnalyses == null ? null : additionalAnalyses.toString());
            return this;
        }

        public final Collection<String> getAllowedResultReceivers() {
            if (this.allowedResultReceivers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedResultReceivers;
        }

        public final void setAllowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
        }

        @Override
        public final Builder allowedResultReceivers(Collection<String> allowedResultReceivers) {
            this.allowedResultReceivers = AllowedResultReceiversCopier.copy(allowedResultReceivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedResultReceivers(String ... allowedResultReceivers) {
            this.allowedResultReceivers(Arrays.asList(allowedResultReceivers));
            return this;
        }

        public final Collection<String> getAllowedAdditionalAnalyses() {
            if (this.allowedAdditionalAnalyses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedAdditionalAnalyses;
        }

        public final void setAllowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
        }

        @Override
        public final Builder allowedAdditionalAnalyses(Collection<String> allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses = AllowedAdditionalAnalysesCopier.copy(allowedAdditionalAnalyses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedAdditionalAnalyses(String ... allowedAdditionalAnalyses) {
            this.allowedAdditionalAnalyses(Arrays.asList(allowedAdditionalAnalyses));
            return this;
        }

        public ConsolidatedPolicyList build() {
            return new ConsolidatedPolicyList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsolidatedPolicyList> {
        public Builder joinColumns(Collection<String> var1);

        public Builder joinColumns(String ... var1);

        public Builder allowedJoinOperatorsWithStrings(Collection<String> var1);

        public Builder allowedJoinOperatorsWithStrings(String ... var1);

        public Builder allowedJoinOperators(Collection<JoinOperator> var1);

        public Builder allowedJoinOperators(JoinOperator ... var1);

        public Builder listColumns(Collection<String> var1);

        public Builder listColumns(String ... var1);

        public Builder additionalAnalyses(String var1);

        public Builder additionalAnalyses(AdditionalAnalyses var1);

        public Builder allowedResultReceivers(Collection<String> var1);

        public Builder allowedResultReceivers(String ... var1);

        public Builder allowedAdditionalAnalyses(Collection<String> var1);

        public Builder allowedAdditionalAnalyses(String ... var1);
    }
}

