/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCollaborationAnalysisTemplateRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, GetCollaborationAnalysisTemplateRequest> {
    private static final SdkField<String> COLLABORATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("collaborationIdentifier").getter(GetCollaborationAnalysisTemplateRequest.getter(GetCollaborationAnalysisTemplateRequest::collaborationIdentifier)).setter(GetCollaborationAnalysisTemplateRequest.setter(Builder::collaborationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("collaborationIdentifier").build()}).build();
    private static final SdkField<String> ANALYSIS_TEMPLATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisTemplateArn").getter(GetCollaborationAnalysisTemplateRequest.getter(GetCollaborationAnalysisTemplateRequest::analysisTemplateArn)).setter(GetCollaborationAnalysisTemplateRequest.setter(Builder::analysisTemplateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("analysisTemplateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLABORATION_IDENTIFIER_FIELD, ANALYSIS_TEMPLATE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCollaborationAnalysisTemplateRequest.memberNameToFieldInitializer();
    private final String collaborationIdentifier;
    private final String analysisTemplateArn;

    private GetCollaborationAnalysisTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.collaborationIdentifier = builder.collaborationIdentifier;
        this.analysisTemplateArn = builder.analysisTemplateArn;
    }

    public final String collaborationIdentifier() {
        return this.collaborationIdentifier;
    }

    public final String analysisTemplateArn() {
        return this.analysisTemplateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.collaborationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTemplateArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCollaborationAnalysisTemplateRequest)) {
            return false;
        }
        GetCollaborationAnalysisTemplateRequest other = (GetCollaborationAnalysisTemplateRequest)((Object)obj);
        return Objects.equals(this.collaborationIdentifier(), other.collaborationIdentifier()) && Objects.equals(this.analysisTemplateArn(), other.analysisTemplateArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetCollaborationAnalysisTemplateRequest").add("CollaborationIdentifier", (Object)this.collaborationIdentifier()).add("AnalysisTemplateArn", (Object)this.analysisTemplateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "collaborationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.collaborationIdentifier()));
            }
            case "analysisTemplateArn": {
                return Optional.ofNullable(clazz.cast(this.analysisTemplateArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("collaborationIdentifier", COLLABORATION_IDENTIFIER_FIELD);
        map.put("analysisTemplateArn", ANALYSIS_TEMPLATE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCollaborationAnalysisTemplateRequest, T> g) {
        return obj -> g.apply((GetCollaborationAnalysisTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String collaborationIdentifier;
        private String analysisTemplateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCollaborationAnalysisTemplateRequest model) {
            super(model);
            this.collaborationIdentifier(model.collaborationIdentifier);
            this.analysisTemplateArn(model.analysisTemplateArn);
        }

        public final String getCollaborationIdentifier() {
            return this.collaborationIdentifier;
        }

        public final void setCollaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
        }

        @Override
        public final Builder collaborationIdentifier(String collaborationIdentifier) {
            this.collaborationIdentifier = collaborationIdentifier;
            return this;
        }

        public final String getAnalysisTemplateArn() {
            return this.analysisTemplateArn;
        }

        public final void setAnalysisTemplateArn(String analysisTemplateArn) {
            this.analysisTemplateArn = analysisTemplateArn;
        }

        @Override
        public final Builder analysisTemplateArn(String analysisTemplateArn) {
            this.analysisTemplateArn = analysisTemplateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCollaborationAnalysisTemplateRequest build() {
            return new GetCollaborationAnalysisTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCollaborationAnalysisTemplateRequest> {
        public Builder collaborationIdentifier(String var1);

        public Builder analysisTemplateArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

