/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.MLMemberAbilities;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbilitiesCopier;
import software.amazon.awssdk.services.cleanrooms.model.MemberAbility;
import software.amazon.awssdk.services.cleanrooms.model.MemberStatus;
import software.amazon.awssdk.services.cleanrooms.model.PaymentConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MemberSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MemberSummary> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(MemberSummary.getter(MemberSummary::accountId)).setter(MemberSummary.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(MemberSummary.getter(MemberSummary::statusAsString)).setter(MemberSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(MemberSummary.getter(MemberSummary::displayName)).setter(MemberSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<String>> ABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("abilities").getter(MemberSummary.getter(MemberSummary::abilitiesAsStrings)).setter(MemberSummary.setter(Builder::abilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MLMemberAbilities> ML_ABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mlAbilities").getter(MemberSummary.getter(MemberSummary::mlAbilities)).setter(MemberSummary.setter(Builder::mlAbilities)).constructor(MLMemberAbilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mlAbilities").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(MemberSummary.getter(MemberSummary::createTime)).setter(MemberSummary.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(MemberSummary.getter(MemberSummary::updateTime)).setter(MemberSummary.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(MemberSummary.getter(MemberSummary::membershipId)).setter(MemberSummary.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(MemberSummary.getter(MemberSummary::membershipArn)).setter(MemberSummary.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<PaymentConfiguration> PAYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("paymentConfiguration").getter(MemberSummary.getter(MemberSummary::paymentConfiguration)).setter(MemberSummary.setter(Builder::paymentConfiguration)).constructor(PaymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, STATUS_FIELD, DISPLAY_NAME_FIELD, ABILITIES_FIELD, ML_ABILITIES_FIELD, CREATE_TIME_FIELD, UPDATE_TIME_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, PAYMENT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MemberSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String status;
    private final String displayName;
    private final List<String> abilities;
    private final MLMemberAbilities mlAbilities;
    private final Instant createTime;
    private final Instant updateTime;
    private final String membershipId;
    private final String membershipArn;
    private final PaymentConfiguration paymentConfiguration;

    private MemberSummary(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.status = builder.status;
        this.displayName = builder.displayName;
        this.abilities = builder.abilities;
        this.mlAbilities = builder.mlAbilities;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.paymentConfiguration = builder.paymentConfiguration;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final MemberStatus status() {
        return MemberStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final List<MemberAbility> abilities() {
        return MemberAbilitiesCopier.copyStringToEnum(this.abilities);
    }

    public final boolean hasAbilities() {
        return this.abilities != null && !(this.abilities instanceof SdkAutoConstructList);
    }

    public final List<String> abilitiesAsStrings() {
        return this.abilities;
    }

    public final MLMemberAbilities mlAbilities() {
        return this.mlAbilities;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final PaymentConfiguration paymentConfiguration() {
        return this.paymentConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAbilities() ? this.abilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mlAbilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSummary)) {
            return false;
        }
        MemberSummary other = (MemberSummary)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.displayName(), other.displayName()) && this.hasAbilities() == other.hasAbilities() && Objects.equals(this.abilitiesAsStrings(), other.abilitiesAsStrings()) && Objects.equals(this.mlAbilities(), other.mlAbilities()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.paymentConfiguration(), other.paymentConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MemberSummary").add("AccountId", (Object)this.accountId()).add("Status", (Object)this.statusAsString()).add("DisplayName", (Object)this.displayName()).add("Abilities", this.hasAbilities() ? this.abilitiesAsStrings() : null).add("MlAbilities", (Object)this.mlAbilities()).add("CreateTime", (Object)this.createTime()).add("UpdateTime", (Object)this.updateTime()).add("MembershipId", (Object)this.membershipId()).add("MembershipArn", (Object)this.membershipArn()).add("PaymentConfiguration", (Object)this.paymentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "abilities": {
                return Optional.ofNullable(clazz.cast(this.abilitiesAsStrings()));
            }
            case "mlAbilities": {
                return Optional.ofNullable(clazz.cast(this.mlAbilities()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "paymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.paymentConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("abilities", ABILITIES_FIELD);
        map.put("mlAbilities", ML_ABILITIES_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipArn", MEMBERSHIP_ARN_FIELD);
        map.put("paymentConfiguration", PAYMENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MemberSummary, T> g) {
        return obj -> g.apply((MemberSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String status;
        private String displayName;
        private List<String> abilities = DefaultSdkAutoConstructList.getInstance();
        private MLMemberAbilities mlAbilities;
        private Instant createTime;
        private Instant updateTime;
        private String membershipId;
        private String membershipArn;
        private PaymentConfiguration paymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberSummary model) {
            this.accountId(model.accountId);
            this.status(model.status);
            this.displayName(model.displayName);
            this.abilitiesWithStrings(model.abilities);
            this.mlAbilities(model.mlAbilities);
            this.createTime(model.createTime);
            this.updateTime(model.updateTime);
            this.membershipId(model.membershipId);
            this.membershipArn(model.membershipArn);
            this.paymentConfiguration(model.paymentConfiguration);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getAbilities() {
            if (this.abilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.abilities;
        }

        public final void setAbilities(Collection<String> abilities) {
            this.abilities = MemberAbilitiesCopier.copy(abilities);
        }

        @Override
        public final Builder abilitiesWithStrings(Collection<String> abilities) {
            this.abilities = MemberAbilitiesCopier.copy(abilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder abilitiesWithStrings(String ... abilities) {
            this.abilitiesWithStrings(Arrays.asList(abilities));
            return this;
        }

        @Override
        public final Builder abilities(Collection<MemberAbility> abilities) {
            this.abilities = MemberAbilitiesCopier.copyEnumToString(abilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder abilities(MemberAbility ... abilities) {
            this.abilities(Arrays.asList(abilities));
            return this;
        }

        public final MLMemberAbilities.Builder getMlAbilities() {
            return this.mlAbilities != null ? this.mlAbilities.toBuilder() : null;
        }

        public final void setMlAbilities(MLMemberAbilities.BuilderImpl mlAbilities) {
            this.mlAbilities = mlAbilities != null ? mlAbilities.build() : null;
        }

        @Override
        public final Builder mlAbilities(MLMemberAbilities mlAbilities) {
            this.mlAbilities = mlAbilities;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final PaymentConfiguration.Builder getPaymentConfiguration() {
            return this.paymentConfiguration != null ? this.paymentConfiguration.toBuilder() : null;
        }

        public final void setPaymentConfiguration(PaymentConfiguration.BuilderImpl paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration != null ? paymentConfiguration.build() : null;
        }

        @Override
        public final Builder paymentConfiguration(PaymentConfiguration paymentConfiguration) {
            this.paymentConfiguration = paymentConfiguration;
            return this;
        }

        public MemberSummary build() {
            return new MemberSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MemberSummary> {
        public Builder accountId(String var1);

        public Builder status(String var1);

        public Builder status(MemberStatus var1);

        public Builder displayName(String var1);

        public Builder abilitiesWithStrings(Collection<String> var1);

        public Builder abilitiesWithStrings(String ... var1);

        public Builder abilities(Collection<MemberAbility> var1);

        public Builder abilities(MemberAbility ... var1);

        public Builder mlAbilities(MLMemberAbilities var1);

        default public Builder mlAbilities(Consumer<MLMemberAbilities.Builder> mlAbilities) {
            return this.mlAbilities((MLMemberAbilities)((MLMemberAbilities.Builder)MLMemberAbilities.builder().applyMutation(mlAbilities)).build());
        }

        public Builder createTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder membershipId(String var1);

        public Builder membershipArn(String var1);

        public Builder paymentConfiguration(PaymentConfiguration var1);

        default public Builder paymentConfiguration(Consumer<PaymentConfiguration.Builder> paymentConfiguration) {
            return this.paymentConfiguration((PaymentConfiguration)((PaymentConfiguration.Builder)PaymentConfiguration.builder().applyMutation(paymentConfiguration)).build());
        }
    }
}

