/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.ComputeConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyParameters;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryError;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryResult;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryResultConfiguration;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQuerySQLParameters;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryStatistics;
import software.amazon.awssdk.services.cleanrooms.model.ProtectedQueryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProtectedQuery
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProtectedQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ProtectedQuery.getter(ProtectedQuery::id)).setter(ProtectedQuery.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(ProtectedQuery.getter(ProtectedQuery::membershipId)).setter(ProtectedQuery.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipArn").getter(ProtectedQuery.getter(ProtectedQuery::membershipArn)).setter(ProtectedQuery.setter(Builder::membershipArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(ProtectedQuery.getter(ProtectedQuery::createTime)).setter(ProtectedQuery.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<ProtectedQuerySQLParameters> SQL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqlParameters").getter(ProtectedQuery.getter(ProtectedQuery::sqlParameters)).setter(ProtectedQuery.setter(Builder::sqlParameters)).constructor(ProtectedQuerySQLParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlParameters").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ProtectedQuery.getter(ProtectedQuery::statusAsString)).setter(ProtectedQuery.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<ProtectedQueryResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resultConfiguration").getter(ProtectedQuery.getter(ProtectedQuery::resultConfiguration)).setter(ProtectedQuery.setter(Builder::resultConfiguration)).constructor(ProtectedQueryResultConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build()}).build();
    private static final SdkField<ProtectedQueryStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(ProtectedQuery.getter(ProtectedQuery::statistics)).setter(ProtectedQuery.setter(Builder::statistics)).constructor(ProtectedQueryStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final SdkField<ProtectedQueryResult> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("result").getter(ProtectedQuery.getter(ProtectedQuery::result)).setter(ProtectedQuery.setter(Builder::result)).constructor(ProtectedQueryResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final SdkField<ProtectedQueryError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(ProtectedQuery.getter(ProtectedQuery::error)).setter(ProtectedQuery.setter(Builder::error)).constructor(ProtectedQueryError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<DifferentialPrivacyParameters> DIFFERENTIAL_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("differentialPrivacy").getter(ProtectedQuery.getter(ProtectedQuery::differentialPrivacy)).setter(ProtectedQuery.setter(Builder::differentialPrivacy)).constructor(DifferentialPrivacyParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("differentialPrivacy").build()}).build();
    private static final SdkField<ComputeConfiguration> COMPUTE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computeConfiguration").getter(ProtectedQuery.getter(ProtectedQuery::computeConfiguration)).setter(ProtectedQuery.setter(Builder::computeConfiguration)).constructor(ComputeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEMBERSHIP_ID_FIELD, MEMBERSHIP_ARN_FIELD, CREATE_TIME_FIELD, SQL_PARAMETERS_FIELD, STATUS_FIELD, RESULT_CONFIGURATION_FIELD, STATISTICS_FIELD, RESULT_FIELD, ERROR_FIELD, DIFFERENTIAL_PRIVACY_FIELD, COMPUTE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String membershipId;
    private final String membershipArn;
    private final Instant createTime;
    private final ProtectedQuerySQLParameters sqlParameters;
    private final String status;
    private final ProtectedQueryResultConfiguration resultConfiguration;
    private final ProtectedQueryStatistics statistics;
    private final ProtectedQueryResult result;
    private final ProtectedQueryError error;
    private final DifferentialPrivacyParameters differentialPrivacy;
    private final ComputeConfiguration computeConfiguration;

    private ProtectedQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.createTime = builder.createTime;
        this.sqlParameters = builder.sqlParameters;
        this.status = builder.status;
        this.resultConfiguration = builder.resultConfiguration;
        this.statistics = builder.statistics;
        this.result = builder.result;
        this.error = builder.error;
        this.differentialPrivacy = builder.differentialPrivacy;
        this.computeConfiguration = builder.computeConfiguration;
    }

    public final String id() {
        return this.id;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipArn() {
        return this.membershipArn;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final ProtectedQuerySQLParameters sqlParameters() {
        return this.sqlParameters;
    }

    public final ProtectedQueryStatus status() {
        return ProtectedQueryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ProtectedQueryResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    public final ProtectedQueryStatistics statistics() {
        return this.statistics;
    }

    public final ProtectedQueryResult result() {
        return this.result;
    }

    public final ProtectedQueryError error() {
        return this.error;
    }

    public final DifferentialPrivacyParameters differentialPrivacy() {
        return this.differentialPrivacy;
    }

    public final ComputeConfiguration computeConfiguration() {
        return this.computeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.differentialPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQuery)) {
            return false;
        }
        ProtectedQuery other = (ProtectedQuery)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipArn(), other.membershipArn()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.sqlParameters(), other.sqlParameters()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration()) && Objects.equals(this.statistics(), other.statistics()) && Objects.equals(this.result(), other.result()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.differentialPrivacy(), other.differentialPrivacy()) && Objects.equals(this.computeConfiguration(), other.computeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"ProtectedQuery").add("Id", (Object)this.id()).add("MembershipId", (Object)this.membershipId()).add("MembershipArn", (Object)this.membershipArn()).add("CreateTime", (Object)this.createTime()).add("SqlParameters", (Object)(this.sqlParameters() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("ResultConfiguration", (Object)this.resultConfiguration()).add("Statistics", (Object)this.statistics()).add("Result", (Object)this.result()).add("Error", (Object)this.error()).add("DifferentialPrivacy", (Object)this.differentialPrivacy()).add("ComputeConfiguration", (Object)this.computeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipArn": {
                return Optional.ofNullable(clazz.cast(this.membershipArn()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "sqlParameters": {
                return Optional.ofNullable(clazz.cast(this.sqlParameters()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "resultConfiguration": {
                return Optional.ofNullable(clazz.cast(this.resultConfiguration()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "differentialPrivacy": {
                return Optional.ofNullable(clazz.cast(this.differentialPrivacy()));
            }
            case "computeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQuery, T> g) {
        return obj -> g.apply((ProtectedQuery)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String membershipId;
        private String membershipArn;
        private Instant createTime;
        private ProtectedQuerySQLParameters sqlParameters;
        private String status;
        private ProtectedQueryResultConfiguration resultConfiguration;
        private ProtectedQueryStatistics statistics;
        private ProtectedQueryResult result;
        private ProtectedQueryError error;
        private DifferentialPrivacyParameters differentialPrivacy;
        private ComputeConfiguration computeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQuery model) {
            this.id(model.id);
            this.membershipId(model.membershipId);
            this.membershipArn(model.membershipArn);
            this.createTime(model.createTime);
            this.sqlParameters(model.sqlParameters);
            this.status(model.status);
            this.resultConfiguration(model.resultConfiguration);
            this.statistics(model.statistics);
            this.result(model.result);
            this.error(model.error);
            this.differentialPrivacy(model.differentialPrivacy);
            this.computeConfiguration(model.computeConfiguration);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return this.membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final ProtectedQuerySQLParameters.Builder getSqlParameters() {
            return this.sqlParameters != null ? this.sqlParameters.toBuilder() : null;
        }

        public final void setSqlParameters(ProtectedQuerySQLParameters.BuilderImpl sqlParameters) {
            this.sqlParameters = sqlParameters != null ? sqlParameters.build() : null;
        }

        @Override
        public final Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters) {
            this.sqlParameters = sqlParameters;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProtectedQueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ProtectedQueryResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedQueryResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedQueryResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ProtectedQueryStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        public final void setStatistics(ProtectedQueryStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ProtectedQueryStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final ProtectedQueryResult.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        public final void setResult(ProtectedQueryResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(ProtectedQueryResult result) {
            this.result = result;
            return this;
        }

        public final ProtectedQueryError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(ProtectedQueryError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProtectedQueryError error) {
            this.error = error;
            return this;
        }

        public final DifferentialPrivacyParameters.Builder getDifferentialPrivacy() {
            return this.differentialPrivacy != null ? this.differentialPrivacy.toBuilder() : null;
        }

        public final void setDifferentialPrivacy(DifferentialPrivacyParameters.BuilderImpl differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy != null ? differentialPrivacy.build() : null;
        }

        @Override
        public final Builder differentialPrivacy(DifferentialPrivacyParameters differentialPrivacy) {
            this.differentialPrivacy = differentialPrivacy;
            return this;
        }

        public final ComputeConfiguration.Builder getComputeConfiguration() {
            return this.computeConfiguration != null ? this.computeConfiguration.toBuilder() : null;
        }

        public final void setComputeConfiguration(ComputeConfiguration.BuilderImpl computeConfiguration) {
            this.computeConfiguration = computeConfiguration != null ? computeConfiguration.build() : null;
        }

        @Override
        public final Builder computeConfiguration(ComputeConfiguration computeConfiguration) {
            this.computeConfiguration = computeConfiguration;
            return this;
        }

        public ProtectedQuery build() {
            return new ProtectedQuery(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProtectedQuery> {
        public Builder id(String var1);

        public Builder membershipId(String var1);

        public Builder membershipArn(String var1);

        public Builder createTime(Instant var1);

        public Builder sqlParameters(ProtectedQuerySQLParameters var1);

        default public Builder sqlParameters(Consumer<ProtectedQuerySQLParameters.Builder> sqlParameters) {
            return this.sqlParameters((ProtectedQuerySQLParameters)((ProtectedQuerySQLParameters.Builder)ProtectedQuerySQLParameters.builder().applyMutation(sqlParameters)).build());
        }

        public Builder status(String var1);

        public Builder status(ProtectedQueryStatus var1);

        public Builder resultConfiguration(ProtectedQueryResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ProtectedQueryResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ProtectedQueryResultConfiguration)((ProtectedQueryResultConfiguration.Builder)ProtectedQueryResultConfiguration.builder().applyMutation(resultConfiguration)).build());
        }

        public Builder statistics(ProtectedQueryStatistics var1);

        default public Builder statistics(Consumer<ProtectedQueryStatistics.Builder> statistics) {
            return this.statistics((ProtectedQueryStatistics)((ProtectedQueryStatistics.Builder)ProtectedQueryStatistics.builder().applyMutation(statistics)).build());
        }

        public Builder result(ProtectedQueryResult var1);

        default public Builder result(Consumer<ProtectedQueryResult.Builder> result) {
            return this.result((ProtectedQueryResult)((ProtectedQueryResult.Builder)ProtectedQueryResult.builder().applyMutation(result)).build());
        }

        public Builder error(ProtectedQueryError var1);

        default public Builder error(Consumer<ProtectedQueryError.Builder> error) {
            return this.error((ProtectedQueryError)((ProtectedQueryError.Builder)ProtectedQueryError.builder().applyMutation(error)).build());
        }

        public Builder differentialPrivacy(DifferentialPrivacyParameters var1);

        default public Builder differentialPrivacy(Consumer<DifferentialPrivacyParameters.Builder> differentialPrivacy) {
            return this.differentialPrivacy((DifferentialPrivacyParameters)((DifferentialPrivacyParameters.Builder)DifferentialPrivacyParameters.builder().applyMutation(differentialPrivacy)).build());
        }

        public Builder computeConfiguration(ComputeConfiguration var1);

        default public Builder computeConfiguration(Consumer<ComputeConfiguration.Builder> computeConfiguration) {
            return this.computeConfiguration((ComputeConfiguration)((ComputeConfiguration.Builder)ComputeConfiguration.builder().applyMutation(computeConfiguration)).build());
        }
    }
}

