/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParameterType {
    SMALLINT("SMALLINT"),
    INTEGER("INTEGER"),
    BIGINT("BIGINT"),
    DECIMAL("DECIMAL"),
    REAL("REAL"),
    DOUBLE_PRECISION("DOUBLE_PRECISION"),
    BOOLEAN("BOOLEAN"),
    CHAR("CHAR"),
    VARCHAR("VARCHAR"),
    DATE("DATE"),
    TIMESTAMP("TIMESTAMP"),
    TIMESTAMPTZ("TIMESTAMPTZ"),
    TIME("TIME"),
    TIMETZ("TIMETZ"),
    VARBYTE("VARBYTE"),
    BINARY("BINARY"),
    BYTE("BYTE"),
    CHARACTER("CHARACTER"),
    DOUBLE("DOUBLE"),
    FLOAT("FLOAT"),
    INT("INT"),
    LONG("LONG"),
    NUMERIC("NUMERIC"),
    SHORT("SHORT"),
    STRING("STRING"),
    TIMESTAMP_LTZ("TIMESTAMP_LTZ"),
    TIMESTAMP_NTZ("TIMESTAMP_NTZ"),
    TINYINT("TINYINT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParameterType> VALUE_MAP;
    private final String value;

    private ParameterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParameterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParameterType> knownValues() {
        EnumSet<ParameterType> knownValues = EnumSet.allOf(ParameterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParameterType.class, ParameterType::toString);
    }
}

