/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaError;
import software.amazon.awssdk.services.cleanrooms.model.BatchGetSchemaErrorListCopier;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsResponse;
import software.amazon.awssdk.services.cleanrooms.model.Schema;
import software.amazon.awssdk.services.cleanrooms.model.SchemaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetSchemaResponse
extends CleanRoomsResponse
implements ToCopyableBuilder<Builder, BatchGetSchemaResponse> {
    private static final SdkField<List<Schema>> SCHEMAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("schemas").getter(BatchGetSchemaResponse.getter(BatchGetSchemaResponse::schemas)).setter(BatchGetSchemaResponse.setter(Builder::schemas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Schema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetSchemaError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetSchemaResponse.getter(BatchGetSchemaResponse::errors)).setter(BatchGetSchemaResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetSchemaError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMAS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("schemas", SCHEMAS_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<Schema> schemas;
    private final List<BatchGetSchemaError> errors;

    private BatchGetSchemaResponse(BuilderImpl builder) {
        super(builder);
        this.schemas = builder.schemas;
        this.errors = builder.errors;
    }

    public final boolean hasSchemas() {
        return this.schemas != null && !(this.schemas instanceof SdkAutoConstructList);
    }

    public final List<Schema> schemas() {
        return this.schemas;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetSchemaError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemas() ? this.schemas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSchemaResponse)) {
            return false;
        }
        BatchGetSchemaResponse other = (BatchGetSchemaResponse)((Object)obj);
        return this.hasSchemas() == other.hasSchemas() && Objects.equals(this.schemas(), other.schemas()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetSchemaResponse").add("Schemas", this.hasSchemas() ? this.schemas() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "schemas": {
                return Optional.ofNullable(clazz.cast(this.schemas()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSchemaResponse, T> g) {
        return obj -> g.apply((BatchGetSchemaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsResponse.BuilderImpl
    implements Builder {
        private List<Schema> schemas = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetSchemaError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSchemaResponse model) {
            super(model);
            this.schemas(model.schemas);
            this.errors(model.errors);
        }

        public final List<Schema.Builder> getSchemas() {
            List<Schema.Builder> result = SchemaListCopier.copyToBuilder(this.schemas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemas(Collection<Schema.BuilderImpl> schemas) {
            this.schemas = SchemaListCopier.copyFromBuilder(schemas);
        }

        @Override
        public final Builder schemas(Collection<Schema> schemas) {
            this.schemas = SchemaListCopier.copy(schemas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Schema ... schemas) {
            this.schemas(Arrays.asList(schemas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemas(Consumer<Schema.Builder> ... schemas) {
            this.schemas(Stream.of(schemas).map(c -> (Schema)((Schema.Builder)Schema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetSchemaError.Builder> getErrors() {
            List<BatchGetSchemaError.Builder> result = BatchGetSchemaErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetSchemaError.BuilderImpl> errors) {
            this.errors = BatchGetSchemaErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetSchemaError> errors) {
            this.errors = BatchGetSchemaErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetSchemaError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetSchemaError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetSchemaError)((BatchGetSchemaError.Builder)BatchGetSchemaError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetSchemaResponse build() {
            return new BatchGetSchemaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CleanRoomsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetSchemaResponse> {
        public Builder schemas(Collection<Schema> var1);

        public Builder schemas(Schema ... var1);

        public Builder schemas(Consumer<Schema.Builder> ... var1);

        public Builder errors(Collection<BatchGetSchemaError> var1);

        public Builder errors(BatchGetSchemaError ... var1);

        public Builder errors(Consumer<BatchGetSchemaError.Builder> ... var1);
    }
}

