/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.CleanRoomsRequest;
import software.amazon.awssdk.services.cleanrooms.model.IdMappingTableInputReferenceConfig;
import software.amazon.awssdk.services.cleanrooms.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIdMappingTableRequest
extends CleanRoomsRequest
implements ToCopyableBuilder<Builder, CreateIdMappingTableRequest> {
    private static final SdkField<String> MEMBERSHIP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipIdentifier").getter(CreateIdMappingTableRequest.getter(CreateIdMappingTableRequest::membershipIdentifier)).setter(CreateIdMappingTableRequest.setter(Builder::membershipIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateIdMappingTableRequest.getter(CreateIdMappingTableRequest::name)).setter(CreateIdMappingTableRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateIdMappingTableRequest.getter(CreateIdMappingTableRequest::description)).setter(CreateIdMappingTableRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<IdMappingTableInputReferenceConfig> INPUT_REFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inputReferenceConfig").getter(CreateIdMappingTableRequest.getter(CreateIdMappingTableRequest::inputReferenceConfig)).setter(CreateIdMappingTableRequest.setter(Builder::inputReferenceConfig)).constructor(IdMappingTableInputReferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputReferenceConfig").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateIdMappingTableRequest.getter(CreateIdMappingTableRequest::tags)).setter(CreateIdMappingTableRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateIdMappingTableRequest.getter(CreateIdMappingTableRequest::kmsKeyArn)).setter(CreateIdMappingTableRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_IDENTIFIER_FIELD, NAME_FIELD, DESCRIPTION_FIELD, INPUT_REFERENCE_CONFIG_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));
    private final String membershipIdentifier;
    private final String name;
    private final String description;
    private final IdMappingTableInputReferenceConfig inputReferenceConfig;
    private final Map<String, String> tags;
    private final String kmsKeyArn;

    private CreateIdMappingTableRequest(BuilderImpl builder) {
        super(builder);
        this.membershipIdentifier = builder.membershipIdentifier;
        this.name = builder.name;
        this.description = builder.description;
        this.inputReferenceConfig = builder.inputReferenceConfig;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String membershipIdentifier() {
        return this.membershipIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final IdMappingTableInputReferenceConfig inputReferenceConfig() {
        return this.inputReferenceConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputReferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdMappingTableRequest)) {
            return false;
        }
        CreateIdMappingTableRequest other = (CreateIdMappingTableRequest)((Object)obj);
        return Objects.equals(this.membershipIdentifier(), other.membershipIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.inputReferenceConfig(), other.inputReferenceConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIdMappingTableRequest").add("MembershipIdentifier", (Object)this.membershipIdentifier()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("InputReferenceConfig", (Object)this.inputReferenceConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipIdentifier": {
                return Optional.ofNullable(clazz.cast(this.membershipIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "inputReferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inputReferenceConfig()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIdMappingTableRequest, T> g) {
        return obj -> g.apply((CreateIdMappingTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CleanRoomsRequest.BuilderImpl
    implements Builder {
        private String membershipIdentifier;
        private String name;
        private String description;
        private IdMappingTableInputReferenceConfig inputReferenceConfig;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdMappingTableRequest model) {
            super(model);
            this.membershipIdentifier(model.membershipIdentifier);
            this.name(model.name);
            this.description(model.description);
            this.inputReferenceConfig(model.inputReferenceConfig);
            this.tags(model.tags);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getMembershipIdentifier() {
            return this.membershipIdentifier;
        }

        public final void setMembershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
        }

        @Override
        public final Builder membershipIdentifier(String membershipIdentifier) {
            this.membershipIdentifier = membershipIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final IdMappingTableInputReferenceConfig.Builder getInputReferenceConfig() {
            return this.inputReferenceConfig != null ? this.inputReferenceConfig.toBuilder() : null;
        }

        public final void setInputReferenceConfig(IdMappingTableInputReferenceConfig.BuilderImpl inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig != null ? inputReferenceConfig.build() : null;
        }

        @Override
        public final Builder inputReferenceConfig(IdMappingTableInputReferenceConfig inputReferenceConfig) {
            this.inputReferenceConfig = inputReferenceConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdMappingTableRequest build() {
            return new CreateIdMappingTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CleanRoomsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIdMappingTableRequest> {
        public Builder membershipIdentifier(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder inputReferenceConfig(IdMappingTableInputReferenceConfig var1);

        default public Builder inputReferenceConfig(Consumer<IdMappingTableInputReferenceConfig.Builder> inputReferenceConfig) {
            return this.inputReferenceConfig((IdMappingTableInputReferenceConfig)((IdMappingTableInputReferenceConfig.Builder)IdMappingTableInputReferenceConfig.builder().applyMutation(inputReferenceConfig)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder kmsKeyArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

