/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cleanrooms.model.DifferentialPrivacyAggregationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DifferentialPrivacySensitivityParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DifferentialPrivacySensitivityParameters> {
    private static final SdkField<String> AGGREGATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationType").getter(DifferentialPrivacySensitivityParameters.getter(DifferentialPrivacySensitivityParameters::aggregationTypeAsString)).setter(DifferentialPrivacySensitivityParameters.setter(Builder::aggregationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationType").build()}).build();
    private static final SdkField<String> AGGREGATION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aggregationExpression").getter(DifferentialPrivacySensitivityParameters.getter(DifferentialPrivacySensitivityParameters::aggregationExpression)).setter(DifferentialPrivacySensitivityParameters.setter(Builder::aggregationExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregationExpression").build()}).build();
    private static final SdkField<Integer> USER_CONTRIBUTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("userContributionLimit").getter(DifferentialPrivacySensitivityParameters.getter(DifferentialPrivacySensitivityParameters::userContributionLimit)).setter(DifferentialPrivacySensitivityParameters.setter(Builder::userContributionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userContributionLimit").build()}).build();
    private static final SdkField<Float> MIN_COLUMN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("minColumnValue").getter(DifferentialPrivacySensitivityParameters.getter(DifferentialPrivacySensitivityParameters::minColumnValue)).setter(DifferentialPrivacySensitivityParameters.setter(Builder::minColumnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minColumnValue").build()}).build();
    private static final SdkField<Float> MAX_COLUMN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("maxColumnValue").getter(DifferentialPrivacySensitivityParameters.getter(DifferentialPrivacySensitivityParameters::maxColumnValue)).setter(DifferentialPrivacySensitivityParameters.setter(Builder::maxColumnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxColumnValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_TYPE_FIELD, AGGREGATION_EXPRESSION_FIELD, USER_CONTRIBUTION_LIMIT_FIELD, MIN_COLUMN_VALUE_FIELD, MAX_COLUMN_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String aggregationType;
    private final String aggregationExpression;
    private final Integer userContributionLimit;
    private final Float minColumnValue;
    private final Float maxColumnValue;

    private DifferentialPrivacySensitivityParameters(BuilderImpl builder) {
        this.aggregationType = builder.aggregationType;
        this.aggregationExpression = builder.aggregationExpression;
        this.userContributionLimit = builder.userContributionLimit;
        this.minColumnValue = builder.minColumnValue;
        this.maxColumnValue = builder.maxColumnValue;
    }

    public final DifferentialPrivacyAggregationType aggregationType() {
        return DifferentialPrivacyAggregationType.fromValue(this.aggregationType);
    }

    public final String aggregationTypeAsString() {
        return this.aggregationType;
    }

    public final String aggregationExpression() {
        return this.aggregationExpression;
    }

    public final Integer userContributionLimit() {
        return this.userContributionLimit;
    }

    public final Float minColumnValue() {
        return this.minColumnValue;
    }

    public final Float maxColumnValue() {
        return this.maxColumnValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.userContributionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.minColumnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxColumnValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DifferentialPrivacySensitivityParameters)) {
            return false;
        }
        DifferentialPrivacySensitivityParameters other = (DifferentialPrivacySensitivityParameters)obj;
        return Objects.equals(this.aggregationTypeAsString(), other.aggregationTypeAsString()) && Objects.equals(this.aggregationExpression(), other.aggregationExpression()) && Objects.equals(this.userContributionLimit(), other.userContributionLimit()) && Objects.equals(this.minColumnValue(), other.minColumnValue()) && Objects.equals(this.maxColumnValue(), other.maxColumnValue());
    }

    public final String toString() {
        return ToString.builder((String)"DifferentialPrivacySensitivityParameters").add("AggregationType", (Object)this.aggregationTypeAsString()).add("AggregationExpression", (Object)this.aggregationExpression()).add("UserContributionLimit", (Object)this.userContributionLimit()).add("MinColumnValue", (Object)this.minColumnValue()).add("MaxColumnValue", (Object)this.maxColumnValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregationType": {
                return Optional.ofNullable(clazz.cast(this.aggregationTypeAsString()));
            }
            case "aggregationExpression": {
                return Optional.ofNullable(clazz.cast(this.aggregationExpression()));
            }
            case "userContributionLimit": {
                return Optional.ofNullable(clazz.cast(this.userContributionLimit()));
            }
            case "minColumnValue": {
                return Optional.ofNullable(clazz.cast(this.minColumnValue()));
            }
            case "maxColumnValue": {
                return Optional.ofNullable(clazz.cast(this.maxColumnValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DifferentialPrivacySensitivityParameters, T> g) {
        return obj -> g.apply((DifferentialPrivacySensitivityParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String aggregationType;
        private String aggregationExpression;
        private Integer userContributionLimit;
        private Float minColumnValue;
        private Float maxColumnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DifferentialPrivacySensitivityParameters model) {
            this.aggregationType(model.aggregationType);
            this.aggregationExpression(model.aggregationExpression);
            this.userContributionLimit(model.userContributionLimit);
            this.minColumnValue(model.minColumnValue);
            this.maxColumnValue(model.maxColumnValue);
        }

        public final String getAggregationType() {
            return this.aggregationType;
        }

        public final void setAggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
        }

        @Override
        public final Builder aggregationType(String aggregationType) {
            this.aggregationType = aggregationType;
            return this;
        }

        @Override
        public final Builder aggregationType(DifferentialPrivacyAggregationType aggregationType) {
            this.aggregationType(aggregationType == null ? null : aggregationType.toString());
            return this;
        }

        public final String getAggregationExpression() {
            return this.aggregationExpression;
        }

        public final void setAggregationExpression(String aggregationExpression) {
            this.aggregationExpression = aggregationExpression;
        }

        @Override
        public final Builder aggregationExpression(String aggregationExpression) {
            this.aggregationExpression = aggregationExpression;
            return this;
        }

        public final Integer getUserContributionLimit() {
            return this.userContributionLimit;
        }

        public final void setUserContributionLimit(Integer userContributionLimit) {
            this.userContributionLimit = userContributionLimit;
        }

        @Override
        public final Builder userContributionLimit(Integer userContributionLimit) {
            this.userContributionLimit = userContributionLimit;
            return this;
        }

        public final Float getMinColumnValue() {
            return this.minColumnValue;
        }

        public final void setMinColumnValue(Float minColumnValue) {
            this.minColumnValue = minColumnValue;
        }

        @Override
        public final Builder minColumnValue(Float minColumnValue) {
            this.minColumnValue = minColumnValue;
            return this;
        }

        public final Float getMaxColumnValue() {
            return this.maxColumnValue;
        }

        public final void setMaxColumnValue(Float maxColumnValue) {
            this.maxColumnValue = maxColumnValue;
        }

        @Override
        public final Builder maxColumnValue(Float maxColumnValue) {
            this.maxColumnValue = maxColumnValue;
            return this;
        }

        public DifferentialPrivacySensitivityParameters build() {
            return new DifferentialPrivacySensitivityParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DifferentialPrivacySensitivityParameters> {
        public Builder aggregationType(String var1);

        public Builder aggregationType(DifferentialPrivacyAggregationType var1);

        public Builder aggregationExpression(String var1);

        public Builder userContributionLimit(Integer var1);

        public Builder minColumnValue(Float var1);

        public Builder maxColumnValue(Float var1);
    }
}

