/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaConfiguration {
    DIFFERENTIAL_PRIVACY("DIFFERENTIAL_PRIVACY"),
    CUSTOM_ANALYSIS_NOT_ALLOWED("CUSTOM_ANALYSIS_NOT_ALLOWED"),
    NO_MEMBER_ACCOUNT_ALLOWED_TO_PROVIDE_ANALYSIS("NO_MEMBER_ACCOUNT_ALLOWED_TO_PROVIDE_ANALYSIS"),
    DIFFERENTIAL_PRIVACY_BUDGET_NOT_CONFIGURED("DIFFERENTIAL_PRIVACY_BUDGET_NOT_CONFIGURED"),
    ID_MAPPING_TABLE_NOT_POPULATED("ID_MAPPING_TABLE_NOT_POPULATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaConfiguration> VALUE_MAP;
    private final String value;

    private SchemaConfiguration(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaConfiguration fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaConfiguration> knownValues() {
        EnumSet<SchemaConfiguration> knownValues = EnumSet.allOf(SchemaConfiguration.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaConfiguration.class, SchemaConfiguration::toString);
    }
}

