/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.internal.UserAgentUtils;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationAnalysisTemplateSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationAnalysisTemplatesResponse;

public class ListCollaborationAnalysisTemplatesPublisher
implements SdkPublisher<ListCollaborationAnalysisTemplatesResponse> {
    private final CleanRoomsAsyncClient client;
    private final ListCollaborationAnalysisTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCollaborationAnalysisTemplatesPublisher(CleanRoomsAsyncClient client, ListCollaborationAnalysisTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCollaborationAnalysisTemplatesPublisher(CleanRoomsAsyncClient client, ListCollaborationAnalysisTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCollaborationAnalysisTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCollaborationAnalysisTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollaborationAnalysisTemplateSummary> collaborationAnalysisTemplateSummaries() {
        Function<ListCollaborationAnalysisTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationAnalysisTemplateSummaries() != null) {
                return response.collaborationAnalysisTemplateSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCollaborationAnalysisTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCollaborationAnalysisTemplatesResponseFetcher
    implements AsyncPageFetcher<ListCollaborationAnalysisTemplatesResponse> {
        private ListCollaborationAnalysisTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationAnalysisTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCollaborationAnalysisTemplatesResponse> nextPage(ListCollaborationAnalysisTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationAnalysisTemplatesPublisher.this.client.listCollaborationAnalysisTemplates(ListCollaborationAnalysisTemplatesPublisher.this.firstRequest);
            }
            return ListCollaborationAnalysisTemplatesPublisher.this.client.listCollaborationAnalysisTemplates((ListCollaborationAnalysisTemplatesRequest)((Object)ListCollaborationAnalysisTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

