/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsAsyncClientBuilder;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsServiceClientConfiguration;
import software.amazon.awssdk.services.cleanrooms.DefaultCleanRoomsAsyncClient;
import software.amazon.awssdk.services.cleanrooms.DefaultCleanRoomsBaseClientBuilder;
import software.amazon.awssdk.services.cleanrooms.endpoints.CleanRoomsEndpointProvider;

@SdkInternalApi
final class DefaultCleanRoomsAsyncClientBuilder
extends DefaultCleanRoomsBaseClientBuilder<CleanRoomsAsyncClientBuilder, CleanRoomsAsyncClient>
implements CleanRoomsAsyncClientBuilder {
    DefaultCleanRoomsAsyncClientBuilder() {
    }

    @Override
    public DefaultCleanRoomsAsyncClientBuilder endpointProvider(CleanRoomsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CleanRoomsAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCleanRoomsAsyncClientBuilder.validateClientOptions(clientConfiguration);
        CleanRoomsServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultCleanRoomsAsyncClient client = new DefaultCleanRoomsAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private CleanRoomsServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return CleanRoomsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

