/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleColumnListCopier;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleListJoinColumnsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisRuleList
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisRuleList> {
    private static final SdkField<List<String>> JOIN_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("joinColumns").getter(AnalysisRuleList.getter(AnalysisRuleList::joinColumns)).setter(AnalysisRuleList.setter(Builder::joinColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("joinColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIST_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listColumns").getter(AnalysisRuleList.getter(AnalysisRuleList::listColumns)).setter(AnalysisRuleList.setter(Builder::listColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOIN_COLUMNS_FIELD, LIST_COLUMNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> joinColumns;
    private final List<String> listColumns;

    private AnalysisRuleList(BuilderImpl builder) {
        this.joinColumns = builder.joinColumns;
        this.listColumns = builder.listColumns;
    }

    public final boolean hasJoinColumns() {
        return this.joinColumns != null && !(this.joinColumns instanceof SdkAutoConstructList);
    }

    public final List<String> joinColumns() {
        return this.joinColumns;
    }

    public final boolean hasListColumns() {
        return this.listColumns != null && !(this.listColumns instanceof SdkAutoConstructList);
    }

    public final List<String> listColumns() {
        return this.listColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJoinColumns() ? this.joinColumns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListColumns() ? this.listColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleList)) {
            return false;
        }
        AnalysisRuleList other = (AnalysisRuleList)obj;
        return this.hasJoinColumns() == other.hasJoinColumns() && Objects.equals(this.joinColumns(), other.joinColumns()) && this.hasListColumns() == other.hasListColumns() && Objects.equals(this.listColumns(), other.listColumns());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisRuleList").add("JoinColumns", this.hasJoinColumns() ? this.joinColumns() : null).add("ListColumns", this.hasListColumns() ? this.listColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "joinColumns": {
                return Optional.ofNullable(clazz.cast(this.joinColumns()));
            }
            case "listColumns": {
                return Optional.ofNullable(clazz.cast(this.listColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRuleList, T> g) {
        return obj -> g.apply((AnalysisRuleList)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> joinColumns = DefaultSdkAutoConstructList.getInstance();
        private List<String> listColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRuleList model) {
            this.joinColumns(model.joinColumns);
            this.listColumns(model.listColumns);
        }

        public final Collection<String> getJoinColumns() {
            if (this.joinColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.joinColumns;
        }

        public final void setJoinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleListJoinColumnsListCopier.copy(joinColumns);
        }

        @Override
        public final Builder joinColumns(Collection<String> joinColumns) {
            this.joinColumns = AnalysisRuleListJoinColumnsListCopier.copy(joinColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder joinColumns(String ... joinColumns) {
            this.joinColumns(Arrays.asList(joinColumns));
            return this;
        }

        public final Collection<String> getListColumns() {
            if (this.listColumns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.listColumns;
        }

        public final void setListColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
        }

        @Override
        public final Builder listColumns(Collection<String> listColumns) {
            this.listColumns = AnalysisRuleColumnListCopier.copy(listColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listColumns(String ... listColumns) {
            this.listColumns(Arrays.asList(listColumns));
            return this;
        }

        public AnalysisRuleList build() {
            return new AnalysisRuleList(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisRuleList> {
        public Builder joinColumns(Collection<String> var1);

        public Builder joinColumns(String ... var1);

        public Builder listColumns(Collection<String> var1);

        public Builder listColumns(String ... var1);
    }
}

