/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleAggregation;
import software.amazon.awssdk.services.cleanrooms.model.AnalysisRuleList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisRulePolicyV1
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisRulePolicyV1> {
    private static final SdkField<AnalysisRuleList> LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("list").getter(AnalysisRulePolicyV1.getter(AnalysisRulePolicyV1::list)).setter(AnalysisRulePolicyV1.setter(Builder::list)).constructor(AnalysisRuleList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("list").build()}).build();
    private static final SdkField<AnalysisRuleAggregation> AGGREGATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregation").getter(AnalysisRulePolicyV1.getter(AnalysisRulePolicyV1::aggregation)).setter(AnalysisRulePolicyV1.setter(Builder::aggregation)).constructor(AnalysisRuleAggregation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIST_FIELD, AGGREGATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AnalysisRuleList list;
    private final AnalysisRuleAggregation aggregation;
    private final Type type;

    private AnalysisRulePolicyV1(BuilderImpl builder) {
        this.list = builder.list;
        this.aggregation = builder.aggregation;
        this.type = builder.type;
    }

    public final AnalysisRuleList list() {
        return this.list;
    }

    public final AnalysisRuleAggregation aggregation() {
        return this.aggregation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.list());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRulePolicyV1)) {
            return false;
        }
        AnalysisRulePolicyV1 other = (AnalysisRulePolicyV1)obj;
        return Objects.equals(this.list(), other.list()) && Objects.equals(this.aggregation(), other.aggregation());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisRulePolicyV1").add("List", (Object)this.list()).add("Aggregation", (Object)this.aggregation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "list": {
                return Optional.ofNullable(clazz.cast(this.list()));
            }
            case "aggregation": {
                return Optional.ofNullable(clazz.cast(this.aggregation()));
            }
        }
        return Optional.empty();
    }

    public static AnalysisRulePolicyV1 fromList(AnalysisRuleList list) {
        return (AnalysisRulePolicyV1)AnalysisRulePolicyV1.builder().list(list).build();
    }

    public static AnalysisRulePolicyV1 fromList(Consumer<AnalysisRuleList.Builder> list) {
        AnalysisRuleList.Builder builder = AnalysisRuleList.builder();
        list.accept(builder);
        return AnalysisRulePolicyV1.fromList((AnalysisRuleList)builder.build());
    }

    public static AnalysisRulePolicyV1 fromAggregation(AnalysisRuleAggregation aggregation) {
        return (AnalysisRulePolicyV1)AnalysisRulePolicyV1.builder().aggregation(aggregation).build();
    }

    public static AnalysisRulePolicyV1 fromAggregation(Consumer<AnalysisRuleAggregation.Builder> aggregation) {
        AnalysisRuleAggregation.Builder builder = AnalysisRuleAggregation.builder();
        aggregation.accept(builder);
        return AnalysisRulePolicyV1.fromAggregation((AnalysisRuleAggregation)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisRulePolicyV1, T> g) {
        return obj -> g.apply((AnalysisRulePolicyV1)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        LIST,
        AGGREGATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AnalysisRuleList list;
        private AnalysisRuleAggregation aggregation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisRulePolicyV1 model) {
            this.list(model.list);
            this.aggregation(model.aggregation);
        }

        public final AnalysisRuleList.Builder getList() {
            return this.list != null ? this.list.toBuilder() : null;
        }

        public final void setList(AnalysisRuleList.BuilderImpl list) {
            AnalysisRuleList oldValue = this.list;
            this.list = list != null ? list.build() : null;
            this.handleUnionValueChange(Type.LIST, oldValue, this.list);
        }

        @Override
        public final Builder list(AnalysisRuleList list) {
            AnalysisRuleList oldValue = this.list;
            this.list = list;
            this.handleUnionValueChange(Type.LIST, oldValue, this.list);
            return this;
        }

        public final AnalysisRuleAggregation.Builder getAggregation() {
            return this.aggregation != null ? this.aggregation.toBuilder() : null;
        }

        public final void setAggregation(AnalysisRuleAggregation.BuilderImpl aggregation) {
            AnalysisRuleAggregation oldValue = this.aggregation;
            this.aggregation = aggregation != null ? aggregation.build() : null;
            this.handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
        }

        @Override
        public final Builder aggregation(AnalysisRuleAggregation aggregation) {
            AnalysisRuleAggregation oldValue = this.aggregation;
            this.aggregation = aggregation;
            this.handleUnionValueChange(Type.AGGREGATION, oldValue, this.aggregation);
            return this;
        }

        public AnalysisRulePolicyV1 build() {
            return new AnalysisRulePolicyV1(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisRulePolicyV1> {
        public Builder list(AnalysisRuleList var1);

        default public Builder list(Consumer<AnalysisRuleList.Builder> list) {
            return this.list((AnalysisRuleList)((AnalysisRuleList.Builder)AnalysisRuleList.builder().applyMutation(list)).build());
        }

        public Builder aggregation(AnalysisRuleAggregation var1);

        default public Builder aggregation(Consumer<AnalysisRuleAggregation.Builder> aggregation) {
            return this.aggregation((AnalysisRuleAggregation)((AnalysisRuleAggregation.Builder)AnalysisRuleAggregation.builder().applyMutation(aggregation)).build());
        }
    }
}

