/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanrooms.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cleanrooms.CleanRoomsClient;
import software.amazon.awssdk.services.cleanrooms.model.CollaborationSummary;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsRequest;
import software.amazon.awssdk.services.cleanrooms.model.ListCollaborationsResponse;

public class ListCollaborationsIterable
implements SdkIterable<ListCollaborationsResponse> {
    private final CleanRoomsClient client;
    private final ListCollaborationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCollaborationsIterable(CleanRoomsClient client, ListCollaborationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListCollaborationsResponseFetcher();
    }

    public Iterator<ListCollaborationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollaborationSummary> collaborationList() {
        Function<ListCollaborationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.collaborationList() != null) {
                return response.collaborationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCollaborationsResponseFetcher
    implements SyncPageFetcher<ListCollaborationsResponse> {
        private ListCollaborationsResponseFetcher() {
        }

        public boolean hasNextPage(ListCollaborationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCollaborationsResponse nextPage(ListCollaborationsResponse previousPage) {
            if (previousPage == null) {
                return ListCollaborationsIterable.this.client.listCollaborations(ListCollaborationsIterable.this.firstRequest);
            }
            return ListCollaborationsIterable.this.client.listCollaborations((ListCollaborationsRequest)((Object)ListCollaborationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

