/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.PhoneNumberType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchAvailablePhoneNumbersRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, SearchAvailablePhoneNumbersRequest> {
    private static final SdkField<String> AREA_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AreaCode").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::areaCode)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::areaCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("area-code").build()}).build();
    private static final SdkField<String> CITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("City").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::city)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::city)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("city").build()}).build();
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::country)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("country").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::state)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()}).build();
    private static final SdkField<String> TOLL_FREE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TollFreePrefix").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::tollFreePrefix)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::tollFreePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("toll-free-prefix").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumberType").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::phoneNumberTypeAsString)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::phoneNumberType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("phone-number-type").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::maxResults)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchAvailablePhoneNumbersRequest.getter(SearchAvailablePhoneNumbersRequest::nextToken)).setter(SearchAvailablePhoneNumbersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_CODE_FIELD, CITY_FIELD, COUNTRY_FIELD, STATE_FIELD, TOLL_FREE_PREFIX_FIELD, PHONE_NUMBER_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchAvailablePhoneNumbersRequest.memberNameToFieldInitializer();
    private final String areaCode;
    private final String city;
    private final String country;
    private final String state;
    private final String tollFreePrefix;
    private final String phoneNumberType;
    private final Integer maxResults;
    private final String nextToken;

    private SearchAvailablePhoneNumbersRequest(BuilderImpl builder) {
        super(builder);
        this.areaCode = builder.areaCode;
        this.city = builder.city;
        this.country = builder.country;
        this.state = builder.state;
        this.tollFreePrefix = builder.tollFreePrefix;
        this.phoneNumberType = builder.phoneNumberType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String areaCode() {
        return this.areaCode;
    }

    public final String city() {
        return this.city;
    }

    public final String country() {
        return this.country;
    }

    public final String state() {
        return this.state;
    }

    public final String tollFreePrefix() {
        return this.tollFreePrefix;
    }

    public final PhoneNumberType phoneNumberType() {
        return PhoneNumberType.fromValue(this.phoneNumberType);
    }

    public final String phoneNumberTypeAsString() {
        return this.phoneNumberType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.areaCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.city());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.tollFreePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumberTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchAvailablePhoneNumbersRequest)) {
            return false;
        }
        SearchAvailablePhoneNumbersRequest other = (SearchAvailablePhoneNumbersRequest)((Object)obj);
        return Objects.equals(this.areaCode(), other.areaCode()) && Objects.equals(this.city(), other.city()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.tollFreePrefix(), other.tollFreePrefix()) && Objects.equals(this.phoneNumberTypeAsString(), other.phoneNumberTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchAvailablePhoneNumbersRequest").add("AreaCode", (Object)this.areaCode()).add("City", (Object)this.city()).add("Country", (Object)this.country()).add("State", (Object)this.state()).add("TollFreePrefix", (Object)this.tollFreePrefix()).add("PhoneNumberType", (Object)this.phoneNumberTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AreaCode": {
                return Optional.ofNullable(clazz.cast(this.areaCode()));
            }
            case "City": {
                return Optional.ofNullable(clazz.cast(this.city()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "TollFreePrefix": {
                return Optional.ofNullable(clazz.cast(this.tollFreePrefix()));
            }
            case "PhoneNumberType": {
                return Optional.ofNullable(clazz.cast(this.phoneNumberTypeAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("area-code", AREA_CODE_FIELD);
        map.put("city", CITY_FIELD);
        map.put("country", COUNTRY_FIELD);
        map.put("state", STATE_FIELD);
        map.put("toll-free-prefix", TOLL_FREE_PREFIX_FIELD);
        map.put("phone-number-type", PHONE_NUMBER_TYPE_FIELD);
        map.put("max-results", MAX_RESULTS_FIELD);
        map.put("next-token", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchAvailablePhoneNumbersRequest, T> g) {
        return obj -> g.apply((SearchAvailablePhoneNumbersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String areaCode;
        private String city;
        private String country;
        private String state;
        private String tollFreePrefix;
        private String phoneNumberType;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchAvailablePhoneNumbersRequest model) {
            super(model);
            this.areaCode(model.areaCode);
            this.city(model.city);
            this.country(model.country);
            this.state(model.state);
            this.tollFreePrefix(model.tollFreePrefix);
            this.phoneNumberType(model.phoneNumberType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAreaCode() {
            return this.areaCode;
        }

        public final void setAreaCode(String areaCode) {
            this.areaCode = areaCode;
        }

        @Override
        public final Builder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public final String getCity() {
            return this.city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getTollFreePrefix() {
            return this.tollFreePrefix;
        }

        public final void setTollFreePrefix(String tollFreePrefix) {
            this.tollFreePrefix = tollFreePrefix;
        }

        @Override
        public final Builder tollFreePrefix(String tollFreePrefix) {
            this.tollFreePrefix = tollFreePrefix;
            return this;
        }

        public final String getPhoneNumberType() {
            return this.phoneNumberType;
        }

        public final void setPhoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        @Override
        public final Builder phoneNumberType(String phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
            return this;
        }

        @Override
        public final Builder phoneNumberType(PhoneNumberType phoneNumberType) {
            this.phoneNumberType(phoneNumberType == null ? null : phoneNumberType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchAvailablePhoneNumbersRequest build() {
            return new SearchAvailablePhoneNumbersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchAvailablePhoneNumbersRequest> {
        public Builder areaCode(String var1);

        public Builder city(String var1);

        public Builder country(String var1);

        public Builder state(String var1);

        public Builder tollFreePrefix(String var1);

        public Builder phoneNumberType(String var1);

        public Builder phoneNumberType(PhoneNumberType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

