/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MediaInsightsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MediaInsightsConfiguration> {
    private static final SdkField<Boolean> DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Disabled").getter(MediaInsightsConfiguration.getter(MediaInsightsConfiguration::disabled)).setter(MediaInsightsConfiguration.setter(Builder::disabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disabled").build()}).build();
    private static final SdkField<String> CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationArn").getter(MediaInsightsConfiguration.getter(MediaInsightsConfiguration::configurationArn)).setter(MediaInsightsConfiguration.setter(Builder::configurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISABLED_FIELD, CONFIGURATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MediaInsightsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Boolean disabled;
    private final String configurationArn;

    private MediaInsightsConfiguration(BuilderImpl builder) {
        this.disabled = builder.disabled;
        this.configurationArn = builder.configurationArn;
    }

    public final Boolean disabled() {
        return this.disabled;
    }

    public final String configurationArn() {
        return this.configurationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.disabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaInsightsConfiguration)) {
            return false;
        }
        MediaInsightsConfiguration other = (MediaInsightsConfiguration)obj;
        return Objects.equals(this.disabled(), other.disabled()) && Objects.equals(this.configurationArn(), other.configurationArn());
    }

    public final String toString() {
        return ToString.builder((String)"MediaInsightsConfiguration").add("Disabled", (Object)this.disabled()).add("ConfigurationArn", (Object)(this.configurationArn() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Disabled": {
                return Optional.ofNullable(clazz.cast(this.disabled()));
            }
            case "ConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.configurationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Disabled", DISABLED_FIELD);
        map.put("ConfigurationArn", CONFIGURATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaInsightsConfiguration, T> g) {
        return obj -> g.apply((MediaInsightsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean disabled;
        private String configurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaInsightsConfiguration model) {
            this.disabled(model.disabled);
            this.configurationArn(model.configurationArn);
        }

        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(Boolean disabled) {
            this.disabled = disabled;
        }

        @Override
        public final Builder disabled(Boolean disabled) {
            this.disabled = disabled;
            return this;
        }

        public final String getConfigurationArn() {
            return this.configurationArn;
        }

        public final void setConfigurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
        }

        @Override
        public final Builder configurationArn(String configurationArn) {
            this.configurationArn = configurationArn;
            return this;
        }

        public MediaInsightsConfiguration build() {
            return new MediaInsightsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MediaInsightsConfiguration> {
        public Builder disabled(Boolean var1);

        public Builder configurationArn(String var1);
    }
}

