/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.SMAUpdateCallArgumentsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSipMediaApplicationCallRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, UpdateSipMediaApplicationCallRequest> {
    private static final SdkField<String> SIP_MEDIA_APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SipMediaApplicationId").getter(UpdateSipMediaApplicationCallRequest.getter(UpdateSipMediaApplicationCallRequest::sipMediaApplicationId)).setter(UpdateSipMediaApplicationCallRequest.setter(Builder::sipMediaApplicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sipMediaApplicationId").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(UpdateSipMediaApplicationCallRequest.getter(UpdateSipMediaApplicationCallRequest::transactionId)).setter(UpdateSipMediaApplicationCallRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("transactionId").build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Arguments").getter(UpdateSipMediaApplicationCallRequest.getter(UpdateSipMediaApplicationCallRequest::arguments)).setter(UpdateSipMediaApplicationCallRequest.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIP_MEDIA_APPLICATION_ID_FIELD, TRANSACTION_ID_FIELD, ARGUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sipMediaApplicationId", SIP_MEDIA_APPLICATION_ID_FIELD);
            this.put("transactionId", TRANSACTION_ID_FIELD);
            this.put("Arguments", ARGUMENTS_FIELD);
        }
    });
    private final String sipMediaApplicationId;
    private final String transactionId;
    private final Map<String, String> arguments;

    private UpdateSipMediaApplicationCallRequest(BuilderImpl builder) {
        super(builder);
        this.sipMediaApplicationId = builder.sipMediaApplicationId;
        this.transactionId = builder.transactionId;
        this.arguments = builder.arguments;
    }

    public final String sipMediaApplicationId() {
        return this.sipMediaApplicationId;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> arguments() {
        return this.arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sipMediaApplicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArguments() ? this.arguments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSipMediaApplicationCallRequest)) {
            return false;
        }
        UpdateSipMediaApplicationCallRequest other = (UpdateSipMediaApplicationCallRequest)((Object)obj);
        return Objects.equals(this.sipMediaApplicationId(), other.sipMediaApplicationId()) && Objects.equals(this.transactionId(), other.transactionId()) && this.hasArguments() == other.hasArguments() && Objects.equals(this.arguments(), other.arguments());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSipMediaApplicationCallRequest").add("SipMediaApplicationId", (Object)this.sipMediaApplicationId()).add("TransactionId", (Object)this.transactionId()).add("Arguments", (Object)(this.arguments() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SipMediaApplicationId": {
                return Optional.ofNullable(clazz.cast(this.sipMediaApplicationId()));
            }
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSipMediaApplicationCallRequest, T> g) {
        return obj -> g.apply((UpdateSipMediaApplicationCallRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String sipMediaApplicationId;
        private String transactionId;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSipMediaApplicationCallRequest model) {
            super(model);
            this.sipMediaApplicationId(model.sipMediaApplicationId);
            this.transactionId(model.transactionId);
            this.arguments(model.arguments);
        }

        public final String getSipMediaApplicationId() {
            return this.sipMediaApplicationId;
        }

        public final void setSipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
        }

        @Override
        public final Builder sipMediaApplicationId(String sipMediaApplicationId) {
            this.sipMediaApplicationId = sipMediaApplicationId;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Map<String, String> getArguments() {
            if (this.arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = SMAUpdateCallArgumentsMapCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = SMAUpdateCallArgumentsMapCopier.copy(arguments);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSipMediaApplicationCallRequest build() {
            return new UpdateSipMediaApplicationCallRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSipMediaApplicationCallRequest> {
        public Builder sipMediaApplicationId(String var1);

        public Builder transactionId(String var1);

        public Builder arguments(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

