/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.chimesdkvoice.model.CallLegType;
import software.amazon.awssdk.services.chimesdkvoice.model.ChimeSdkVoiceRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSpeakerSearchTaskRequest
extends ChimeSdkVoiceRequest
implements ToCopyableBuilder<Builder, StartSpeakerSearchTaskRequest> {
    private static final SdkField<String> VOICE_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceConnectorId").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::voiceConnectorId)).setter(StartSpeakerSearchTaskRequest.setter(Builder::voiceConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("VoiceConnectorId").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransactionId").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::transactionId)).setter(StartSpeakerSearchTaskRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()}).build();
    private static final SdkField<String> VOICE_PROFILE_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VoiceProfileDomainId").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::voiceProfileDomainId)).setter(StartSpeakerSearchTaskRequest.setter(Builder::voiceProfileDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoiceProfileDomainId").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::clientRequestToken)).setter(StartSpeakerSearchTaskRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<String> CALL_LEG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallLeg").getter(StartSpeakerSearchTaskRequest.getter(StartSpeakerSearchTaskRequest::callLegAsString)).setter(StartSpeakerSearchTaskRequest.setter(Builder::callLeg)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallLeg").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOICE_CONNECTOR_ID_FIELD, TRANSACTION_ID_FIELD, VOICE_PROFILE_DOMAIN_ID_FIELD, CLIENT_REQUEST_TOKEN_FIELD, CALL_LEG_FIELD));
    private final String voiceConnectorId;
    private final String transactionId;
    private final String voiceProfileDomainId;
    private final String clientRequestToken;
    private final String callLeg;

    private StartSpeakerSearchTaskRequest(BuilderImpl builder) {
        super(builder);
        this.voiceConnectorId = builder.voiceConnectorId;
        this.transactionId = builder.transactionId;
        this.voiceProfileDomainId = builder.voiceProfileDomainId;
        this.clientRequestToken = builder.clientRequestToken;
        this.callLeg = builder.callLeg;
    }

    public final String voiceConnectorId() {
        return this.voiceConnectorId;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final String voiceProfileDomainId() {
        return this.voiceProfileDomainId;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final CallLegType callLeg() {
        return CallLegType.fromValue(this.callLeg);
    }

    public final String callLegAsString() {
        return this.callLeg;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.voiceProfileDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.callLegAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSpeakerSearchTaskRequest)) {
            return false;
        }
        StartSpeakerSearchTaskRequest other = (StartSpeakerSearchTaskRequest)((Object)obj);
        return Objects.equals(this.voiceConnectorId(), other.voiceConnectorId()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.voiceProfileDomainId(), other.voiceProfileDomainId()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.callLegAsString(), other.callLegAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartSpeakerSearchTaskRequest").add("VoiceConnectorId", (Object)this.voiceConnectorId()).add("TransactionId", (Object)this.transactionId()).add("VoiceProfileDomainId", (Object)this.voiceProfileDomainId()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("CallLeg", (Object)this.callLegAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VoiceConnectorId": {
                return Optional.ofNullable(clazz.cast(this.voiceConnectorId()));
            }
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "VoiceProfileDomainId": {
                return Optional.ofNullable(clazz.cast(this.voiceProfileDomainId()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "CallLeg": {
                return Optional.ofNullable(clazz.cast(this.callLegAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSpeakerSearchTaskRequest, T> g) {
        return obj -> g.apply((StartSpeakerSearchTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ChimeSdkVoiceRequest.BuilderImpl
    implements Builder {
        private String voiceConnectorId;
        private String transactionId;
        private String voiceProfileDomainId;
        private String clientRequestToken;
        private String callLeg;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSpeakerSearchTaskRequest model) {
            super(model);
            this.voiceConnectorId(model.voiceConnectorId);
            this.transactionId(model.transactionId);
            this.voiceProfileDomainId(model.voiceProfileDomainId);
            this.clientRequestToken(model.clientRequestToken);
            this.callLeg(model.callLeg);
        }

        public final String getVoiceConnectorId() {
            return this.voiceConnectorId;
        }

        public final void setVoiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
        }

        @Override
        public final Builder voiceConnectorId(String voiceConnectorId) {
            this.voiceConnectorId = voiceConnectorId;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getVoiceProfileDomainId() {
            return this.voiceProfileDomainId;
        }

        public final void setVoiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
        }

        @Override
        public final Builder voiceProfileDomainId(String voiceProfileDomainId) {
            this.voiceProfileDomainId = voiceProfileDomainId;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getCallLeg() {
            return this.callLeg;
        }

        public final void setCallLeg(String callLeg) {
            this.callLeg = callLeg;
        }

        @Override
        public final Builder callLeg(String callLeg) {
            this.callLeg = callLeg;
            return this;
        }

        @Override
        public final Builder callLeg(CallLegType callLeg) {
            this.callLeg(callLeg == null ? null : callLeg.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSpeakerSearchTaskRequest build() {
            return new StartSpeakerSearchTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ChimeSdkVoiceRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSpeakerSearchTaskRequest> {
        public Builder voiceConnectorId(String var1);

        public Builder transactionId(String var1);

        public Builder voiceProfileDomainId(String var1);

        public Builder clientRequestToken(String var1);

        public Builder callLeg(String var1);

        public Builder callLeg(CallLegType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

