/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chimesdkvoice.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chimesdkvoice.ChimeSdkVoiceAsyncClient;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesRequest;
import software.amazon.awssdk.services.chimesdkvoice.model.ListVoiceProfilesResponse;

public class ListVoiceProfilesPublisher
implements SdkPublisher<ListVoiceProfilesResponse> {
    private final ChimeSdkVoiceAsyncClient client;
    private final ListVoiceProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVoiceProfilesPublisher(ChimeSdkVoiceAsyncClient client, ListVoiceProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVoiceProfilesPublisher(ChimeSdkVoiceAsyncClient client, ListVoiceProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVoiceProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVoiceProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVoiceProfilesResponseFetcher
    implements AsyncPageFetcher<ListVoiceProfilesResponse> {
        private ListVoiceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVoiceProfilesResponse> nextPage(ListVoiceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceProfilesPublisher.this.client.listVoiceProfiles(ListVoiceProfilesPublisher.this.firstRequest);
            }
            return ListVoiceProfilesPublisher.this.client.listVoiceProfiles((ListVoiceProfilesRequest)((Object)ListVoiceProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

